// Persistence of Vision Ray Tracer Scene Description File
// File: Sci-fiGen.inc
// Vers: 3.6
// Desc: This file generates random science-fiction-like buidlings.
//       Requirest the following files to be in the same directory:
//       Sci-fiGenTex.inc
//       Deline.jpg
//       Deline02.jpg
//       Deline03.jpg
//       Deline04.jpg
//       Deline05.jpg   
//
//       Create a building using the "Body(Any number, desired height)" macro.  
//       Using the same number for both values will produce the same building
//       every time.  If you want the buildings to look different, be sure to
//       use different numbers. 
//  
// Date: 10/19/2007
// Auth: Kirk Andrews
//

#version 3.6;

#include "colors.inc"
#include "Sci-fiGenTex.inc"


// sets the default texture that objects get when they have no texture specified
#default {
  texture { 
    pigment {color rgb 1} 
    finish{
      ambient 0.0 
      specular .0
      diffuse 0.2
    } 
  }
}

//###################################################################################################################
//########################################## Texture Generators #####################################################
//###################################################################################################################

#macro BfTex(d) 

  #local R2 = seed(d);


  #declare Tex1 =
  texture { 
    pigment {rgb .1+rand(R2)*.3}
    //normal {bumps .1 turbulence .3 scale .01}
    finish {ambient 0 diffuse .3+rand(R2)*.5  specular rand(R2)*.3 metallic}
  }
  
 
  //#declare Tex4 =
  //texture {
  //  pigment {rgb .1+rand(R2)*.3}
  //  finish {specular rand(R2)*.3 metallic reflection .00 ambient 0  diffuse (.3+rand(R2)*.5)}
  //}

#end


#macro BTex(d,Rot) 

  #local R2 = seed(d);
  
  //BfTex(d)

  
  texture {
    image_pattern {
      #switch (int(rand(R2)*6))
        #case (0)  jpeg "Deline.jpg" #break
        #case (1)  jpeg "Deline02.jpg" #break
        #case (2)  jpeg "Deline03.jpg" #break
        #case (3)  jpeg "Deline04.jpg" #break
        #case (4)  jpeg "Deline05.jpg" #break
        #case (5)  jpeg "Deline.jpg" #break
        #else      jpeg "Deline.jpg" 
      #end
    }
    scale <1/Rot, 3, 1>
    warp {repeat y flip y}
    texture_map {
      [0.0  Tex1]
      [0.25  Tex3]
      [0.75  Tex4]
      [1.0  Tex2]
    }
    warp {cylindrical}
  }
#end


#declare DomeTex =
texture {
    pigment {rgb 1 transmit .9} 
    finish{ 
      reflection .5 
      metallic 
      irid{.25 thickness .5}
    }

}

//###################################################################################################################
//########################################## Geometry Generators ####################################################
//###################################################################################################################


//!!!!!!!!!!!!!!!!!!!!!!!!! DOME !!!!!!!!!!!!!!


#macro Dome(Sz)
  difference {
    sphere {
      0,Sz 
    }
    plane {y,0}
    sphere {0,Sz-.15}
  
    scale (.25+rand(R1))*y 
     
  }
#end  

//!!!!!!!!!!!!!!!!!!!!!!!!! BRACE !!!!!!!!!!!!!!


#macro Brace (d,DDog,BDog) //Random Seed, Controls thickness of brace, Controls angle of brace
difference {
  lathe {
    quadratic_spline 
    7
    <1.75,-100>,
    <1.75,-50>,
    <1.75,-25>,
    <1.75,-20>, 
    <1.75,-10>,
    <1.75,  0>,
    <1, 4>
    //<0,  5>
    sturm
  }
  //#local DDog = rand(RX)*.4;
  sphere {0*y,1.5+DDog}
  cylinder {0*y,-110*y,1.5+DDog}
  plane {x,-1}
  plane {x, 1 inverse}
  plane {z,0}
  translate -4*y
  scale .05*x
  scale BDog*y 
  texture {DHull}
}
#end  

//!!!!!!!!!!!!!!!!!!!!!!!!! SUPPORT !!!!!!!!!!!!!!


#macro RSupport(d,DSa,H)

  #local R1 = seed(d);      
  #local M = int(H+(rand(R1)*2));
  #local i = 0;
  #local L = .15;
  intersection {
    union {
      lathe {
        cubic_spline 
        M+4, // number of points
          <2+L,-2>,
          <1+L,-1>,
          #while (i<M)
            <.2+sqrt(rand(R1))+L,i+rand(R1)>,
            #local i = i+1;
          #end
          #local SphSz = .1+rand(R1)*2;
          <SphSz+L, i+1>,
          <0, i+1.5>   
      }
      
      #if (DSa>1)
         #local Null = rand(R1); //to make up for the extra random call in the Dome macro 
      #else
          object{Dome(SphSz+L) translate (i+1)*y}
      #end
    }
     
    plane {x, 1}
    plane {x,-1 inverse}
    plane {z,0}
    scale .1*x 
    texture {DHull}
  }

#end

//!!!!!!!!!!!!!!!!!!!!!!!!! BAY !!!!!!!!!!!!!!

// The Balcony

#macro Bay(d)
  #local B = .1+.1*rand(RX); 
  #local A = 1+rand(RX); 
  union {
    union {
      torus { A, B }
      cylinder {-B*y,B*y,A}
      texture {
        gradient y
        texture_map {
          [0.0 Bex1]
          [0.1 Bex1]
          [0.1 DHull]
          [1.0 DHull]
        }
        warp {repeat y flip y}  
      }
      scale .25*y
      translate 2*x
    }
    union {
      cylinder {0,2*x,A*.5}
      sphere {2*x, A*.5}
      scale .25*y
      translate -.25*y
    }
  } 


#end


//!!!!!!!!!!!!!!!!!!!!!!!!! PATH !!!!!!!!!!!!!!

#macro Path(d,Rot)
  #local B = .2+rand(RX)*.6; 
  #local A = .5+rand(RX); 

  union {
    torus {A,B}
    #local i = 0;
    #while (i<Rot)
      cylinder {A*x,0,B/2 rotate 90*y rotate i*(360/Rot)*y}
      #local i = i+1;
    #end
    texture {
      gradient y
      texture_map {
        [0.0 DHull]
        [0.5 Test]
        [0.5 DomeTex]
        [1.0 DomeTex]
      }
      translate -.5*y
      scale 3*y
    }
    scale (.5)*y
         
  
  }
  
#end

//!!!!!!!!!!!!!!!!!!!!!!!!! COCOON !!!!!!!!!!!!!!

#macro Cocoon(d,Y,SZ)
  union {
    difference {
      sphere {0,1}
      plane {y,.5 rotate -45*z inverse}
      scale Y*y
      scale SZ
      material {BTex(d,int(5+rand(RX)*3))}
    }
    sphere {0,.98 scale Y*y scale SZ texture{DomeTex}}
  }
#end

//################################################################### MAIN ##################################


#macro Body(d,H)                        // d:  random seed--if you plug in the same two numbers everytime, you'll get the same building everytime.
                                        // H:  Approximate height of the building.  

  #local R1 = seed(d);                  // It is essential that "R1" only be used for determining the lathe structure
  #local RX = seed(d+1);                // All other random elements use "RX"
  #local M = int(H+(rand(R1)*2));       // Determines the height of the Building
  #local i = 0;
  #local Rot = int(5+rand(RX)*3);       // Determines the number of times the pattern will repeat around the building
  #local DS = int(rand(RX)*2);          // Used to determine whether or not the dome will have supports
  BfTex(d)                              // Establishes a base texture for the building
  
  
  union {
    // Creates the basic shape of the building: the essence of the macro
    lathe {
      cubic_spline 
        M+4,                            // number of points
        <2,-2>,
        <1,-1>,
        #while (i<M)
          <.2+sqrt(rand(R1)),i+rand(R1)>,
          #local i = i+1;
        #end
        #local SphSz = .1+rand(R1)*2;
        <SphSz, i+1>,
        <0, i+1.5>   
     material {BTex(d,Rot)}             // Creates the texture
      
    }
    
    // Place a dome on top
    object{Dome(SphSz) texture {DomeTex} translate (i+1)*y} 
    
    
    // Generate supporting ridges along the surface of the building
    #if (rand(RX)>.5)
      union {
        #local i = 0;
        #while (i<Rot)
          object{ RSupport(d,DS,H) rotate 90*y rotate i*(360/Rot)*y}
          #local i = i + 1;
        #end
      }
    #end
    
    
    // Generate Butresses the seperate from the structure
    #if (rand(RX)>.6)
      union {
        #local i = 0;
        #local DDog = rand(RX)*.25;
        #local BDog = rand(RX)+.25;
        #while (i<Rot)
          object{ Brace(d,DDog,BDog) rotate 90*y rotate i*(360/Rot)*y }
          #local i = i + 1;
        #end
        translate rand(RX)*(H-1)*y
      }
    #end
    
    
    //  Add balconies
    #if (rand(RX)>.5)
      union {
        #local i = 0;
        #local DDog = .2+rand(RX)*.4;
        #while (i<Rot)
          object{Bay(d) scale DDog rotate 90*y rotate i*(360/Rot)*y }
          #local i = i + 2;
        #end
        translate rand(RX)*M*y
      }
    #end
    
    
    // Add toroidal, domed structures around the building
    #local i = 0;
    #local MPath = int(rand(RX)*5.5);
    #while (i<MPath)
      union {
        object{Path(d,Rot)}
        translate rand(RX)*H*y
      }
      #local i = i+1;
    #end
    
    
    //  Add spherical "Cocoons" hanging on to the building
    #if (rand(RX)>.2)
      union {
        #local i = 0;
        #local DDog = 1+rand(RX)*3;
        #local BDog = .2+rand(RX)*.5;
        #while (i<Rot)
          object{Cocoon(d,DDog,BDog) translate (1-(BDog*.5))*x rotate 90*y rotate i*(360/Rot)*y }
          #local i = i + 1;
        #end
        translate rand(RX)*M*y
      }
    #end
    

    
    //scale (1+rand(R1))*y
  }

#end

//###################################################################################################################
//##########################################     SCENE     ##########################################################
//###################################################################################################################

//Atmosphere

//light_source {
//  <0, 0, 0>            // light's position (translated below)
//  color rgb <1, .8, .5>  // light's color
//  translate <-300, 100, 100>
//}
//
//light_source {
//  <0, 0, 0>            // light's position (translated below)
//  color rgb <.1, .0, .1>*.5  // light's color
//  translate < 300, -100, -100>
//  shadowless
//}
//
//
//fog {
//  fog_type   2
//  distance   100
//  color      rgb <1,1,.9> // gray
//  fog_offset 0.1
//  fog_alt    6.2
//  turbulence 0.8
//}
//
//sky_sphere {
//  pigment {
//    gradient y
//    color_map {
//      [0.0 rgb <1,.7,.4>]
//      //[0.2 rgb <0,0,.2>] 
//      [0.7 rgb <0,0,.02>]
//    }
//  }
//}
//
////#################################################################
//
//#declare RR = seed(8);
//
//#declare X=0;
//#declare Z=0;
//#declare XM = 4;
//#declare ZM = 20;
//union {
//  #while (X<XM)
//    #while (Z<ZM)
//      object {Body(rand(RR)*10000, 20+rand(RR)*20) translate <X,0,Z>*5}
//      #declare Z=Z+1;
//    #end
//    #declare Z=0;
//    #declare X=X+1;
//  #end
//}               
//
//camera {
//  location  < 2.5, 23.0, - 5.0>
//  look_at   < 2.7, 25.0,  10.0>
//  right     x*image_width/image_height
//}
