// Persistence of Vision Ray Tracer Scene Description File
// File: Example.pov
// Vers: 3.6
// Desc: Example Scene using Sci-fiGen.inc
// Auth: Kirk Andrews
//

#version 3.6;

#include "colors.inc"
#include "Sci-fiGen.inc"

global_settings {
  assumed_gamma 1.0
}

//###################################################################################################################
//##########################################     SCENE     ##########################################################
//###################################################################################################################

//Atmosphere

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, .8, .5>  // light's color
  translate <-300, 100, 100>
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <.1, .0, .1>*.5  // light's color
  translate < 300, -100, -100>
  shadowless
}


fog {
  fog_type   2
  distance   100
  color      rgb <1,1,.9> // gray
  fog_offset 0.1
  fog_alt    6.2
  turbulence 0.8
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <1,.7,.4>]
      //[0.2 rgb <0,0,.2>] 
      [0.7 rgb <0,0,.02>]
    }
  }
}

//#################################################################

#declare RR = seed(8); //Try different values here for completely different sets of buildings.

#declare X=0;
#declare Z=0;
#declare XM = 4;
#declare ZM = 20;
union {
  #while (X<XM)
    #while (Z<ZM)
      object {
        Body(rand(RR)*1000, 20+rand(RR)*20) 
        translate <X,0,Z>*5
      }
      #declare Z=Z+1;
    #end
    #declare Z=0;
    #declare X=X+1;
  #end
}               

camera {
  location  < 2.5, 23.0, - 5.0>
  look_at   < 2.7, 25.0,  10.0>
  right     x*image_width/image_height
}