#include "pumpkin.inc"

camera { 
  rotate y*0
  location <0,1,-5> // 0,7,-25
//   up y right x*16/9 //use 16:9 aspect ratio
   right x*image_width/image_height
  look_at <0,0,0>
  translate <0,-.3,3>
}



light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>+0.2    // light's color
  translate <-20, 40, -20>*20
}





#declare Pumpkin_Seed                = seed(.125);


    #declare Pumpkin_InternalTexture = texture { 
      pigment {color rgb <1,0.8,0>} 
      normal {bumps scale 0.001}
      finish {phong 0.1}
    }

    #declare Pumpkin_ExternalTexture = texture { 
      pigment {color rgb <1,0.5,0>} 
      normal {average
        normal_map {
          [2 crackle]
          [1 bumps scale 0.0005]   
        }
        scale 0.02}
      finish {phong 0.3}
    }

    #declare Pumpkin_FaceHoles = union {
      // Now we hollow out the inside
      sphere {<0,0,0>,0.40 scale <1.02,0.9,1.02>}
      texture {Pumpkin_InternalTexture translate 100*Pumpkin_Seed}
    }



    

#declare Pumpkin_Segments            = 12; 
#declare Pumpkin_FaceHolesOn         = 1;
#declare Carving                     = 1;  
#declare Pumpkin_LightsOn            = 0;  
#declare Pumpkin_SegmentType         = "Blob";      // "Blob"=More realistic or "Sphere"=Quick to render
#declare Pumpkin_SegmentPerturbation = 1;           // 0=Not very perturbed, 1=Very perturbed, 2=Deformed
#declare MyBumpyPumpkin              = union {Pumpkin()}

  

#declare pumpkin = object {MyBumpyPumpkin  rotate y*10  translate <0,0.36,0> scale 1}


#declare carving1 = height_field {
  png
  "carving1.png"
  water_level .5
  texture {Pumpkin_InternalTexture translate 100*Pumpkin_Seed}
  scale <2,2,-2>
  rotate x*90
  scale <.35,.35,.4>
  translate <-.4,-.0,-1>
}

difference {
  union {pumpkin}
  #if (Carving)
    union {carving1}
  #end
}


light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>+1    // light's color
  translate <0,.2,0>
}