/*

******************************************************************************
Triangulation.inc      ABC=vectors abc=floats 

3D Macros:
  incenter(A,B,C)
  centroid(A,B,C)
  ccenter(A,B,C)                   circumcenter
  orthocenter(A,B,C)
  normal_vector(A,B,C)
  midpoint(A,B)

  rotation(r,axis,point)
  _rotate(sine,cosine,axis,point)  
  
  circumradius(A,B,C)              float
  inner_radius(A,B,C)              float
  radang3(A,B,C)                   Angle at B in radians
  

Functions:
  inneradius(a,b,c)      3 lens
  outeradius(a,b,c)
  
  sss_area(a,b,c)
  sas_area(s,a,s2)
  bh_area(b,h)           Base Height

  sss_height(a,b,c)      height to side2
  sas_cos(s,a,s2)        Side Angle Side - solve length of missing side

  aas_sin(a,b,s)         AAS solve opposing side of angle2 (b)
  asa_sin(a,s,b)         ASA solve opposing side of angle2 (b)
  sss_cos(a,b,c)         SSS solve angle opposite side2    (b)
  ssa_acute(s,s2,a)      SSA solve angle opposite side2 
  

Float Macros:
  ssa_obtuse(s,s2,a)
  sa_height(s,a)         Side Angle unknown base
  _clamp(a,n,m)

  
Matrix:  
  pop_matrix(A,B,C)                   Matrix Transform (Shear_Trans())
  rotate_matrix(r,axis)               Rotate ID Matrix (Axis_Rotate_Trans())
  
  rotate_matrix_M(r,axis,A,B,C)       Rotate Matrix
  rotate_matrix_T(r,axis,A,B,C,T)     Rotate Matrix Translate
       
    alphaQuad 10-2007
*******************************************************************************

*/
#version 3.5;
//#include "math.inc"

#macro incenter1(A,B,C)
      #local c = vlength(A-B);
      #local a = vlength(B-C);
      #local b = vlength(C-A);
      #local d = (a+b+c);
  #local result = 
      <((a*A.x) + (b*B.x) + (c*C.x))/d,
       ((a*A.y) + (b*B.y) + (c*C.y))/d,
       ((a*A.z) + (b*B.z) + (c*C.z))/d>;
  result
#end

#macro incenter(A,B,C)
      #local a = C*vlength(A-B);
      #local b = A*vlength(B-C);
      #local c = B*vlength(C-A);
      #local d = vlength(A-B)+
                 vlength(B-C)+
                 vlength(C-A);
  #local result = (a+b+c)/d;     
  result
#end
#macro centroid(A,B,C)
  #local result = (A+B+C)/3;
  result
#end

#macro circumcenter(A,B,C)
      #local a = vlength(A-B);
      #local b = vlength(B-C);
      #local c = vlength(C-A);
      #local sp = (a+b+c)*0.5;

   #local cosineR = ((b*b + c*c - a*a)/(2*b*c))*
      a*b*c/(4*sqrt(sp*(sp-a)*(sp-b)*(sp-c))); //circumradius(A,B,C);
   #local mp = (A+B)/2; //midpoint(A,B)
   #local result = mp+(vnormalize(vcross(A-mp,vcross(C-B,A-B)))*cosineR);
   result
   /* "walks" to cCenter in 3D.
      Algebra core step=cos(angle)*R.
      Input order irrelevant since both (A-mp)
      and norm vectors reverse in sync */
#end

#macro outcenter(A,B,C)
   circumcenter(A,B,C)
#end 
#macro ccenter(A,B,C)
   circumcenter(A,B,C)
#end 

#macro orthocenter(A,B,C)
      #local a = vlength(A-B);
      #local b = vlength(B-C);
      #local c = vlength(C-A);
      #local sp = (a+b+c)*0.5;

   #local cosineR = ((b*b + c*c - a*a)/(2*b*c))*
      a*b*c/(4*sqrt(sp*(sp-a)*(sp-b)*(sp-c))); //outeradius(a,b,c);
   #local mp = (A+B)/2; //midpoint(A,B)
   #local cc = mp+(vnormalize(vcross(A-mp,vcross(C-B,A-B)))*cosineR);
   
   #local result = ((A-cc)+(B-cc)+(C-cc)) + cc;
   result
#end

#macro inner_radius(A,B,C)
      #local a = vlength(A-B);
      #local b = vlength(B-C);
      #local c = vlength(C-A);
   #local result = 0.5*sqrt(((b+c-a)*(c+a-b)*(a+b-c)) / (a+b+c));
   result      
#end
      
#declare inneradius = function(a,b,c) {
   //(3 lens)
   0.5*sqrt(((b+c-a)*(c+a-b)*(a+b-c)) / (a+b+c))
}
#macro circumradius(A,B,C)
      #local a = vlength(A-B);
      #local b = vlength(B-C);
      #local c = vlength(C-A);
   #local result = a*b*c/(4*sqrt(((a+b+c)/2)*(((a+b+c)/2)-a)*
                   (((a+b+c)/2)-b)*(((a+b+c)/2)-c)));
   result      
#end

#declare outeradius = function(a,b,c) {
  //(3 lens)
  a*b*c/(4*sqrt(((a+b+c)/2)*(((a+b+c)/2)-a)*(((a+b+c)/2)-b)*(((a+b+c)/2)-c)))
  //(a*b*c) / (4*sss_area(a,b,c))  
}

#declare sas_area = function(s,a,s2) {
   0.5 * s * sin(a) * s2
}

#declare sas_cos = function(s,a,s2) {
   sqrt((pow(s,2)+pow(s2,2))-2*s*s2*cos(a))
} // Side Angle Side - solve length of missing side


#declare sas_height = function(s,a,s2) {
    s*sin(a)*s2/sqrt((pow(s,2)+pow(s2,2))-2*s*s2*cos(a))
   //sas_area(s,a,s2) / (sas_cos(s,a,s2) * 0.5)
} // SAS height to missing side


#declare bh_area = function(b,h) {
   //(base,height)
   0.5 * b * h
}

#declare sss_height = function(a,b,c) {
  sqrt(((a+b+c)/2)*(((a+b+c)/2)-a)*(((a+b+c)/2)-b)*(((a+b+c)/2)-c))/(b*0.5)
  //sss_area(a,b,c) / (b * 0.5)
} // height to side2

#declare sss_area = function(a,b,c) {
   //semi perimeter
   sqrt(((a+b+c)/2)*(((a+b+c)/2)-a)*(((a+b+c)/2)-b)*(((a+b+c)/2)-c))
}

#declare vmyv = function {
   transform {
     rotate <0, 0, 0>
     scale 1
   }
}

#declare aas_sin = function(a,b,s) {
   sin(b) * (s / sin(a))
} // AAS solve opposing side of angle2 (b)

#declare asa_sin = function(a,s,b) {
   sin(b) * (s / sin(pi-(a+b)))
} // ASA solve opposing side of angle2 (b)

#declare sss_cos = function(a,b,c) {
   acos((pow(a,2)+pow(c,2)-pow(b,2))/(2*a*c))
} // SSS solve angle opposite side2 (b)
  // if (pow(a,2)+pow(c,2)-pow(b,2))/(2*a*c) < 0 obtuse

#declare ssa_acute = function(s,s2,a) {
   asin(s2*sin(a)/s)
} // SSA solve angle opposite side2

/*
alias sss_area2 {
  ; (3 lens)
  return $calc(0.5 * ($1 + $2 + $3) * $inneradius($1,$2,$3))
}
alias sss_area3 {
  ; (3 lens)
  return $calc(($1 * $2 * $3) / (4 * $circumradius($1,$2,$3)))
}*/

/* help file stuff
#declare Count=0;
 #while (Count < 5)
  object { MyObject translate x*3*Count }
  #declare Count=Count+1;
 #end
*/
/*
  2*area/(a+b+c) where side lens are abc
  distance(D) of o(circumcenter) and i(incenter) = D = sqrt(R(R-2r)) R=outer or circumrad
  if circumcenter O has coordinates (0,0)
  then orthocenter H has coordinates ( x1+x2+x3 , y1+y2+y3 )
  if ABC lie on the unit circle, we have: (a1)^2 + (b1)^2 = (a2)^2 + (b2)^2 = (a3)^2 + (b3)^2 = 1 */


/*
%tri.a 383 156
%tri.b 645 254
%tri.c 465 289
%tri.ab 279.72843974111748
%tri.bc 183.3712082089225
%tri.ca 156.24659996300718
%tri.ang.a 0.660369
%tri.ang.b 0.549982
%tri.ang.c 1.931241
  //e $ssa-obtuse(156.24659,279.728439,0.549982) == 1.931241 */
#macro ssa_obtuse(s,s2,a)
  // SSA solve ang opposite side2
  #local h = sin(a) * s2;
  #if (h = s2) // given right angle
     #local result = asin(h/s);
  #else
     #if (h = s) // right triangle solved
        #local result = pi/2;
     #else
        #if (s = s2) // isosceles triangle
           #local result = a;
        #else
  // if (s < h) // no solution return no solution
  // if ((%h < $1) && ($1 < $2)) _e two distinct solutions
  // if 3 sides known:
  // if (pow(a,2)+pow(c,2)-pow(b,2))/(2*a*c) < 0 obtuse sss_cos
  //obtuse
  #local result = pi - asin(h/s);
  #end
  #end
  #end
  result
#end

#macro sa_height(s,a)
// (side,angle) unknown base
  #local h = sin(a) * s;
  #if (a < pi)
     #local result = h;
  #else
     #local result = 0;
  #end
  result
#end
#macro _clamp(a,n,m)
   #local result = a;
   #if (a < n) #local result = n;
   #end
   #if (a > m) #local result = m;
   #end
   result
#end

#macro normal_vector(A,B,C)
  vcross(C-B,A-B)
 // 1
 // |
 // 2__ 3 vz points at you (neg) unless reverse y like pov, then
 //
 // 2__ 3
 // |
 // 1
#end


// functions must appear first, but not macros
// no function dependency, order irrelevant
// no operation redundancy
// no unnecessary stack set
// if result not set, available to macros but failed to echo to message tab
#macro midpoint(A,B)
  #local result = (A+B)/2;
  result
#end

#macro rotation(r,axis,point)

        #local s = sin(r);
	#local cs = cos(r);
	#local d = vlength(axis);
	#if (d = 0) #local d = 1.0;
	#end 

	#local a = axis.x/d;
	#local b = axis.y/d;
	#local c = axis.z/d;

	#local xx = a * a;
	#local yy = b * b;
	#local zz = c * c;
	#local xy = a * b;
	#local yz = b * c;
	#local zx = c * a;
	#local xs = a * s;
	#local ys = b * s;
	#local zs = c * s;
	#local one_c = 1.0 - cs;

	#local a = point.x * ((one_c * xx) + cs);
	#local b = point.x * ((one_c * xy) - zs);
	#local c = point.x * ((one_c * zx) + ys);

	#local a = a + point.y * ((one_c * xy) + zs);
	#local b = b + point.y * ((one_c * yy) + cs);
	#local c = c + point.y * ((one_c * yz) - xs);

	#local a = a + point.z * ((one_c * zx) - ys);
	#local b = b + point.z * ((one_c * yz) + xs);
	#local c = c + point.z * ((one_c * zz) + cs);

#local result = <a,b,c>;
result
#end
#macro _rotate(sine,cosine,axis,point)

	#local d = vlength(axis);
	#if (d = 0) #local d = 1.0;
	#end 

	#local a = axis.x/d;
	#local b = axis.y/d;
	#local c = axis.z/d;

	#local xx = a * a;
	#local yy = b * b;
	#local zz = c * c;
	#local xy = a * b;
	#local yz = b * c;
	#local zx = c * a;
	#local xs = a * sine;
	#local ys = b * sine;
	#local zs = c * sine;
	#local one_c = 1.0 - cosine;

	#local a = point.x * ((one_c * xx) + cosine);
	#local b = point.x * ((one_c * xy) - zs);
	#local c = point.x * ((one_c * zx) + ys);

	#local a = a + point.y * ((one_c * xy) + zs);
	#local b = b + point.y * ((one_c * yy) + cosine);
	#local c = c + point.y * ((one_c * yz) - xs);

	#local a = a + point.z * ((one_c * zx) - ys);
	#local b = b + point.z * ((one_c * yz) + xs);
	#local c = c + point.z * ((one_c * zz) + cosine);

#local result = <a,b,c>;
result
#end
#macro pop_matrix(A, B, C)
   transform {
      matrix <A.x, A.y, A.z,
              B.x, B.y, B.z,
              C.x, C.y, C.z, 0, 0, 0>
   }
#end
#macro rotate_matrix(r,axis)
   // ID matrix
   #local vX = rotation(r,axis,x);
   #local vY = rotation(r,axis,y);
   #local vZ = rotation(r,axis,z);
   transform {
      matrix <vX.x,vX.y,vX.z,
              vY.x,vY.y,vY.z,
              vZ.x,vZ.y,vZ.z, 0,0,0>
   }
#end
#macro rotate_matrix_M(r,axis,A,B,C)
   #local vX = rotation(r,axis,A);
   #local vY = rotation(r,axis,B);
   #local vZ = rotation(r,axis,C);

   transform {
      matrix <vX.x,vX.y,vX.z,
              vY.x,vY.y,vY.z,
              vZ.x,vZ.y,vZ.z, 0,0,0>
   }
#end
#macro rotate_matrix_T(r,axis,A,B,C,T)
   #local vX = _rotate(sin(r),cos(r),axis,A);
   #local vY = rotation(r,axis,B);
   #local vZ = rotation(r,axis,C);
   
   transform {
      matrix <vX.x,vX.y,vX.z,
              vY.x,vY.y,vY.z,
              vZ.x,vZ.y,vZ.z, T.x,T.y,T.z>
   }
#end
#declare deg2rad = function(d) {
 d / 57.295779513082323
 //radians()
}
#declare rad2deg = function(r) {
 r * 57.295779513082323
 //degrees()
}

#macro radang3(A,B,C)
   // input is 3 points in 3D -- points to A and C, angle at B
   #declare result = 
   acos(_clamp(vdot(vnormalize(A-B),vnormalize(C-B)), -1.0, 1.0));
   result
#end
/*

******************************************************************************
Triangulation.inc      ABC=vectors abc=floats

3D Macros:
  incenter(A,B,C)
  centroid(A,B,C)
  ccenter(A,B,C)                   circumcenter
  orthocenter(A,B,C)
  normal_vector(A,B,C)
  midpoint(A,B)

  rotation(r,axis,point)
  _rotate(sine,cosine,axis,point)  
  
  circumradius(A,B,C)              float
  inner_radius(A,B,C)              float
  radang3(A,B,C)                   Angle at B in radians
  

Functions:
  inneradius(a,b,c)      3 lens
  outeradius(a,b,c)
  
  sss_area(a,b,c)
  sas_area(s,a,s2)
  bh_area(b,h)           Base Height

  sss_height(a,b,c)      height to side2
  sas_cos(s,a,s2)        Side Angle Side - solve length of missing side

  aas_sin(a,b,s)         AAS solve opposing side of angle2 (b)
  asa_sin(a,s,b)         ASA solve opposing side of angle2 (b)
  sss_cos(a,b,c)         SSS solve angle opposite side2    (b)
  ssa_acute(s,s2,a)      SSA solve angle opposite side2 
  

Float Macros:
  ssa_obtuse(s,s2,a)
  sa_height(s,a)         Side Angle unknown base
  _clamp(a,n,m)

  
Matrix:  
  pop_matrix(A,B,C)                   Matrix Transform (Shear_Trans())
  rotate_matrix(r,axis)               Rotate ID Matrix (Axis_Rotate_Trans())
  
  rotate_matrix_M(r,axis,A,B,C)       Rotate Matrix
  rotate_matrix_T(r,axis,A,B,C,T)     Rotate Matrix Translate
       
    alphaQuad 10-2007
*******************************************************************************

*/