#include "colors.inc"

#include "triangulation.inc"
#include "debug.inc"
Set_Debug(off)


#declare p1 = <-5,-3,0>+(<410, 100, 0>/80);
#declare p2 = <-5,-3,0>+(<675, 350, 0>/80);
#declare p3 = <-5,-3,0>+(<188, 453, 0>/80);
#declare cc = ccenter(p1,p2,p3);
#declare ic = incenter(p1,p2,p3);
#declare ct = centroid(p1,p2,p3);
#declare oc = orthocenter(p1,p2,p3);

#declare p4 = p2+vnormalize(p1-p2)* asa_sin(radang3(p1,p2,ic),
              vlength(ic-p2),(pi/2)-radang3(p1,p2,ic));
              
#declare p5 = p3+vnormalize(p2-p3)* asa_sin(radang3(p2,p3,ic),
              vlength(ic-p3),(pi/2)-radang3(p2,p3,ic));

#declare p6 = p1+vnormalize(p3-p1)* asa_sin(radang3(p3,p1,ic),
              vlength(ic-p1),(pi/2)-radang3(p3,p1,ic));                            



#declare p7 = p2+vnormalize(p1-p2)* asa_sin(radang3(p1,p2,oc),
              vlength(oc-p2),(pi/2)-radang3(p1,p2,oc));
              
#declare p8 = p3+vnormalize(p2-p3)* asa_sin(radang3(p2,p3,oc),
              vlength(oc-p3),(pi/2)-radang3(p2,p3,oc));

#declare p9 = p1+vnormalize(p3-p1)* asa_sin(radang3(p3,p1,oc),
              vlength(oc-p1),(pi/2)-radang3(p3,p1,oc));
 
#declare oc_tri=
union{
   cylinder{p7,oc,.05}
   cylinder{p8,oc,.05}
   cylinder{p9,oc,.05}
}

#declare ic_tri=
union{
   cylinder{p4,ic,.05}
   cylinder{p5,ic,.05}
   cylinder{p6,ic,.05}
}
#declare tri=
union{
   cylinder{p1,p2,.05}
   cylinder{p3,p2,.05}
   cylinder{p1,p3,.05}
}
#declare ct_tri=
union{   
   cylinder{(p1+p2)*.5,ct,.05}
   cylinder{(p2+p3)*.5,ct,.05}
   cylinder{(p1+p3)*.5,ct,.05}
}
#declare cc_tri=
union{   
   cylinder{(p1+p2)*.5,cc,.05}
   cylinder{(p2+p3)*.5,cc,.05}
   cylinder{(p1+p3)*.5,cc,.05}
}
object {
   oc_tri
   texture {
     pigment{ CadetBlue }
     finish { ambient .4 }
   }
}
object {
   cc_tri
   texture {
     pigment{ Blue }
     finish { ambient .4 }
   }
}
object {
   ic_tri
   texture {
     pigment{ Red }
     finish { ambient .4 }
   }
}
object {
   ct_tri
   texture {
     pigment{ Green }
     finish { ambient .4 }
   }
}
object {
   tri
   texture {
     pigment{ White }
     finish { ambient .4 }
   }
}
sphere {
    p1 0.2
    texture {
       pigment{ White }
       finish { ambient .4 }
     }
}
sphere {
    p2 0.2
    texture {
       pigment{ White }
       finish { ambient .4 }
     }
}
sphere {
    p3 0.2
    texture {
       pigment{ White }
       finish { ambient .4 }
     }

}
sphere {
    ccenter(p1,p2,p3) 0.1
    //circumradius(p1,p2,p3) + 0.09
    texture {
       pigment{ Blue }
       finish { ambient .4 }
     }
}
sphere {
    centroid(p1,p2,p3) 0.1
    texture {
       pigment{ Green }
       finish { ambient .4 }
     }
}
sphere {
    incenter(p1,p2,p3) 0.1
    //inner_radius(p1,p2,p3)
    texture {
       pigment{ Red }
       finish { ambient .4 }
     }
}
sphere {
    orthocenter(p1,p2,p3) 0.1
    texture {
       pigment{ CadetBlue }
       finish { ambient .4 }
     }
}
camera {
    location <0, 0, -20>
    look_at <0, 0, 0>
    rotate <0,0,0>
    angle 33
}

/*
%tri.a 410 100
%tri.b 675 350
%tri.c 188 453
%tri.ab 364.3144246389374
%tri.bc 497.77304065206266
%tri.ca 417.00479613548811
%tri.ang.a 1.375912
%tri.ang.b 0.964707
%tri.ang.c 0.800972
*/

light_source { <20, 20, -20> color White*1.5 }
light_source { <-20, -20, -20> color White*1 }
 
   /* If eliptical curve:
   Input known x or y and radii into quad curve func:
   Fx: X + (Y*R/B) = R  r=xwidthradius b=yheightofarc and r==b for circle
   x=sqrt(r - (y*r/b)) y=sqrt(r - x) * (b/r) */