// Persistence of Vision Ray Tracer 3.5
// File: LightDomeExample.pov
// Desc: Example scene for LightDome macro
// Date: April 2007
// Auth: Trevor G Quayle

#version unofficial megapov 1.21;

#declare Rad = no;
#declare Pho = no;

global_settings {
  charset utf8
  ambient_light 1
  adc_bailout 0.001 
  max_trace_level 25
  #if (Rad)
    radiosity{
      pretrace_start 0.04
      pretrace_end   0.02
      count 100
      nearest_count 5
      error_bound 1.0
      recursion_limit 2
      low_error_factor .5
      minimum_reuse 0.01
      brightness 1
      adc_bailout 0.01
      normal on
      media on
    }
  #end
  #if (Pho)
    photons{
      count 5000000 
      autostop 0
    }       
  #end
}

#declare LO=<0,100,-250>;
#declare LA=<0,10,0>;

camera{
  up y
  right x*image_width/image_height
  angle 60
  location LO
  look_at  LA
}                           

#default{finish{ambient 0 diffuse 0.7}}

#macro MGlass(Pig)
  texture{
    pigment{Pig}
    finish{
      conserve_energy
      diffuse 0
      ambient 0
      reflection{0 1 fresnel on metallic 0}
    }
    normal{bumps .01 scale 2}
  }
  interior{
    ior 1.51
    caustics 1
    fade_distance 30
    fade_power 1000
  }
#end

#macro MPlastic(Pig,Pior)
  texture{
    pigment{Pig}
    finish{ambient 0
      diffuse 0.6
      conserve_energy
      reflection {0 1 metallic 0 fresnel on}
    }
  }
  interior{ior Pior}
#end


#macro MMetal(Pig,Pior)
  texture{
    pigment{Pig}
    finish{ambient 0
      diffuse 0
      conserve_energy
      reflection {0 1 metallic 1 fresnel on}
    }
  }
  interior{ior Pior}
#end

#macro MDiff(Pig)
  texture{
    pigment{Pig}
    finish{ambient 0
      diffuse 0.6
    }
  }
#end


#declare MP1=material{MPlastic(rgb <0.038, 0.033, 0.202>,1.46)}
#declare MP2=material{MPlastic(rgb <0.8,0,0>,1.26)}
#declare MD1=material{MDiff(rgb 0.6)}
#declare MB1=material{MMetal(rgb <0.578,0.422,0.195>,25)}
#declare MC1=material{MMetal(rgb 0.8,25)}
#declare MG1=material{MGlass(rgbf <0.85,0.95,0.94,1>)}

#declare MRC=
material{
  texture{
    pigment{rgb 0.8}
    finish{ambient 0 diffuse 0
      reflection {0 1
        fresnel on
        metallic 1
      }
    }
  }
  texture{
    pigment {
      granite
      color_map {
        [0.05 rgb <0.89, 0.51, 0.28>]
        [0.10 rgb <0.70, 0.13, 0.00>]
        [0.15 rgb <0.69, 0.41, 0.08>]
        [0.20 rgb <0.49, 0.31, 0.28>]
        [0.25 rgb <0.89, 0.51, 0.28>]
        [0.25 rgbt 1]
      }
    }
    finish {ambient 0 diffuse 0.4}
    scale 7
  }
  interior{ior 25}
}

union{
  sphere{<-40,40,40>, 40  material{MC1} photons{target refraction off reflection on}}
  sphere{<55,45,-10>, 45  material{MP1} photons{target refraction off reflection on}}
  sphere{<20,10,-110>, 10 material{MG1} photons{target refraction on  reflection on collect off}}
  sphere{<-20,20,-95>, 20 material{MB1} photons{target refraction off reflection on}}
  sphere{<60,15,-80>, 15  material{MRC} photons{target refraction off reflection on}}
  sphere{<-70,20,-40>, 20 material{MP2} photons{target refraction off reflection on}}
  union{
    cylinder{<0,-16,0>,<0,0,0>,120}
    torus{120,8 translate -y*8}
    material{MD1}
    photons{target refraction off reflection off}
  }
} 


#include "LightDome.inc"

#declare Map="MyOfficeSmall.hdr";   //HDR to be used - must be Lat/Long mapping type
#declare n=<2,5,100>;               //2 areas per level, median cut level 5 (2^5=32 light sources), pixelize HDR by 100 (100x200 pixels)
#declare FStops=0;                  //FStop brightness adjustment
#declare AutoBR=false;              //Auto brightness off
#declare BR=0;                      //Brightness adjustment off - use FStops
#declare TH=0.0;                    //Brightness threshold clipping off
#declare Hor=0.5;                   //Horizon level clipping at 50% HDR map height
#declare LSiz=4;                    //Use 4x4 area lights
#declare AutoLI=true;               //Auto light intenstiy on
#declare LI=1;                      //Light intensity mulitplier
#declare Jit=0.2;                   //Add random jitter
#declare yRot=90;                   //Dome rotation around y-axis
#declare CTR=<0,0,0>;               //Light dome centred at <0,0,0>
#declare LDObj=sphere{-CTR,12000}   //Light dome lights placed on 12000 radius sphere
#declare SS=true;                   //Light dome sky sphere visible (LDObj)
#declare VL=0;                      //Visible light sources off
#declare PO=true;                   //Light dome photons off
#declare Eval=0;                    //Evaluation mode off
#declare EP=0;                      //Use rectangular projection (n/a, evaluation mode off)
#declare CVT=<0,100,5>;             //Centroidal voronoi tesselation off
#declare RB=<0.95,0>;               //Clipped area rebuilding off

LightDome(Map,n,FStops,AutoBR,BR,TH,Hor,LSiz,AutoLI,LI,Jit,yRot,CTR,LDObj,SS,VL,PO,Eval,EP,CVT,RB)
