#macro LightDome(Map,n,FStops,AutoBR,BR,TH,Hor,LSiz,AutoLI,LI,Jit,yRot,CTR,LDObj,SS,VL,PO,Eval,EP,CVT,RB)
  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  //                                                                                                                     //
  //  HDRI LightDome Generator                                                                                           //
  //  Trevor G. Quayle, 2007                                                                                             //
  //  For MegaPOV 1.2.1                                                                                                  //
  //                                                                                                                     //
  //  PASSED VARIABLES:                                                                                                  //
  //  Map    = HDRI filename, at the moment only maps of Lat/Long mapping are supported                                  //
  //  n      = <a,b,c> median cut division parameters                                                                    //
  //             a: areas per division level (typically 2 is used, i.e. divide each area by 2)                           //
  //             b: median cut division level (#light sources = a^b)                                                     //
  //             c: image map division level (>: more accurate, slower parsing)                                          //
  //  FStops = #stops to adjust HDRI brightness by (used when BR=0, ignored otherwise)                                   //
  //  AutoBR = turn auto brightness on/off, scales HDRI brightness so MaxBR=BR (ignored when BR=0)                       //
  //  BR     = (AutoBR off) brightness multiplier for HDRI                                                               //
  //         = (AutoBR on) maximum brightness, HDRI brightness scaled to match MaxBR=BR                                  //
  //           *when BR=0, brightness adjusted using FStops variable                                                     //
  //  TH     = cutoff threshold: samples < TH not used in light source calculations                                      //
  //  Hor    = horizon level (0 to 1) light sources are not sampled below horizon                                        //
  //  LSiz   = controls lightsources (regular mode)                                                                      //
  //             0 : lights off                                                                                          //
  //             1 : point lights                                                                                        //
  //             >1: area lights (LSiz x LSiz lights, area light size determined automatically)                          //
  //  AutoLI = auto light intensity ON/OFF,                                                                              //
  //             TRUE : ON, scales light intensity based on HDRI brightness                                              //
  //             FALSE: OFF, scales light intensity so average light intensity at <0,0,0> = LI                           //
  //  LI     = (AutoLI ON) light intensity multiplier, (AutoLI OFF) average light intensity                              //
  //  Jit    = Jitter light source locations (% HDRI map size)                                                           //
  //  yRot   = rotation of light dome around y-axis                                                                      //
  //  CTR    = location of light dome center                                                                             //
  //  LDObj  = light dome object (object defining light dome surface)                                                    //
  //  SS     = display HDRI mapped skysphere (true/false)                                                                //
  //  VL     = visible lightsources, light sources shown as ambient spheres (rad=VL) or rectangles (area light) (0=OFF)  //
  //  PO     = turns light dome photons on/of (only affected if scene photons on)                                        //
  //  Eval   = select evaluaton mode, allows user to pre-evaluate settings with relevant data                            //
  //             +: display HDRI image normally                                                                          //
  //             -: display HDRI image shaded by threshold level (yellow= >TH, red=rebuild area)                         //
  //             0: evaluation mode off, render scene                                                                    //
  //             1: display HDRI image with median cuts only                                                             //
  //             2: display HDRI image with both median cuts and light source locations                                  //
  //             3: display HDRI image with light source locations only                                                  //
  //             4: display light source locations with relative light colour (HDRI image not displayed)                 //
  //             5: quick evaluation, lightsources not calculated individually                                           //
  //             6: show rebuilt clipped area only                                                                       //
  //         *for evaluation mode to work properly, cameras must not be placed after LightDome                           //
  //  EP     = projection type for evaluation mode (only effects the way the evaluation image is displayed)              //
  //             0=rectangular : image stretched to fit 2x1 rectangle                                                    //
  //             1=proportional: image is mapped proportionally                                                          //
  //  CVT    = <a,b,c> centroidal voronoi tesselation parameters                                                         //
  //             a: #CVT passes to perform                                                                               //
  //             b: image map division level (>: more accurate, slower)                                                  //
  //             c: image map sub-sampling level (sub-samples colour from rectangular grid cxc)                          //
  //  RB     = <a,b> clipped region rebuild parameters (experimental)                                                    //
  //             a: threshold to rebuild above (% max sampled brightness, recommend 0.95-0.99)                           //
  //             b: rebuild function curve power (0=OFF)                                                                 //
  //                                                                                                                     //
  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

  #version unofficial megapov 1.21;  //set for POV version being used

  #local PIMAGE = function {pigment{image_map {hdr Map interpolate 2} warp{repeat y flip y} scale <2,1,1> translate <2*yRot/360,-0.5,0>}}
 
  #local RND=seed(1);
  
  #macro interp(C11,C12,C21,C22,XX,YY) C11+(C21-C11)*XX+(C12-C11)*YY+(C22-C12-C21+C11)*XX*YY; #end //4 point interpolation

  #macro SA(a,b,c) //Summed area table evaluation
    #local xy=array[2][3][2];
    #local XY0=array[2][2];
    #local CC=array[2][2][2][2];    
    #local CI=array[2][2];    
    #local xy[0][2][0]=a.u;
    #local xy[0][2][1]=a.v;
    #local xy[1][2][0]=b.u;
    #local xy[1][2][1]=b.v;
    #local ii=0;#while (ii<=1)
      #local jj=0;#while (jj<=1)
        #local xy[ii][0][jj]=floor(xy[ii][2][jj]);
        #local xy[ii][1][jj]= ceil(xy[ii][2][jj]);
        #local XY0[ii][jj]=#if (xy[ii][1][jj]-xy[ii][0][jj]=0) 0; #else (xy[ii][2][jj]-xy[ii][0][jj])/(xy[ii][1][jj]-xy[ii][0][jj]); #end 
      #local jj=jj+1;#end
    #local ii=ii+1;#end
    #local i0=0;#while (i0<=1)
      #local i1=0;#while (i1<=1)
        #local i2=0;#while (i2<=1)
          #local i3=0;#while (i3<=1)
            #local CC[i0][i1][i2][i3]=SATab[xy[i2][i0][0]][xy[i3][i1][1]][c];
          #local i3=i3+1;#end
        #local i2=i2+1;#end
      #local i1=i1+1;#end
    #local i0=i0+1;#end
    #local i0=0;#while (i0<=1)
      #local i1=0;#while (i1<=1)
        #local CI[i0][i1]=interp(CC[0][0][i0][i1],CC[0][1][i0][i1],CC[1][0][i0][i1],CC[1][1][i0][i1],XY0[i0][0],XY0[i1][1]);
      #local i1=i1+1;#end
    #local i0=i0+1;#end
    #local Result=(CI[1][1]-CI[0][1]-CI[1][0]+CI[0][0]);
    #undef xy
    #undef XY0
    #undef CC
    #undef CI
    Result
  #end

  #macro PickUV(Var,UV) #if (UV=0) #local aa=Var.u; #else #local aa=Var.v; #end aa #end
  #macro UVtoXYZ(UV) vrotate(vrotate(<1,0,0>,(180*UV.v*z)),180*UV.u*y) #end //Convert UV coordinates to XYZ
  #macro AL(UV1,UV2) acos(max(min(vdot(UVtoXYZ(<UV1.u,UV1.v>),UVtoXYZ(<UV2.u,UV2.v>)),1),-1)) #end
  #macro XYZtoUV(XYZ) <acos(max(min(XYZ.x/cos(asin(XYZ.y)),1),-1))/pi*select(XYZ.z,1,0,-1),asin(XYZ.y)/pi> #end //Convert XYZ coordinates to UV

  #macro Light(LN,Rad)                    
    #local PtA=(LtA[LN]/e-<1,0.5>);
    #local PtB=(LtB[LN]/e-<1,0.5>);
    #local L1=min(abs(LPos[LN].u-PtA.u),abs(LPos[LN].u-PtB.u))*Rad*pi*cos(radians(LPos[LN].v*180));
    #local H1=min(abs(LPos[LN].v-PtA.v),abs(LPos[LN].v-PtB.v))*Rad*pi;
    #if (LSiz>0)
      light_source{
        #local FD = 200/Rad; #local FP =1;
        0 color (LCol[LN])*LIi*((1+pow(1/FD,FP))/2)
        #if (LSiz>1)
          area_light <0,0,2*L1> <0,2*H1,0> LSiz, LSiz
          adaptive 1
          jitter
        #end
        fade_power FP fade_distance Rad*FD
        #if (PO) photons {refraction on reflection on #if (LSiz>1) area_light #end} #end
        media_interaction off
        translate Rad*x rotate z*LPos[LN].v*180 rotate y*LPos[LN].u*180 translate CTR
      }                                                        
    #end
    #if (VL>0)
      #if (LSiz>1)
        box{<0,-H1,-L1><0,H1,L1>
      #else
        sphere{0 VL
      #end
        no_shadow pigment{color LCol[LN]/LNum[LN]} finish{ambient 1 diffuse 0}
        translate Rad*x rotate z*LPos[LN].v*180 rotate y*LPos[LN].u*180 translate CTR
      }
    #end
  #end
  #macro AText(Ali,Fnt,Txt,Siz,Pt)
    #local T1=text{ttf Fnt, Txt, Siz ,0 scale Siz}
    object{T1 translate Pt+<(min_extent(T1).x-max_extent(T1).x)*Ali/2,0,0> pigment{rgb 1} finish{ambient 1}}  
  #end
  #ifdef(FX) #undef FX #end
   #if (EP=0) #declare FX=function(y){1} #else #declare FX=function(y){cos(radians((y*2)*90))} #end
  #local SQRA=function(X0,Y0,X1,Y1,RP){abs(Y1-Y0)/pow(abs(X1-X0),RP)}
  #local e=n.z;
  #local MaxBR=0; #local MaxBR2=0;
  #local SATab=array[e*2+1][e+1][5];
  #local nn=0;#while (nn<5)
    #local yy=0; #while (yy<=e  ) #local SATab[0][yy][nn]=rgb 0; #local yy=yy+1; #end
    #local xx=1; #while (xx<=e*2) #local SATab[xx][0][nn]=rgb 0; #local xx=xx+1; #end
  #local nn=nn+1;#end
  #local G=1;//gamma correction - experimental
  #local f=0;#while (f<2)
    #if (f=1)
      #if (BR=0)
        #local BR=pow(2,FStops); #local BRi=BR;
      #else
        #local BRi=BR/select(AutoBR-1,1,MaxBR);
      #end
      #local BRiG=pow(BRi,G);
      #local RTH=RB.u*MaxBR;#local RP=RB.v;
      #local pxx=-1;#local pyy=-1;
      #local e2=5000;
      #local XX1=array[4]{0,0,0,0}; #local YY1=array[4]{0,0,0,0};
      #local XX2=array[4]{0,0,0,0}; #local YY2=array[4]{0,0,0,0};
      #local yy=1; #while (yy<=e)
        #local yp=yy/e-0.5;
        #local xx=1; #while (xx<=e*2)
          #local xp=xx/e-1;
          #local COL=SATab[xx][yy][0];
          #local yp2=(2*yy-1-e)/(2*e);
          #local xp2=(2*xx-1-2*e)/(2*e);
// Rebuild Clipped Areas - START                                                                                                                     //
          #if (COL.gray>RTH & RP>0)                                                                                                                  //
            #if (!(xx=(pxx+1)&yy=pyy))                                                                                                               //
              #local MaxC=RTH; #local FND=1; #local XXX=xp;                                                                                          //
              #while (FND>=0)                                                                                                                        //
                #local XXX=XXX-1/e2;#local YYY=PIMAGE(XXX-1/(2*e),yp2,0).gray;                                                                       //
                #if (YYY<MaxC|XXX<(xp-1))                                                                                                            //
                  #local XX1[FND]=XXX;#local YY1[FND]=YYY;                                                                                           //
                  #local MaxC=YY1[FND];#local FND=FND-1;                                                                                             //
                #end                                                                                                                                 //
              #end                                                                                                                                   //
              #local MaxC=RTH; #local FND=2; #local XXX=xp;                                                                                          //
              #while (FND<=3)                                                                                                                        //
                #local XXX=XXX+1/e2;#local YYY=PIMAGE(XXX-1/(2*e),yp2,0).gray;                                                                       //
                #if (YYY<MaxC|XXX>(xp+1))                                                                                                            //
                  #local XX1[FND]=XXX;#local YY1[FND]=YYY;                                                                                           //
                  #local MaxC=YY1[FND];#local FND=FND+1;                                                                                             //
                #end                                                                                                                                 //
              #end                                                                                                                                   //
              #local A1S=SQRA(XX1[0],YY1[0],XX1[1],YY1[1],RP);                                                                                       //
              #local A2S=SQRA(XX1[3],YY1[3],XX1[2],YY1[2],RP);                                                                                       //
            #end                                                                                                                                     //
            #local pxx=xx; #local pyy=yy;                                                                                                            //
            #local COL1S=min(YY1[0]+A1S*pow(abs(xp-XX1[0]),RP),YY1[3]+A2S*pow(abs(xp-XX1[3]),RP));                                                   //
                                                                                                                                                     //
            #local MaxC=RTH; #local FND=1; #local XXX=yp;                                                                                            //
            #while (FND>=0)                                                                                                                          //
              #local XXX=XXX-1/e2; #local YYY=PIMAGE(xp2,select(-0.5-XXX,XXX,-1-XXX)-1/(2*e),0).gray;                                                //
              #if (YYY<MaxC|XXX<(yp-0.5))                                                                                                            //
                #local XX2[FND]=XXX;#local YY2[FND]=YYY;                                                                                             //
                #local MaxC=YY2[FND];#local FND=FND-1;                                                                                               //
              #end                                                                                                                                   //
            #end                                                                                                                                     //
            #local MaxC=RTH; #local FND=2; #local XXX=yp;                                                                                            //
            #while (FND<=3)                                                                                                                          //
              #local XXX=XXX+1/e2; #local YYY=PIMAGE(xp2,select(XXX-0.5,XXX,1-XXX)-1/(2*e),0).gray;                                                  //
              #if (YYY<MaxC|XXX>(yp+0.5))                                                                                                            //
                #local XX2[FND]=XXX;#local YY2[FND]=YYY;                                                                                             //
                #local MaxC=YY2[FND];#local FND=FND+1;                                                                                               //
              #end                                                                                                                                   //
            #end                                                                                                                                     //
            #local A3S=SQRA(XX2[0],YY2[0],XX2[1],YY2[1],RP);                                                                                         //
            #local A4S=SQRA(XX2[3],YY2[3],XX2[2],YY2[2],RP);                                                                                         //
            #local COL2S=min(YY2[0]+A3S*pow(abs(yp-XX2[0]),RP),YY2[3]+A4S*pow(abs(yp-XX2[3]),RP));                                                   //
            #local COL=max(COL1S,COL2S,COL.gray)*COL/COL.gray;                                                                                       //
            #local MaxBR2 = max(MaxBR2,COL.gray);                                                                                                    //
            #if ((abs(Eval)!=4) & (Eval!=-5)) box{<0,0,0.5> <-1/e,-1/e,0.2> pigment{color COL*BRiG} finish{ambient 1} translate <xp,yp,0>} #end      //
            #if (SS & Eval=0)  /*Overlay smooth textured smooth triangles to make rebuilt areas visible*/                                            //
              #local p00=UVtoXYZ(<xp-0.5/e,yp-0.5/e>);                                                                                               //
              #local p10=UVtoXYZ(<xp+0.5/e,yp-0.5/e>);                                                                                               //
              #local p01=UVtoXYZ(<xp-0.5/e,yp+0.5/e>);                                                                                               //
              #local p11=UVtoXYZ(<xp+0.5/e,yp+0.5/e>);                                                                                               //
              mesh{                                                                                                                                  //
                smooth_triangle{p00,p00,p01,p01,p10,p10}                                                                                             //
                smooth_triangle{p11,p11,p10,p10,p01,p01}                                                                                             //
                no_shadow pigment{color COL*BRi} finish{ambient 1}                                                                                   //
                scale R*0.98                                                                                                                         //
              }                                                                                                                                      //
            #end                                                                                                                                     //
          #end                                                                                                                                       //
// Rebuild Clipped Areas - END                                                                                                                       //
          #local SATab[xx][yy][4]=SATab[xx-1][yy][4]+SATab[xx][yy-1][4]-SATab[xx-1][yy-1][4]+COL*cos(radians(yp2*180));
          #if (COL.gray<TH*BRiG) #local COL=rgb 0; #end
          #local SATab[xx][yy][0]=SATab[xx-1][yy][0]+SATab[xx][yy-1][0]-SATab[xx-1][yy-1][0]+COL*cos(radians(yp2*180));
          #local SATab[xx][yy][1]=SATab[xx-1][yy][1]+SATab[xx][yy-1][1]-SATab[xx-1][yy-1][1]+xp2*COL*cos(radians(yp2*180));
          #local SATab[xx][yy][2]=SATab[xx-1][yy][2]+SATab[xx][yy-1][2]-SATab[xx-1][yy-1][2]+yp2*COL*cos(radians(yp2*180));
          #local SATab[xx][yy][3]=SATab[xx-1][yy][3]+SATab[xx][yy-1][3]-SATab[xx-1][yy-1][3]+<cos(radians(yp2*180)),0,0>;
        #local xx=xx+1; #end
      #local yy=yy+1; #end                        
    #else
      #local yy=1; #while (yy<=e)
        #local xx=1; #while (xx<=e*2)
          #local COL=PIMAGE((2*xx-1-2*e)/(2*e),(2*yy-1-e)/(2*e),0);
          #local COL=rgb<pow(COL.red,G),pow(COL.green,G),pow(COL.blue,G)>;
          #local MaxBR = max(MaxBR,COL.gray);
          #local SATab[xx][yy][0]=COL;
        #local xx=xx+1; #end
      #local yy=yy+1; #end                        
    #end  
  #local f=f+1;#end
  #local MCL=n.x;
  union{
    #local nL=pow(MCL,n.y);
    #local NumL=nL; #local NumLC=0;
    #local TCol=SA(<0,Hor*e>,<2*e,e>,0);#local TCol=TCol*BRiG;
    #local TColO=SA(<0,0>,<2*e,e>,4);#local TColO=TColO*BRiG;
    #if(abs(Eval)!=5)
      #local LPos=array[nL]; #local LCol=array[nL]; #local LNum=array[nL];
      #local LtA=array[nL];#local LtB=array[nL];
      #local LtA[0]=<0,Hor*e>;#local LtB[0]=<2*e,e>;
      #local i=0;#while (i<n.y)
        #local j=0;#while (j<=pow(MCL,i)-1)
          #local k1=j*pow(MCL,n.y-i);
          #local A=LtA[k1]/e-<1.0,0.5>;#local B=LtB[k1]/e-<1.0,0.5>;
          #local W=(sin(pi*B.v)-sin(pi*A.v))/(pi*B.v-pi*A.v);
          #local kk=((B.v-A.v)-(B.u-A.u)*W);
          #local SumA1=SA(LtA[k1],LtB[k1],0);
          #local Mdn=SumA1.gray/MCL;
          #local k=2; #while(k<=MCL)
            #local k2=k1+pow(MCL,n.y-i-1);
            #local LtB[k2]=LtB[k1];
            #local Fnd=false;#local a=ceil(select(kk,LtA[k1].u,LtA[k1].v));
            #while (!Fnd)
              #local SumA2=SA(LtA[k1],<select(kk,a,LtB[k1].u),select(kk,LtB[k1].v,a)>,0);
              #if (SumA2.gray>Mdn)
                #local SumA0=SA(LtA[k1],<select(kk,a-1,LtB[k1].u),select(kk,LtB[k1].v,a-1)>,0);
                #local AA=a-1+(Mdn-SumA0.gray)/(SumA2.gray-SumA0.gray);
                #local LtB[k1]=<select(kk,AA,LtB[k1].u),select(kk,LtB[k1].v,AA)>;
                #local LtA[k2]=<select(kk,AA,LtA[k1].u),select(kk,LtA[k1].v,AA)>;
                #if ((abs(Eval)=1|abs(Eval)=2) & EP=0 & CVT.x=0) 
                  cylinder{<LtB[k1].u/e,LtB[k1].v/e,0> <LtA[k2].u/e,LtA[k2].v/e,0>  0.002 translate<-1,-0.5,0> texture{pigment{rgb <0,1,0>} finish{ambient 1}}}
                #end
                #local Fnd=true;
              #end
            #local a=a+1;#end
            #local k1=k1+pow(MCL,n.y-i-1);
          #local k=k+1;#end
        #local j=j+1;#end
      #local i=i+1;#end
      #local i=0;#while (i<nL)
        #local NLt= SA(LtA[i],LtB[i],3);
        #local LNum[i]=NLt.red;
        #if (LNum[i]=0) #local LNum[i]=1; #end
        #local LCol[i]= SA(LtA[i],LtB[i],0);
        #local SAX= SA(LtA[i],LtB[i],1);
        #local SAY= SA(LtA[i],LtB[i],2);
        #local XY0=(<SAX.gray,SAY.gray>/LCol[i].gray+<1,0.5>)*e;
        #local Y0=(XY0.v-floor(LtA[i].v))/(ceil(LtB[i].v)-floor(LtA[i].v));
        #local X0=(XY0.u-floor(LtA[i].u))/(ceil(LtB[i].u)-floor(LtA[i].u));
        #local LPos[i]=((LtB[i]-LtA[i])*<X0,Y0>+LtA[i])/e-<1,0.5>;
        #local xJit=(2*rand(RND)-1)*Jit*e/100; #local yJit=(2*rand(RND)-1)*Jit*e/100;
        #local LPos2=(LPos[i]+<1,0.5>)*e+<xJit,yJit>;
        #local LPos[i]=LPos2/e-<1,0.5>;
        #local LCol[i]=LCol[i]*BRiG;
      #local i=i+1;#end
// Centroidal Voronoi Tesselation - START                                                                                                            //
      #local Lt=array[nL][7];                                                                                                                        //
      #local nPass=CVT.x;                                                                                                                            //
      #local nn=CVT.z;                                                                                                                               //
      #local iii=0; #while (iii<nPass)                                                                                                               //
        #debug "-------------------------------------\n"                                                                                             //
        #debug concat("Pass #",str(iii+1,0,0)," of ",str(nPass,0,0),"\n")                                                                            //
        #local i=0;#while(i<nL) #local j=0;#while(j<7) #local Lt[i][j]=0; #local j=j+1;#end #local i=i+1;#end                                        //
        #local TCol=rgb 0;#local TColO=rgb 0;                                                                                                        //
        #local nY=CVT.y; #local yS=1/nY;                                                                                                             //
        #local dd=0;#while (dd<=nY)                                                                                                                  //
          #local d=dd*yS-0.5;                                                                                                                        //
          #local nX=max(int(2*cos(radians((dd*yS-0.5)*180))/yS),1);                                                                                  //
          #local xS=2/nX;                                                                                                                            //
          #local LN0=-2;                                                                                                                             //
          #local Step=10;                                                                                                                            //
          #local cc=0;#while (cc<nX)                                                                                                                 //
            #local LN1=-1;                                                                                                                           //
            #local nnX=min(nX-cc,Step);                                                                                                              //
            #local ccc=-1;#while (ccc<(nnX-1))                                                                                                       //
              #local c=(cc+select(ccc,(nnX-1),ccc))*xS-1.0;                                                                                          //
              #local MinD=4;                                                                                                                         //
              #local pUV=<c,d>;                                                                                                                      //
              #local pXYZ=UVtoXYZ(pUV);                                                                                                              //
              #local COL = rgb 0;                                                                                                                    //
              #local a=-1;#while(a<=1)    /*sub-sampling*/                                                                                           //
                #local b=-1;#while(b<=1)                                                                                                             //
                  #local xx=c+a*min(1,nn)*xS/2*(nn/(nn+1));                                                                                          //
                  #local yy=d+b*min(1,nn)*yS/2*(nn/(nn+1));                                                                                          //
                  #if(xx<-1) #local xx=2+xx; #end                                                                                                    //
                  #local COL=COL+PIMAGE(xx,yy,0)*BRiG;                                                                                               //
                #local b=b+2/max(nn,0.1);#end                                                                                                        //
              #local a=a+2/max(nn,0.1);#end                                                                                                          //
              #local COL=COL/pow(nn+1,2);                                                                                                            //
              #local TColO=TColO+COL;                                                                                                                //
              #if (d>=(Hor-0.5) & COL.gray>=TH)                                                                                                      //
                #local TCol=TCol+COL;                                                                                                                //
                #if (LN0=LN1)                                                                                                                        //
                  #local LN=LN1;                                                                                                                     //
                #else                                                                                                                                //
                  #local i=0;#while(i<nL)                                                                                                            //
                    #local pD= AL(pUV,LPos[i]);                                                                                                      //
                    #if (pD<MinD)                                                                                                                    //
                      #local MinD=pD;                                                                                                                //
                      #local LN=i;                                                                                                                   //
                    #end                                                                                                                             //
                  #local i=i+1;#end                                                                                                                  //
                #end                                                                                                                                 //
                #if(ccc=-1)                                                                                                                          //
                  #local LN1=LN;                                                                                                                     //
                #else                                                                                                                                //
                  #local LN0=LN;                                                                                                                     //
                #end                                                                                                                                 //
                #local Lt[LN][0]=Lt[LN][0]+COL.red;                                                                                                  //
                #local Lt[LN][1]=Lt[LN][1]+COL.green;                                                                                                //
                #local Lt[LN][2]=Lt[LN][2]+COL.blue;                                                                                                 //
                #local Lt[LN][3]=Lt[LN][3]+COL.gray*pXYZ.x;                                                                                          //
                #local Lt[LN][4]=Lt[LN][4]+COL.gray*pXYZ.y;                                                                                          //
                #local Lt[LN][5]=Lt[LN][5]+COL.gray*pXYZ.z;                                                                                          //
                #local Lt[LN][6]=Lt[LN][6]+1;                                                                                                        //
              #end                                                                                                                                   //
            #local ccc=ccc+1;#end                                                                                                                    //
          #local cc=cc+Step;#end                                                                                                                     //
        #local dd=dd+1;#end                                                                                                                          //
        #local nY=nL;                                                                                                                                //
        #local NumL=0;                                                                                                                               //
        #local MaxDC=0;#local TotDC=0;                                                                                                               //
        #local i=0;#while(i<nY)                                                                                                                      //
          #local COL = rgb <Lt[i][0],Lt[i][1],Lt[i][2]>;                                                                                             //
          #if(Lt[i][6]=0)                                                                                                                            //
            #local cNew=rgb 0;                                                                                                                       //
          #else                                                                                                                                      //
            #local uvNew=XYZtoUV(vnormalize(<Lt[i][3],Lt[i][4],Lt[i][5]>/COL.gray));                                                                 //
            #local NumL=NumL+1;                                                                                                                      //
            #local cNew=COL;                                                                                                                         //
            #local DC= AL(uvNew,LPos[i]);                                                                                                            //
            #local MaxDC=max(DC,MaxDC);                                                                                                              //
            #local TotDC=TotDC+DC;                                                                                                                   //
            #if (iii<nPass-1) #local LPos[i]=uvNew; #end                                                                                             //
          #end                                                                                                                                       //
          #local LNum[i]=Lt[i][6];                                                                                                                   //
          #if (LNum[i]=0) #local LNum[i]=1; #end                                                                                                     //
          #local LCol[i]=cNew;                                                                                                                       //
        #local i=i+1;#end                                                                                                                            //
        #debug concat(#if(nY>0) "MaxDC: ",str(MaxDC,0,3),", AveDC: ",str(TotDC/nY,0,3) #else "(off)" #end ,"\n")                                     //
      #local iii=iii+1;#end                                                                                                                          //
      #debug "-------------------------------------\n"                                                                                               //
// Centroidal Voronoi Tesselation - END                                                                                                              //
    #end
    #local SALD=pow(select(CVT.x-1,e,CVT.y),2)*2/pi/3;
    #local LIi=select(AutoLI-1,1/TColO.gray,1/SALD)*LI;
    #undef SATab
    #undef Lt
    #local AALI=0;
    #local i=0;#while (i<nL)
      #local Norm=<0,0,0>;
      #if (abs(Eval)<5)
        #local LVec=UVtoXYZ(LPos[i]);
        #local TLoc=trace(LDObj,0,LVec,Norm);
        #local R=vlength(TLoc);
      #end
      #if (vlength(Norm)!=0) #local NumLC=NumLC+1; #end
      #if (abs(Eval)>0)
        #if (abs(Eval)>1 & abs(Eval)<5) sphere{<LPos[i].u*FX(LPos[i].v),LPos[i].v,0> 0.006 pigment{#if (abs(Eval)=4) color LCol[i]/LNum[i] #else #if (vlength(Norm)=0) rgb <0,0,1> #else rgb <1,0,0> #end #end} finish{ambient 1}} #end
      #else
        #if (vlength(Norm)=!0) Light(i,R) #end
      #end
      #if (abs(Eval)!=5)
        #local AALI=AALI+LCol[i]*LIi;
      #else
        #local AALI=TColO*LIi;
      #end
    #local i=i+1;#end
    #if (SS & Eval=0)
      object{LDObj
        #local PIMAGE2 = function {pigment{image_map {hdr Map interpolate 2 map_type 1} scale <1,1,-1>}}
        #local FCol=function(x,y,z,comp) {pow(BRi*select(comp,PIMAGE2(x,y,z).red,PIMAGE2(x,y,z).green,PIMAGE2(x,y,z).blue),G)/(MaxBR*BRiG*100)}
        texture{
          pigment{average
            pigment_map{
              [function{FCol(x,y,z,-1)} color_map{[0 rgb 0][1 rgb <1,0,0>]}]
              [function{FCol(x,y,z, 0)} color_map{[0 rgb 0][1 rgb <0,1,0>]}]
              [function{FCol(x,y,z, 1)} color_map{[0 rgb 0][1 rgb <0,0,1>]}]
            }
          }
          finish {ambient 3*MaxBR*BRiG*100 diffuse 0}
        }
        rotate y*(yRot) translate CTR
        no_shadow
      }
    #end
    no_radiosity
  }
// Statistic Reporting - START                                                                                                                       
  #debug "\n"
  #debug "-------------------------------------\n"
  #debug "   L I G H T D O M E    S T A T I S T I C S   \n"
  #debug "\n"
  #debug concat("HDRI Map: \"", Map,"\"\n")
  #debug concat("y rotation = ",str(yRot,0,1),"deg\n")
  #debug concat("\n")
  #debug concat("Median Cut Divisor  :      ",str(n.x,0,0),"\n")
  #debug concat("Median Cut Division Level: ",str(n.y,0,0),"\n")
  #debug concat("Image Map Division Level:  ",str(n.z,0,0),"\n")
  #debug concat("Total Light Sources:       ",str(NumL,0,0)," (",str(NumLC,0,0)," visible)\n")
  #debug "\n"
  #debug concat("Centroidal Voronoi Tesselation: ",#if (CVT.x>0) concat(str(CVT.x,0,0),"pass" #if (CVT.x>1) ,"es" #end) #else "OFF" #end,"\n")
  #debug concat("CVT Image Map Division Level:   ",#if (CVT.x>0) str(CVT.y,0,0) #else "n/a" #end,"\n")
  #debug concat("CVT Subsampling Level:          ",#if (CVT.x>0) #if (CVT.z>0) str(CVT.z,0,0) #else "OFF" #end #else "n/a" #end,"\n")
  #debug "\n"
  #debug concat("Brightness Factor:  ",str(BRi,0,3)," (",#if (BRi>1) "+", #end str(log(BRi)/log(2),0,1)," stops)\n")
  #debug concat("Maximum Brightness: ",str(MaxBR*BRiG,0,3) #if (BRi != 1) ,concat("(" ,str(MaxBR,0,3),")") #end,"\n")
  #debug concat("Cutoff Threshold:   ",#if (TH>0) str(TH*BRi,0,3) #if (BRi!=1) ,"(" ,str(TH,0,3),")" #end #else "OFF" #end,"\n")
  #debug concat("Auto Brightness:    ",#if (AutoBR) "ON" #else "OFF" #end, "\n")
  #debug "\n"
  #debug concat("Light Intensity: ",str(AALI.gray,0,2)," <",vstr(3,AALI,", ",0,3),">\n")
  #debug concat("Auto Intensity:  ",#if (AutoLI) "ON (LI Factor: ",str(LI,0,2),")" #else "OFF" #end,"\n")
  #debug "\n"
  #debug concat("Rebuild Clipped:  ",#if (RB.v>0) "ON  (Factor: ",str(RB.v,0,2),")" #else "OFF" #end, "\n")
  #debug concat("Rebuild Threshold:",#if (RB.v>0) str(RB.u,0,2),"  (",str(RTH*BRiG,0,3),"), (max: ",str(MaxBR2*BRiG,0,3),")" #else "n/a" #end,"\n")
  #debug "-------------------------------------\n"
  #debug "\n"
  #if (abs(Eval)>0)                            //evaluation mode camera
    camera{ orthographic
      #if (image_height/image_width < 3/4)
        up y*2.05*3/4
        right x*2.05*image_width/image_height*3/4
      #else
        up y*2.05*image_height/image_width
        right x*2.05
      #end
      location <0,-0.15,-2>
      look_at  <0,-0.15,0>
    }
    #local FNam ="arial.ttf";
    #if (abs(Eval)!=4 & abs(Eval)!=6)
      #local PP=function(x){(floor((x+0.5)*e)+0.5)/e-0.5}
      #local FCL=function(x,y,z) {pow(BRi*select(z,PIMAGE(PP(x),PP(y),0).red,PIMAGE(PP(x),PP(y),0).green,PIMAGE(PP(x),PP(y),0).blue),G)}
      #local FGy=function(x,y) {pow(BRi*PIMAGE(PP(x),PP(y),0).gray ,G)}
      #local FCOL=function(x,y,z) {FCL(x/FX(y),y,z)*int(1/(1+int(abs(x/FX(y)))))*int(1/(1+int(abs(y*2))))}
      #local FGry=function(x,y) {FGy(x/FX(y),y)*int(1/(1+int(abs(x/FX(y)))))*int(1/(1+int(abs(y*2))))}
      plane{z,1 pigment {rgb 1}}
      box{<-1,-0.5,0.5>,<1,0.5,1>
        texture{
          pigment{average
            pigment_map{
              #if (Eval>0)
                [function{min(select(y+0.5-Hor,FGry(x,y),FCOL(x,y,-1)),1)} color_map{[0 rgb 0][1 rgb <1,0,0>]}]
                [function{min(select(y+0.5-Hor,FGry(x,y),FCOL(x,y, 0)),1)} color_map{[0 rgb 0][1 rgb <0,1,0>]}]
                [function{min(select(y+0.5-Hor,FGry(x,y),FCOL(x,y, 1)),1)} color_map{[0 rgb 0][1 rgb <0,0,1>]}]
              #else
                [function{min(select(y+0.5-Hor,FGry(x,y),select(FGry(x,y)-TH*BRi,min(FGry(x,y),1),0)),1)} color_map{[0 rgb 0][1 rgb <1,1,1>]}]
                #if (RB.v=0)
                  [function{min(select(y+0.5-Hor,0,select(FGry(x,y)-TH*BRi,0,min(FGry(x,y),1))),1)} color_map{[0 rgb 0][1 rgb <1,1,0>]}]
                  [1 rgb 0]
                #else
                  [function{min(select(y+0.5-Hor,0,select(FGry(x,y)-TH*BRi,0,select(RTH*BRi-FGry(x,y),0,min(FGry(x,y),1)))),1)} color_map{[0 rgb 0][1 rgb <1,1,0>]}]
                  [function{min(select(y+0.5-Hor,0,select(FGry(x,y)-RTH*BRi,0,min(FGry(x,y),1))),1)} color_map{[0 rgb 0][1 rgb <1,0,0>]}]
                #end
              #end
            }
            
          }
          finish {ambient 3 diffuse 0}
        }
      }
    #end
    AText(0,FNam,concat("HDRI Map: ", Map),  1/20,<-1.00,0.56,0>)
    AText(0,FNam,concat("y rotation = ",str(yRot,0,1),"deg"),1/25,<-1.00,0.51,0>)
    AText(2,FNam,"Median Cut Light System",1/20,<1.00,0.56,0>)
    AText(2,FNam,concat("evaluation mode ",str(Eval,0,0)),1/25,<1.00,0.51,0>)
    union{
      AText(0,FNam,"Median Cut Divisor:",1/25,<0.00,-0.00,0>)
      AText(0,FNam,str(n.x,0,0),1/25,<0.49,-0.00,0>)
      AText(0,FNam,"Median Cut Division Level:",1/25,<0.00,-0.04,0>)
      AText(0,FNam,str(n.y,0,0),1/25,<0.49,-0.04,0>)
      AText(0,FNam,"Image Map Division Level:",1/25,<0.00,-0.08,0>)
      AText(0,FNam,str(n.z,0,0),1/25,<0.49,-0.08,0>)
      AText(0,FNam,"Total Light Sources:",1/25,<0.00,-0.12,0>)
      AText(0,FNam,str(NumL,0,0),1/25,<0.49,-0.12,0>)
      AText(0,FNam,concat("(",str(NumLC,0,0)," visible)"),1/25,<0.60,-0.12,0>)
      translate <-0.95,-0.60,0>
    }
    union{
      AText(0,FNam,"Brightness Factor:",1/25,<0.00,-0.00,0>)
      AText(0,FNam,str(BRi,0,3),1/25,<0.40,-0.00,0>)
      AText(0,FNam,concat("(",#if (BRi>1) "+", #end str(log(BRi)/log(2),0,1)," stops)"),1/25,<0.60,-0.00,0>)
      AText(0,FNam,"Maximum Brightness:",1/25,<0.00,-0.04,0>)
      AText(0,FNam,str(MaxBR*BRiG,0,3),1/25,<0.40,-0.04,0>)
      #if (BRi != 1) AText(0,FNam,concat("(" ,str(MaxBR,0,3),")"),1/25,<0.60,-0.04,0>) #end
      AText(0,FNam,"Cutoff Threshold:",1/25,<0.00,-0.08,0>)
      #if (TH>0)
        AText(0,FNam,str(TH*BRi,0,3),1/25,<0.40,-0.08,0>)
        #if (BRi != 1) AText(0,FNam,concat("(" ,str(TH,0,3),")"),1/25,<0.60,-0.08,0>) #end
      #else
        AText(0,FNam,"OFF",1/25,<0.40,-0.08,0>)
      #end
      AText(0,FNam,"Auto Brightness:",1/25,<0.00,-0.12,0>)
      AText(0,FNam,#if (AutoBR) "ON" #else "OFF" #end,1/25,<0.40,-0.12,0>)
      AText(0,FNam,"Jitter:",1/25,<0.60,-0.12,0>)
      AText(0,FNam,#if (Jit>0) str(Jit,0,2) #else "OFF" #end,1/25,<0.71,-0.12,0>)
      translate <-0.95,-0.78,0>
    }
    union{
      AText(0,FNam,"Light Intensity:",1/25,<0.00,-0.00,0>)
      AText(0,FNam,str(AALI.gray,0,2),1/25,<0.27,-0.00,0>)
      AText(0,FNam,concat("<",vstr(3,AALI,", ",0,3),">"),1/25,<0.45,-0.00,0>)
      AText(0,FNam,"Auto Intensity:",1/25,<0.00,-0.04,0>)
      AText(0,FNam,#if (AutoLI) concat("ON  (LI Factor: ",str(LI,0,2),")") #else "OFF" #end,1/25,<0.27,-0.04,0>)
      translate <0.05,-0.62,0>
    }
    union{
      AText(0,FNam,"Centroidal Voronoi Tesselation:",1/25,<0.00,-0.00,0>)
      AText(0,FNam,#if (CVT.x>0) concat(str(CVT.x,0,0)," pass" #if (CVT.x>1) ,"es" #end) #else "OFF" #end,1/25,<0.57,-0.00,0>)
      AText(0,FNam,"CVT Image Map Division Level:",1/25,<0.00,-0.04,0>)
      AText(0,FNam,#if (CVT.x>0) str(CVT.y,0,0) #else "n/a" #end,1/25,<0.57,-0.04,0>)
      AText(0,FNam,"CVT Subsampling Level:",1/25,<0.00,-0.08,0>)
      AText(0,FNam,#if (CVT.x>0) #if (CVT.z>0) str(CVT.z,0,0) #else "OFF" #end #else "n/a" #end,1/25,<0.57,-0.08,0>)
      translate <0.05,-0.72,0>
    }
    union{
      AText(0,FNam,"Rebuild Clipped:",1/25,<0.00,-0.00,0>)
      AText(0,FNam,#if (RB.v>0) concat("ON  (Factor: ",str(RB.v,0,2),")") #else "OFF" #end,1/25,<0.35,-0.00,0>)
      AText(0,FNam,"Rebuild Threshold:",1/25,<0.00,-0.04,0>)
      AText(0,FNam,#if (RB.v>0) concat(str(RB.u,0,2),"  (",str(RTH*BRiG,0,3),"), (max: ",str(MaxBR2*BRiG,0,3),")") #else "n/a" #end,1/25,<0.35,-0.04,0>)
      translate <0.05,-0.86,0>
    }
    cylinder{<0,-0.5,0.1><0,0.51,0.1> 0.002 pigment{rgb 1} finish{ambient 1}}
    AText(1,FNam,"+x:(1,0)",1/25,<0,0.52,0>)
    cylinder{<-1,Hor-0.5,0.1><1,Hor-0.5,0.1> 0.002 pigment{rgb 1} finish{ambient 1}}
    AText(2,FNam,concat("horizon: ", #if (Hor>0) str(Hor,0,2) #else "OFF" #end),1/25,<0.98,Hor-0.54,0>)
    box{<-0.24,-0.01,0.1><0.01,0.035,0.05> pigment{rgb 0} finish{ambient 1} translate <0.98,Hor-0.54,0> }
  #end
// Statistic Reporting - END                                                                                                                         
#end