
//+W800 +H800 +A +AM2 +R6 +J

#version 3.6;
global_settings {assumed_gamma 1}
#include "Colors.inc"
#include "Macros.inc"
#include "Finish.inc"

#declare Photons = on;
#declare Radiosity = off;

//#declare Save_Photon_Map = 1;
//#declare Load_Photon_Map = 1;

global_settings {
  assumed_gamma 2
  max_trace_level 5
  #if (Photons)
    photons {
      spacing 0.01 
    }
  #end
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.01
      count 200
    }
  #end  
}

camera {
  location  -3.0*z
  look_at   -0.15*y
  right     x*image_width/image_height
  angle     36
}

light_source {
  y
  color rgb 1.2
  fade_distance 1
  fade_power 3
  area_light 2*x 2*z, 10, 10 adaptive 2 //jitter
  photons {
    refraction on
    reflection on
    //area_light
  }
  //rotate -15*x
}

disc {
  -0.25*y, y, 3
  texture {
    pigment {color rgb Orange} 
    finish {ambient 0 reflection 0.5}
  } 
  rotate -45*x
}

/*
plane {
  y, -0.25
  texture {
    pigment {color rgb Orange} 
    finish {ambient 0}
  } 
  rotate -45*x
}
*/

sphere {0, 12
  pigment {
    image_map {
      jpeg "..\Image Maps\morning_preview 2.jpg"
      map_type 1
      interpolate 2
      once
    }
  }
  finish {ambient 1}
}

#declare OrangeGlass = material {
  texture {
    pigment {color rgbt 1}
    finish {
      ambient 0
      diffuse 0
      reflection {0.1, 1.0 fresnel on}
      //reflection 0.5
      //specular 0.5
      //roughness 0
      //conserve_energy
    }
  }
  interior {
    ior 0
    fade_power 1001
    fade_distance 0.2
    fade_color Seagull
  }
}

sphere {0, 0.5
  material {OrangeGlass}
  photons {
    target 1.0
    refraction on
    reflection on
  }
}









