//*PMRawBegin
#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "glass.inc"
//*PMRawEnd

#declare strahl1 = prism {
   //*PMName strahl
   cubic_spline
   linear_sweep
   0, 0.1,
   14,
   <0, 2>, <0, 2>, <0.33, 1>, <0.3, 0>, <0.66, -1.5>, <0.6, -2.75>, <1, -4>, <-1, -4>, <-0.6, -2.75>, <-0.66, -1.5>, <-0.3, 0>, <-0.33, 1>, <0, 2>, <0, 2>
   sturm
   scale 0.5
   rotate y*180
   translate <0, 0, 0>
   hollow
}

global_settings {
   adc_bailout 0.0039216
   assumed_gamma 1.5
   max_trace_level 256
   noise_generator 3
}

sky_sphere {
   pigment {
      gradient <0, 1, 0>
      
      color_map {
         [ 0 color rgb <0, 0, 1>
         ]
         [ 1 color rgb <1, 1, 1>
         ]
      }
   }
   translate <0, 0, 0>
}

plane {
   <0, 1, 0>, 0
   
   finish {
      //*PMRawBegin
      Mirror
      //*PMRawEnd
   }
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

union {
   merge {
      //*PMName Sonnensymbol
      //*PMRawBegin
      #declare ticker=1;
      
      #while (ticker<13)
      
       object {strahl1
      	translate -4*z
      	rotate 30*ticker*y
       }
       #declare ticker=ticker+1;
      #end
      //*PMRawEnd
      
      cylinder {
         <0, 0.051, 0>, <0, 0, 0>, 2.1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
         hollow
      }
      
      texture {
         //*PMRawBegin
         Gold_Metal
         //*PMRawEnd
      }
      
      normal {
         radial
         turbulence <0.1, 0.1, 0.1>
         omega 0.2
         lambda 1
         frequency 12
      }
      scale 1
      rotate x*(-89.8)
      translate y*8
      no_shadow
      double_illuminate
      hollow
   }
   
   sphere {
      <0, 0, 0>, 1.95
      
      texture {
         //*PMRawBegin
         Gold_Metal
         //*PMRawEnd
      }
      scale <1, 1, 0.1>
      rotate <0, 0, 0>
      translate y*8
   }
   scale 1
   rotate y*33.3
   translate <0, 0, 0>
}

light_source {
   <-2, 8, -10>, rgb <1, 1, 1>
}

camera {
   perspective
   location <0, 8, -15>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0, 8, 0>
}