//*PMRawBegin
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
//*PMRawEnd

#declare sunbeam = prism {
   //*PMName strahl
   cubic_spline
   linear_sweep
   0, 0.1,
   14,
   <0, 2>, <0, 2>, <0.33, 1>, <0.3, 0>, <0.66, -1.5>, <0.6, -2.75>, <1, -4>, <-1, -4>, <-0.6, -2.75>, <-0.66, -1.5>, <-0.3, 0>, <-0.33, 1>, <0, 2>, <0, 2>
   sturm
   scale 0.5
   rotate y*180
   translate <0, 0, 0>
   hollow
}

global_settings {
   adc_bailout 0.0039216
   assumed_gamma 1.5
   max_trace_level 256
   noise_generator 2
}

sky_sphere {
   pigment {
      color rgb <0.4, 0.701961, 1>
   }
}

intersection {
   //*PMName Background
   
   plane {
      <0.019366, 1.3104, 0>, 0
      scale 1
      rotate <0, 0, 0>
      translate y*(-50)
      inverse
   }
   
   plane {
      <0, 1, 0>, 0
      
      texture {
         uv_mapping
         //*PMRawBegin
         Chrome_Metal
         //*PMRawEnd
         
         finish {
            crand 0.025
         }
      }
      scale 1
      rotate <90, -33.3, 0>
      translate z*7
      inverse
   }
   
   plane {
      <0.019365, 1.3104, 0>, 0
      
      texture {
         uv_mapping
         //*PMRawBegin
         Chrome_Metal
         //*PMRawEnd
         
         finish {
            crand 0.027
         }
      }
      scale 1
      rotate <90, 33.3, 0>
      translate z*7
      inverse
   }
}

union {
   union {
      //*PMName Elipsoid
      
      union {
         cone {
            <0, -0.4, 0>, 0.8,
            <0, -0.5, 0>, 1
            scale 1
            rotate <0, 0, 0>
            translate y*2.5
         }
         
         cylinder {
            <0, 0.5, 0>, <0, -0.5, 0>, 0.2
            scale 1
            rotate <-45, 0, 90>
            translate y*2.295
         }
         
         cylinder {
            <0, 5.2, 0>, <0, -5.2, 0>, 0.05
            
            texture {
               //*PMRawBegin
               Silver_Metal
               //*PMRawEnd
            }
            
            finish {
               ambient rgb <0, 0, 0>
               roughness 0.07
            }
            scale 1
            rotate <-45, 0, 90>
            translate y*2.42
         }
         
         texture {
            //*PMRawBegin
            Gold_Metal
            //*PMRawEnd
         }
         
         finish {
            roughness 0.05
         }
         no_shadow
      }
      
      difference {
         superellipsoid {
            <0.2, 0.2>
            scale 2
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.6, 1.6, 0.2>
            rotate <0, 0, 0>
            translate z*(-1.9)
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.6, 1.6, 0.2>
            rotate <0, 0, 0>
            translate z*1.9
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.6, 1.6, 0.2>
            rotate y*90
            translate x*1.9
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.6, 1.6, 0.2>
            rotate y*90
            translate x*(-1.9)
         }
         
         texture {
            //*PMRawBegin
            Polished_Chrome
            //*PMRawEnd
         }
         
         normal {
            granite
            -2
            bump_size -2
            accuracy 0.001
         }
         
         finish {
            roughness 0.05
         }
      }
      
      difference {
         superellipsoid {
            <0.2, 0.2>
            scale 2
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.6, 1.6, 0.2>
            rotate <0, 0, 0>
            translate z*(-1.9)
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.6, 1.6, 0.2>
            rotate <0, 0, 0>
            translate z*1.9
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.6, 1.6, 0.2>
            rotate y*90
            translate x*1.9
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.6, 1.6, 0.2>
            rotate y*90
            translate x*(-1.9)
         }
         
         pigment {
            granite
            
            color_map {
               [ 0 color rgb <1, 1, 0.97255>
               ]
               [ 0.4 color rgbt <0.933333, 0.933333, 0.933333, 1>
               ]
               [ 0.6 color rgbt <0.811765, 0.811765, 0.811765, 1>
               ]
               [ 1 color rgb <0.93333, 0.93333, 0.93333>
               ]
            }
         }
         
         normal {
            granite
            -2
            bump_size -2
            accuracy 0.001
         }
         scale 1.0001
      }
      
      superellipsoid {
         //*PMName Halo right
         <0.2, 0.2>
         
         pigment {
            color rgbt <0, 0, 0, 1>
         }
         
         interior {
            media {
               samples 1,10
               emission rgb <0.1, 0.1, 0.1>
            }
         }
         scale <1.54, 1.54, 4>
         rotate y*90
         translate x*5
         hollow
      }
      
      superellipsoid {
         //*PMName Halo left
         <0.2, 0.2>
         
         pigment {
            color rgbt <0, 0, 0, 1>
         }
         
         interior {
            media {
               samples 1,10
               emission rgb <0.1, 0.1, 0.1>
            }
         }
         scale <1.54, 1.54, 4>
         rotate <0, 0, 0>
         translate z*(-5)
         hollow
      }
      
      intersection {
         //*PMName background sun symbol
         
         box {
            <-1.55, -1.55, -0.001>, <1.55, 1.55, 0.001>
            
            texture {
               //*PMRawBegin
               Gold_Metal
               //*PMRawEnd
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.55, 1.55, 0.2>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale 1
         rotate <0, 0, 0>
         translate z*(-1.73)
      }
      
      intersection {
         box {
            <-1.55, -1.55, -0.001>, <1.55, 1.55, 0.001>
            
            texture {
               //*PMRawBegin
               Gold_Metal
               //*PMRawEnd
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.55, 1.55, 0.2>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale 1
         rotate <0, 0, 0>
         translate z*1.73
      }
      
      intersection {
         box {
            <-1.55, -1.55, -0.001>, <1.55, 1.55, 0.001>
            
            texture {
               //*PMRawBegin
               Gold_Metal
               //*PMRawEnd
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.55, 1.55, 0.2>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale 1
         rotate y*90
         translate x*(-1.73)
      }
      
      intersection {
         //*PMName background pentagram
         
         box {
            <-1.55, -1.55, -0.05>, <1.55, 1.55, 0.001>
            
            texture {
               //*PMRawBegin
               Gold_Metal
               //*PMRawEnd
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         superellipsoid {
            <0.2, 0.2>
            scale <1.55, 1.55, 0.2>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale 1
         rotate y*90
         translate x*1.73
      }
      
      union {
         //*PMName Sunsymbol
         
         merge {
            //*PMRawBegin
            #declare ticker=1;
            
            #while (ticker<13)
            
             object {sunbeam
            	translate -4*z
            	rotate 30*ticker*y
             }
             #declare ticker=ticker+1;
            #end
            //*PMRawEnd
            
            cylinder {
               <0, 0.051, 0>, <0, 0, 0>, 2.1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
               hollow
            }
            
            texture {
               //*PMRawBegin
               Gold_Metal
               //*PMRawEnd
            }
            
            normal {
               radial
               turbulence <0.1, 0.1, 0.1>
               omega 0.2
               lambda 1
               frequency 12
            }
            scale 1
            rotate x*(-89.8)
            translate y*8
            no_shadow
            double_illuminate
            hollow
         }
         
         sphere {
            <0, 0, 0>, 1.95
            
            texture {
               //*PMRawBegin
               Gold_Metal
               //*PMRawEnd
            }
            
            finish {
               roughness 0.05
            }
            scale <1, 1, 0.1>
            rotate <0, 0, 0>
            translate y*8
         }
         scale <0.2, 0.2, 1>
         rotate <0, 0, 0>
         translate <0, -1.6, -1.72>
      }
      
      union {
         //*PMName pentagramm
         
         difference {
            cylinder {
               <0, 0, 0>, <0, -0.0001, 0>, 4
               scale 1
               rotate x*(-90)
               translate y*(-1.026)
            }
            
            cylinder {
               <0, 0.0001, 0>, <0, -0.0002, 0>, 3.7
               scale 1
               rotate x*(-90)
               translate y*(-1.026)
            }
         }
         
         union {
            //*PMName Pentagramm
            
            box {
               <-3, -0.2, -0.0001>, <3, 0.2, 0>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            box {
               <-3, -0.2, -0.0001>, <3, 0.2, 0>
               scale 1
               rotate z*216
               translate <0.6, -1.725, 0>
            }
            
            box {
               <-3, -0.2, -0.0001>, <3, 0.2, 0>
               scale 1
               rotate z*72
               translate <-0.9, -0.61, 0>
            }
            
            box {
               <-3, -0.2, -0.0001>, <3, 0.2, 0>
               scale 1
               rotate z*288
               translate <0.9, -0.61, 0>
            }
            
            box {
               <-3, -0.2, -0.0001>, <3, 0.2, 0>
               scale 1
               rotate z*144
               translate <-0.6, -1.725, 0>
            }
            
            triangle {
               <-0.41236, -0.33969, 0>, <0.19644, -0.34036, 0>, <-0.108314, 0.579946, 0>
               scale 1
               rotate <0, 0, 0>
               translate <0.1083, 2.2202, -0.0001>
            }
            
            triangle {
               <-0.412357, -0.339695, 0>, <0.196438, -0.340356, 0>, <-0.105934, 0.587774, 0>
               scale 1
               rotate z*72
               translate <-2.99, 0.117, -0.0001>
            }
            
            triangle {
               <-0.412357, -0.339695, 0>, <0.196438, -0.340356, 0>, <-0.105934, 0.587774, 0>
               scale 1
               rotate <180, 0.3, 72108>
               translate <2.99, 0.117, -0.0001>
            }
            
            triangle {
               <-0.412357, -0.339695, 0>, <0.196438, -0.340356, 0>, <-0.105934, 0.587774, 0>
               scale 1
               rotate <-180, 0.3, 36.9>
               translate <1.95302, -3.46685, -0.0001>
            }
            
            triangle {
               <-0.412357, -0.339695, 0>, <0.196438, -0.340356, 0>, <-0.105934, 0.587774, 0>
               scale 1
               rotate <-180, 0.3, -37.2>
               translate <-1.78422, -3.59898, -0.0001>
            }
         }
         
         texture {
            //*PMRawBegin
            Gold_Metal
            //*PMRawEnd
         }
         
         normal {
            agate
            1
            agate_turb 0.1
         }
         
         finish {
            roughness 0.05
         }
         scale <0.25, 0.25, 1>
         rotate y*(-90)
         translate <1.75, 0.25, 0>
      }
      scale 1
      rotate y*45
      translate y*(-0.1)
   }
   
   union {
      //*PMName left pillar
      
      intersection {
         //*PMName Pyramid
         
         plane {
            //*PMName Seite 1
            <1, 0, 0>, 1
            rotate z*40
         }
         
         plane {
            //*PMName Seite 2
            <-1, 0, 0>, 1
            rotate z*(-40)
         }
         
         plane {
            //*PMName Seite 3
            <0, 0, 1>, 1
            rotate x*(-40)
         }
         
         plane {
            //*PMName Seite 4
            <0, 0, -1>, 1
            rotate x*40
         }
         
         plane {
            //*PMName Bodenplatte
            <0, -1, 0>, 0
            rotate <0, 0, 0>
         }
         
         material {
            //*PMRawBegin
            M_NB_Glass
            //*PMRawEnd
         }
         rotate <0, 0, 0>
         scale <0.5, 0.625, 0.5>
         translate <-3.6, 3.225, 0>
         no_shadow
         no_reflection
         hollow
      }
      
      cone {
         //*PMName Beam
         <4.66079, -1.46759, 0>, 0.2,
         <0.065, 0.325, 0>, 0.01
         
         pigment {
            color rgbt <0, 0, 0, 1>
         }
         
         interior {
            media {
               intervals 1
               samples 1,10
               emission rgb <2, 2, 0>
            }
         }
         scale <1, 1, 0.5>
         rotate <0, 0, 0>
         translate <-3.6667, 3.8667, 0>
         hollow
      }
      
      union {
         //*PMName Pillar
         
         cylinder {
            <0, 6, 0>, <0, -9, 0>, 0.7
            open
            
            material {
               //*PMRawBegin
               M_Glass3
               //*PMRawEnd
            }
            
            interior {
               media {
                  emission rgb <0, 0, 1>
               }
            }
            
            normal {
               leopard
               5
               scale <0.02, 0.075, 0.02>
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
            no_reflection
         }
         
         torus {
            0.66, 0.25
            
            texture {
               //*PMRawBegin
               Gold_Metal
               //*PMRawEnd
            }
            scale <1, 0.75, 1>
            rotate <0, 0, 0>
            translate y*6
         }
         
         box {
            <-1, -0.1, -1>, <1, 0.1, 1>
            
            material {
               //*PMRawBegin
               M_Glass3
               //*PMRawEnd
            }
            
            interior {
               media {
                  emission rgb <0, 0, 1>
               }
            }
            scale 1
            rotate <0, 0, 0>
            translate y*6.25
            hollow
         }
         scale 0.66
         rotate <0, 0, 0>
         translate <-3.6, -1, 0>
         no_shadow
      }
      rotate <0, 0, 0>
      translate x*(-1)
   }
   
   union {
      //*PMName right pillar
      
      intersection {
         //*PMName Pyramid
         
         plane {
            //*PMName Seite 1
            <1, 0, 0>, 1
            rotate z*40
         }
         
         plane {
            //*PMName Seite 2
            <-1, 0, 0>, 1
            rotate z*(-40)
         }
         
         plane {
            //*PMName Seite 3
            <0, 0, 1>, 1
            rotate x*(-40)
         }
         
         plane {
            //*PMName Seite 4
            <0, 0, -1>, 1
            rotate x*40
         }
         
         plane {
            //*PMName Bodenplatte
            <0, -1, 0>, 0
            rotate <0, 0, 0>
         }
         
         material {
            //*PMRawBegin
            M_NB_Glass
            //*PMRawEnd
         }
         rotate <0, 0, 0>
         scale <0.5, 0.625, 0.5>
         translate <3.6, 3.225, 0>
         no_shadow
         no_reflection
         hollow
      }
      
      cone {
         //*PMName Beam
         <4.65301, -1.48019, 0>, 0.2,
         <0.07, 0.325, 0>, 0.01
         
         pigment {
            color rgbt <0, 0, 0, 1>
         }
         
         interior {
            media {
               intervals 1
               samples 1,10
               emission rgb <2, 2, 0>
            }
         }
         scale <1, 1, 0.5>
         rotate y*180
         translate <3.6667, 3.8667, 0>
         hollow
      }
      
      union {
         //*PMName pillar
         
         cylinder {
            <0, 6, 0>, <0, -9, 0>, 0.7
            open
            
            material {
               //*PMRawBegin
               M_Glass3
               //*PMRawEnd
            }
            
            interior {
               media {
                  emission rgb <0, 0, 1>
               }
            }
            
            normal {
               leopard
               5
               scale <0.02, 0.075, 0.02>
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
            no_reflection
         }
         
         torus {
            0.66, 0.25
            
            texture {
               //*PMRawBegin
               Gold_Metal
               //*PMRawEnd
            }
            scale <1, 0.75, 1>
            rotate <0, 0, 0>
            translate y*6
         }
         
         box {
            <-1, -0.1, -1>, <1, 0.1, 1>
            
            material {
               //*PMRawBegin
               M_Glass3
               //*PMRawEnd
            }
            
            interior {
               media {
                  emission rgb <0, 0, 1>
               }
            }
            scale 1
            rotate <0, 0, 0>
            translate y*6.25
            hollow
         }
         scale 0.66
         rotate <0, 0, 0>
         translate <3.6, -1, 0>
         no_shadow
      }
      rotate <0, 0, 0>
      translate x*1
      no_shadow
      hollow
   }
   rotate x*(-26)
   translate y*(-0.5)
}

light_source {
   <5, 0, -5>, rgb <1, 1, 1>
}

light_source {
   <-5, 0, -5>, rgb <1, 1, 1>
}

light_source {
   <20, 15, 20>, rgb <1, 1, 1>
}

light_source {
   <-21, 15.4, 21>, rgb <1, 1, 1>
}

camera {
   perspective
   location <0, 0, -10>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0, 0, 0>
}