#macro m_strata (freq, amnt)
  function {f_noise3d(y*freq+f_noise3d(y+f_noise3d(x*4,y*4,z*4),z,x)*amnt,0,0)}
#end

#declare Rock_L1 = texture {
  pigment {
    m_strata (10, 1)
    turbulence 0.5
    color_map {
      [0.00 0.29 color Gray60 color Gray70]
      [0.29 0.31 color Gray70 color Gray60]
      [0.31 0.43 color Gray60 color White ]
      [0.43 0.64 color White  color Gray60]
      [0.64 0.69 color Gray60 color Gray90]
      [0.69 1.00 color Gray90 color Gray60]
    }
    scale 2
  }
  normal {granite 2 turbulence 0.4}
  finish {ambient 0.0 diffuse 0.75 brilliance 2}
  rotate 10*z 
}

#declare Rock_L2 = texture {
  pigment {
    crackle
    turbulence 0.5
    solid
    color_map {
      [0.0 color rgbf <0.9, 0.8, 0.8, 0.6>]
      [0.2 color Gray85 filter 0.6]
      [0.4 color Gray75 filter 0.6]
      [0.6 color White  filter 0.6]
      [1.0 color rgbf <0.9, 0.8, 0.7, 0.6>]
    }
  }
  normal {granite 0.5 turbulence 1.0}
  finish {ambient 0.0 diffuse 0.8 specular 0.125 brilliance 1}
  scale 12
}

#declare RockTex = texture {Rock_L1 scale 0.5} texture {Rock_L2 scale 0.55}

#declare MossTex = texture {
  pigment {
    granite
    turbulence 0.4
    color_map{
      [0.0 color DarkGreen]
      [0.1 color MediumForestGreen]
      [0.2 color ForestGreen]
      [0.7 color Tan]
      [0.9 color Gray]
      [1.0 color DarkGreen]
    }
  }
  finish {ambient 0.0 diffuse 0.6 crand 0.1 brilliance 1 phong 0.5 phong_size 100}
  normal {
    average
    normal_map {
      [1 granite 2 turbulence 0.4]
      [1 granite 1 turbulence 1.0 scale 5]
    }
  }    
  scale 0.1
}


  