//ImageB97 for POV-Ray 3.6: Return to the Rainforest   2007 Ch. Gerber

#include "colors.inc"
#include "functions.inc"
#include "mytextures.inc"

#declare Samples = 30; // fog media samples 10 for tests and higher values (25-35) for smoother results
#declare Fog = 1;
#declare Forest = 1;

global_settings {assumed_gamma 2.6 max_trace_level 256}


// --- Camera, Sun and Sky ---

#declare Cam_pos = <-160,120,0>;
#declare Cam_look_at = <-150,0,275>;
#declare Cam_dir = 1.3*z;
#declare Sun_dist = 1000000;
#declare Sun_az = -80;
#declare Sun_alt = 30;
#declare Sun_color = rgb <1.000,0.966,0.781>; 
#declare Sun_brightness = 2.3;
#declare Sky_color = rgb <0.439,0.549,0.867>;

camera {
  location  Cam_pos
  direction Cam_dir
  right 4/3*x
  look_at Cam_look_at
}

light_source { //sun
  z*Sun_dist  Sun_color*Sun_brightness
  rotate -x*Sun_alt  rotate y*Sun_az
  area_light <Sun_dist/15,0,0>,<0,Sun_dist/15,0>,5,5
  adaptive 1
  jitter
  circular
  orient 
} 

light_source { //fill light
  <1000,5000,-10000>
  color rgb 0.1
  media_attenuation off 
  media_interaction off
  shadowless
}

light_source {//fill light
  <10000,20000,-10000>
  color rgb 0.2
  media_attenuation off
  media_interaction off
}

sky_sphere {
  pigment {
    gradient y 
    color_map {[0.5 Sun_color*0.9][0.7 Sky_color]} 
    scale 2 
    translate -1*y
    warp {black_hole vaxis_rotate(vaxis_rotate(z,-x,Sun_alt),y,Sun_az), 1 inverse strength 1.5}
  }
  pigment {
    gradient y
    color_map  {[0.0 rgbt <0.5,0.7,0.8,0.5>][0.3 rgbt <0.2,0.2,0.8,1.0>]}
  }  
}


#if (Fog = 1)

fog {fog_type 2 color Sun_color distance 500 fog_alt 40 fog_offset 0 turbulence 1}

box {
  <-500,0,0>,<500,119,1000>
  texture {pigment {Clear} finish {ambient 0 diffuse 0}}
  hollow
  interior {
    media {
    //scattering {1,<0.439,0.420,0.396>*0.012 extinction 1} //more realistic but too slow
      emission <1.000,0.966,0.781>*0.008
      absorption<0.781,0.966,1.000>*0.008
      method 3
      intervals 1
      samples Samples,Samples
      jitter 1
      density {
        planar
        turbulence 1
        lambda 4
      }
      scale <60,70,60>
    }      
  }         
} 

#end //Fog

//--- Landscape and Forest ---

#declare Terrain = height_field { 
  tga "River.tga" smooth translate <-0.5,0,-0.5> rotate 90*y translate 0.5*z
  scale <1000,175,1000>
  texture {
    slope y
    texture_map {
      [0.0 RockTex]
      [0.8 RockTex]
      [0.9 MossTex]
      [1.0 MossTex]
    }
  }
}

object {Terrain}

#if (Forest = 1)

#include "palmemesh.inc"
#include "baum1mesh.inc"
#include "baum2mesh.inc"

#macro SLOPETest(Norm,MaxSlope)
  #declare STest = false;
  #if (vlength(Norm)!=0)
    #declare STest = true;
    #local Test = acos(vdot(Norm,y)/(vlength(Norm)*vlength(y)))*(180/pi);
    #if (Test > MaxSlope) #if (Test < 180-MaxSlope) #declare STest = false; #end #end
  #end  
#end

#macro mAlign(P1,P2)
  #local yV1 = vnormalize(P2-P1);
  #local xV1 = vnormalize(vcross(yV1,z));
  #local zV1 = vcross(xV1,yV1);
  matrix <xV1.x,xV1.y,xV1.z,yV1.x,yV1.y,yV1.z,zV1.x,zV1.y,zV1.z,P1.x,P1.y,P1.z>
#end
   
#declare Norm = <0,0,0>;
#declare Xpos = -400;
#declare Zpos = 0;
#declare MaxSlope = 20;
#declare MaxHeight = 200;
#declare MinHeight = 0;
#declare VegeSeed = seed(2002);
#declare Pig = pigment {spotted color_map {[0 rgb 1][1 rgb 0]} scale 20/3 translate <190,0,60>}
#declare step = 7.5/3;

#while (Xpos<300)
  #while (Zpos<900)
    #declare SPos = <Xpos,200,Zpos>;
    #declare PP = eval_pigment(Pig,<Xpos,0,Zpos>);
    #declare XX = PP.x;
    #declare Inter = trace (Terrain,SPos,<0,-1,0>,Norm);
    SLOPETest(Norm,MaxSlope)
    #if (STest=true)
      #if (Inter.y<MaxHeight & Inter.y>MinHeight) 
        #switch (XX)
          #range (0.7,1.0) 
            object {
              Palme translate 131*y scale 0.007*step
              scale 0.7+0.6*rand(VegeSeed)
              rotate 360*rand(VegeSeed)*y 
              translate <Inter.x+rand(VegeSeed)*step,Inter.y,Inter.z+rand(VegeSeed)*step> 
            }  
          #break
          #range (0.6,0.7) 
            object {
              lWOOD scale 2.8*step
              scale 0.7+0.6*rand(VegeSeed)
              rotate 360*rand(VegeSeed)*y 
              translate <Inter.x+rand(VegeSeed)*step,Inter.y,Inter.z+rand(VegeSeed)*step> 
            }  
          #break
          #range (0.0,0.3) 
            object {
              lTREE scale 2.8*step
              scale 0.7+0.6*rand(VegeSeed)
              rotate 360*rand(VegeSeed)*y 
              translate <Inter.x+rand(VegeSeed)*step,Inter.y,Inter.z+rand(VegeSeed)*step> 
            }  
          #break
          #else
            object {
              bTREE scale 2.4*step
              scale 0.7+0.6*rand(VegeSeed)
              rotate 360*rand(VegeSeed)*y 
              translate <Inter.x+rand(VegeSeed)*step,Inter.y,Inter.z+rand(VegeSeed)*step>
            }
        #end  
      #end 
    #end  
    #declare Zpos = Zpos + step;
  #end           
  #declare Zpos = 0;
  #declare Xpos = Xpos + step; 
#end

#end //Forest
