/*///////////////////////////////////////////////////////////////////////////////////////
/											/
/   Inverse Kinematics Include File (inverse_kinematics.inc)				/
/   											/
/   Sam Bleckley,   Nov-Dec 2006							/
/											/
/   Use it, enjoy it, change it. It'd be real nice if you gave me a credit.		/
/   Send me an email, tell me what you did with it. I'd love to hear.			/
/											/
/   Simple usage:									/
/											/
/   #include "inverse_kinematics.inc"							/
/   											/
/   #declare MyArm = array[NumberOfJoints][7];						/
/   #declare MyArm[0][0] = <0, 1, 0>;  		// Axis of rotation for this joint	/
/   #declare MyArm[0][1] = <-90, -90, -90>;	// Current rotation for this joint 	/
/						    // (same value all axes)		/
/   #declare MyArm[0][2] = <0, 0, 25>;		// Starting position of the endpoint	/
/						    // of limb segment. Limb  		/
/						    // segment begins with joint	/
/						    // @ <0, 0, 0> and extends there	/
/   #declare MyArm[0][3] = <-140, 1, 0>;	// X = Lower rotation limit --- set 	/
/						    // y to 0 if no limit		/
/   #declare MyArm[0][4] = <1, 0, 0>;		// Strength of rotational limit. 	/
/						    // Experimental. Lower should 	/
/						    // allow som extra flex		/
/   #declare MyArm[0][5] = <90, 1, 0>;		// X = Upper rotation limit. Set 	/
/						    // Y = 0 if no limit		/
/   #declare MyArm[0][6] = <1, 0, 0>;		// Strength of upper limit. 		/
/						    // Experimental.			/
/											/
/         // Continue for each joint...							/
/											/
/   #declare MyArmParts = array[NumberOfJoints];					/
/   #declare MyArmParts[0] = union{							/
/   	cylinder{<0, 0, 0>, <0, 0, 25>, 7.5}						/
/   	sphere{<0, 0, 0>, 10}								/
/   }											/
/											/
/	 // Again, do for each joint/semgent						/
/											/
/   move_arm(MyArm, <0, 18, 16>, "MyArmName", 1)					/
/   #declare FinishedArm = disp_arm(MyArm, MyArmParts)					/
/   object{FinishedArm translate <0, 0, 0>}						/
/											/
/   											/
///////////////////////////////////////////////////////////////////////////////////////*/


#macro disp_arm(arm, arm_parts)
	// Displays an arm given the position array and an array of limb-parts.
	// The array of arm-parts should 

	#declare i = dimension_size(arm, 1)-1;	// Loop will start at the end of the arm and works backwards.
	#declare armout = union{};            	// Loop will add each segemnt to armout
	#while(i>=0)				// start loop
		#declare armout = union {object{arm_parts[i]}  object{armout translate arm[i][2]} rotate arm[i][1]*arm[i][0]}   
						// Blargh. This ugly thing aligns the new segment to it's desired rotation, and places the
						// previous segments on the end of it at their NEW rotation.
		#declare i=i-1;			// Next arm segment
	#end					// End loop
	object{armout}				// Return the arm object
#end

#macro chdistance_arm(arm, limb, limbrotation, goal)
	// This performs the error-function on an arm-position array after a
	// potential movement of one joint --- that is, it only pretends to move
	// the limb, and seens what the result would be. It takes an arm position array,
	// the number of the joint moved in that array, the amount moved, and the
	// goal location of the tip of the arm. It is this macro (and the numbers
	// it recieves) that really determine the behavior of the arm. Better error
	// function = better arm positioning.

	#declare i = dimension_size(arm, 1)-1;
	#declare endloc = <0, 0, 0>;
	#declare armerr = 0;
	#declare endloc_sum =0;
	#while(i>=0)				// This loop runs through each limb, like disp_arm, but caculates only the endpoint.
						// When it runs into the joint which is to be moved, it adds the additional rotation
						// to the current rotation and then calculates. In addition, it will keep an eye
						// on the joints max and min rotation, adding error as needed, propotional to 
						// the distance past the max or minimum. This loop also keeps track of the total
						// y value of all the joints. This is for an experimental feature that makes the 
						// arm react to gravity.
		#if(i=limb)
			#declare endloc =  vrotate(endloc + arm[i][2], (arm[i][1]+limbrotation)*arm[i][0]);
			#if(i != dimension_size(arm, 1)-1)
				#declare endloc_sum = endloc_sum + endloc.y;
			#end
			#if((arm[i][1].x+limbrotation)<arm[i][3].x & arm[i][3].y=1)
				#declare armerr = armerr + abs(abs(arm[i][1].x+limbrotation)-abs(arm[i][3].x))*arm[i][4].x;
			#else 
				#if ((arm[i][1].x+limbrotation)>arm[i][5].x & arm[i][5].y = 1)
					#declare armerr = armerr + abs(abs(arm[i][1].x+limbrotation)-abs(arm[i][5].x))*arm[i][6].x;
				#end
			#end
		#else
			#declare endloc =  vrotate(endloc + arm[i][2], arm[i][1]*arm[i][0]); 
			#if(i != dimension_size(arm, 1)-1)
				#declare endloc_sum = endloc_sum + endloc.y;
			#end
			#if(arm[i][1].x<arm[i][3].x & arm[i][3].y=1)
				#declare armerr = armerr + abs(abs(arm[i][1].x)-abs(arm[i][3].x))*arm[i][4].x;
			#else
				#if (arm[i][1].x>arm[i][5].x & arm[i][5].y = 1)
					#declare armerr = armerr + abs(abs(arm[i][1].x)-abs(arm[i][5].x))*arm[i][6].x;
				#end
			#end
		#end
		#declare i=i-1;
	#end
	vlength(goal-endloc)+armerr*5-endloc_sum*.0   // Return the distance from tip to goal plus the 
#end



#macro curdistance_arm(arm, goal)
	//This performs the same function as chdistance_arm() without moving a joint.

	#declare i = dimension_size(arm, 1)-1;
	#declare endloc = <0, 0, 0>;
	#declare endloc_sum = 0;
	#declare armerr =0;
	#while(i>=0)
		/*
		#debug "Limb "
		#debug str(i, 0, 0)
		#debug " is rotated "
		#debug str(arm[i][1].x, 0, 2)
		#debug ". The added error is "
		*/
		#declare endloc =  vrotate(endloc + arm[i][2], arm[i][1]*arm[i][0]);
		#if(i != dimension_size(arm, 1)-1)
		#declare endloc_sum = endloc_sum + endloc.y;
		#end
		#if(arm[i][1].x<arm[i][3].x & arm[i][3].y=1)
			//#debug str(abs(abs(arm[i][1].x)-abs(arm[i][3].x))*arm[i][4].x, 0, 2)
			#declare armerr = armerr + abs(abs(arm[i][1].x)-abs(arm[i][3].x))*arm[i][4].x;
		#else
			#if (arm[i][1].x>arm[i][5].x & arm[i][5].y = 1)
				#declare armerr = armerr + abs(abs(arm[i][1].x)-abs(arm[i][5].x))*arm[i][6].x;
				//#debug str(abs(abs(arm[i][1].x)-abs(arm[i][5].x))*arm[i][6].x, 0, 2)
			#end
		#end
		//#debug "\n"
		#declare i=i-1;
	#end
	//#debug "ENDLOC: "
	//#debug vstr(3, endloc, ",", 0, 2)
	vlength(goal-endloc)+armerr*5-endloc_sum*.0
#end


#macro output_arm(arm, name)

// Saves arm position data in a file. Useful for animations, and for 
// avoiding the calculation time in long renders.

#fopen out concat("inverse_",name, ".txt") write
#declare i=0;
#while(i<dimension_size(arm, 1))
#declare j=0;
#while(j<dimension_size(arm, 2))
#write(out, arm[i][j], ", ")
#declare j=j+1;
#end
#write(out, "\n")
#declare i=i+1;
#end
#fclose out
#end

#macro input_arm(arm, name)

// Loads arm position data as saved by output_arm()

#fopen infile concat("inverse_", name, ".txt") read
#declare i=0; 
#while(i<dimension_size(arm, 1))
#read(infile, arm[i][0], arm[i][1], arm[i][2], arm[i][3], arm[i][4], arm[i][5], arm[i][6])#declare i= i+1;
#end
#fclose infile
arm
#end

#macro move_arm(arm, goal, name, in)

// This is the meat. It will test moving each joint in each direction and then
// determine from the error data which direction to move in and how fast.
// The numbers in this function are very difficult to tweak --- as they are
// they should be quite effective, but if they are out of tune, the whole 
// system becomes fascinatingly chaotic --- but not very good at IK.

// 'arm' is arm position array. 'goal' is vector of final destination of the tip of the arm.
// 'name' is the name of the generated text file holding position info. 'in' says whether to 
// read starting position from the text file. 0 = start without loading a position, 1 = load
// from the text file.

//#debug vstr(3, goal, ",",0, 2)
#if(in)
#declare arm = input_arm(arm, name)
#end

	#declare dist = curdistance_arm(arm, goal);
	#declare overflow = 0;
	#while(dist>.01 & overflow<100)
		#declare k=0;
		#while(k<dimension_size(arm, 1))
			#declare grada = chdistance_arm(arm, k, 1, goal);
			#declare gradb = chdistance_arm(arm, k, -1, goal);

			/*#debug "\n"
			#debug str(grada, 0, 2)
			#debug "<-- grada | gradb -->"
			#debug str(gradb, 0, 2)
			#debug "\n\n"
			*/

			//#if (grada > dist & gradb > dist)
			//#declare overflow=overflow+1;
			//#else
			#if(dist>1)
			#declare dist = sqrt(dist);
			#end
			#declare grad = (grada-gradb)*.5*dist;
			//#debug str(grad, 0, 2)
			//#debug "\n\n"
			#declare arm[k][1] = arm[k][1] - grad;
			//#end
			#declare k=k+1;
		
		        #declare dist = curdistance_arm(arm, goal);
		#end
		/*
		#debug name
		#debug ": "
		#debug str(dist, 0, 2)
		#debug "\n\n"
		*/
		#declare overflow = overflow + 1;
	#end
	output_arm(arm, name)
#end

#macro endpoint_arm(arm)

	// Finds the endpoint of the arm. Useful for placing objects that
	// have been picked up, etc. Input is arm position array.

	#declare i = dimension_size(arm, 1)-1;
	#declare endloc = <0, 0, 0>;
	#while(i>=0)
		#declare endloc =  vrotate(endloc + arm[i][2], arm[i][1]*arm[i][0]);
		#declare i=i-1;
	#end
	endloc
#end


#macro make_step(step_a, step_b, step_h, timer)

	// Associated macro for making a spline. Fast and loose --- there are better ways.

 #declare step = spline {
   natural_spline
  -0.5, step_a-<0, 0, 0>,
   0.0, step_a,
  0.5,  ((step_b+step_a)/2)*<1, 0, 1>+<0, step_h, 0>,
   1.0, step_b,
   1.5, step_b-<0,  0, 0>
  }
step(timer)
#end