// Inverse Kinematics Example File
// Sam Bleckley
// See include for details
// command-line: +w640 +h480 +kfi0 +kff60 +ki0 +kf3 +a0.01

#include "inverse_kinematics.inc"

///////////////////////////////////////////////////////////

// Scene bits.

camera{location <-150, 120, -150-60*clock> look_at <0, 80, 30-60*clock>}
light_source{<300, 600, -700> color rgb 1}
light_source{<-300, 100, -400> color rgb 1}
plane{y, 0 pigment{rgbt .5}}

#declare o = clock;

///////////////////////////////////////////////////////////

#include "body_top.inc" // This include contains all the necessary arrays ---
			// it contains position arrays for the arms and legs,
			// and parts_arrays as well.


///////////////////////////////////////////////////////////

// OK, this bit is for the body, not the IK stuff. this is all forward kinematics
// so I am just defining where things attach to the body and how the body moves
// as it walks. A lot of #declare but nothing particularly new.

#declare head_transform = transform { rotate -15*x translate 8*y }
#declare neck_transform = transform { rotate -10*x translate 37*y }

#declare right_arm_transform =transform{ translate <-20, 32, 0>}
#declare left_arm_transform = transform{ translate <20, 32, 0>}

#declare right_leg_transform = transform {translate <-10, 4, 0>}
#declare left_leg_transform = transform {translate <10, 4, 0>}

#switch(o)
#range(0, 1)
#declare uppertorso_transform= transform{ rotate cos(3.1415*(o-2))*8*y rotate -10*x translate <0, 20, 0>}
#declare lowertorso_transform = transform {rotate -cos(3.1415*o)*10*y translate <0, 65+7*abs(sin(clock*3.1415)), 30-60*clock>}
#range(1, 2)
#declare uppertorso_transform= transform{ rotate -cos(3.1415*(o-2))*8*y rotate -10*x translate <0, 20, 0>}
#declare lowertorso_transform = transform {rotate cos(3.1415*(o-1))*10*y translate <0, 65+7*abs(sin(clock*3.1415)), 30-60*clock>}
#range(2, 3)
#declare uppertorso_transform= transform{ rotate cos(3.1415*(o-2))*8*y rotate -10*x translate <0, 20, 0>}
#declare lowertorso_transform = transform {rotate -cos(3.1415*(o-2))*10*y translate <0, 65+7*abs(sin(clock*3.1415)), 30-60*clock>}
#end



//////////////////////////////////////////////////////////

#include "body_bottom.inc" // This include makes the body to attach the limbs to, in addition
		    	   // to doing some forward kinematics tricks to keep everything properly
			   // attatched.

//////////////////////////////////////////////////////////

// Declare the splines for taking steps, swinging arms, etc. This is the data I will
// pass to the include file. Beginning to get intimidated? Yeah. I'm sure there is a nicer
// way to make all this interface. But there you go.

#switch(o)
#range(0,1)
#declare right_leg_movement = <-10, 0, 0>;
#declare left_leg_movement = make_step(<10, 0, 60>, <10, 0, -60>, 10, o);
#declare right_arm_movement = vtransform(make_step(<-21.5, -15, 30>, <-21, -15, -30>, -25, o), uppertorso_transform); 
#declare left_arm_movement = vtransform(make_step(<21, -15, -30>, <21.5, -15, 30>, -25, o), uppertorso_transform); 
#break
#range(1,2)
#declare right_leg_movement = make_step(<-10, 0, 0>, <-10, 0, -120>, 10, o-1);
#declare left_leg_movement = <10, 0, -60>;
#declare right_arm_movement = vtransform(make_step(<-21, -15, -30>, <-21.5, -15, 30>, -25, o-1), uppertorso_transform); 
#declare left_arm_movement = vtransform(make_step(<21.5, -15, 30>, <21, -15, -30>, -25, o-1), uppertorso_transform); 
#break
#range(2,3)
#declare right_leg_movement = <-10, 0, -120>;
#declare left_leg_movement = make_step(<10, 0, -60>, <10, 0, -180>, 10, o-2);
#declare right_arm_movement = vtransform(make_step(<-21.5, -15, 30>, <-21, -15, -30>, -25, o-2), uppertorso_transform); 
#declare left_arm_movement = vtransform(make_step(<21, -15, -30>, <21.5, -15, 30>, -25, o-2), uppertorso_transform); 
#break

////////////////////////////////////////////////////////

// This bit tells the IK macro to load the position from the previous frame --- except 
// frame 0.

#end
#if(clock = 0)
#declare doi = 0;
#else
#declare doi = 1;
#end

////////////////////////////////////////////////////////

// Taaa Daaa! This is the bit where the IK is actually at work.

//Right Arm
move_arm(right_arm, vinv_transform(right_arm_movement, right_arm_transform), "right_arm", doi)
object{disp_arm(right_arm, right_arm_parts)  transform right_arm_transform texture{pigment {rgb 1}}}


//Left Arm
move_arm(left_arm, vinv_transform(left_arm_movement, left_arm_transform), "left_arm", doi)
object{disp_arm(left_arm, left_arm_parts)  transform left_arm_transform texture{pigment{rgb 1}}}


//Right Leg
move_arm(right_leg, vinv_transform(right_leg_movement, right_leg_transform), "right_leg", doi)
object{disp_arm(right_leg, right_leg_parts)  transform right_leg_transform texture{pigment{rgb 1}}}

//Right Foot
difference{
sphere{<0, 0,0>, 9 scale <.6, .7, 0>}
box{<-10, 0, -10>, <10, -10, 10>}
  rotate 10*y translate -8*z transform right_leg_transform translate endpoint_arm(right_leg)}


//Left Leg
move_arm(left_leg, vinv_transform(left_leg_movement, left_leg_transform), "left_leg", doi)
object{disp_arm(left_leg, left_leg_parts)  transform left_leg_transform texture{pigment{rgb 1}}}

//Left Foot
difference{
sphere{<0, 0,0>, 9 scale <.6, .7, 0>}
box{<-10, 0, -10>, <10, -10, 10>}
  rotate -10*y translate -8*z transform left_leg_transform translate endpoint_arm(left_leg)}











