//  Persistence of Vision Ray Tracer version 3.6 Include File
//  File:           srs.csg_text.csg_fontformat.inc
//  Author:         Randall Sawyer
//  Last updated:   2006.12.1.08:28
//  Manifest:       #macro csg_text
//  Dependencies:   intended for use with "*.csg_font.inc"

#ifndef(SRS_CSGFONT_UTILITY_INC_TEMP)
#declare SRS_CSGFONT_UTILITY_INC_TEMP = version;
#version 3.6;

#ifdef(View_POV_Include_Stack)
    #debug "\nincluding srs.csg_font.utility.inc\n"
#end

//  #macro csg_text
// Description:
//  Emulates POVRay command 'text{}' with default parameters.
// Usage:
//  csg_text( csg_font[CSG array], font_widths[float array], word[string] )
//      csg_font: the font you want to use (array of CSG objects)
//      font_widths: the companion array of character widths
//      word: the line of text you want to represent

#macro csg_text( csg_font, font_widths, word )
    #local len = strlen( word );
    #local tr = 0;
    #local i = 0;
    union {
        #while ( i < strlen(word) )
            object {
                csg_font[asc(substr(word,i+1,1))-32]
                translate tr*x
            }
            #local tr = tr + font_widths[asc(substr(word,i+1,1))-32];
            #local i = i + 1;
        #end//while
    }
#end//macro

#version SRS_CSGFONT_UTILITY_INC_TEMP;
#end//srs.csg_text.csg_fontformat.inc
