//  Persistence of Vision Ray Tracer version 3.6 Include File
//  File srs.wire.csg_font.inc
//  Author: Randall Sawyer
//  Last updated: 2006.11.30
//  Manifest: #macro wire_font, #macro wire_font_widths
//  Dependencies: "srs.torlipse.sphere_sweep.inc"

#ifndef(SRS_WIRE_CSGFONT_INC_TEMP)
#declare SRS_WIRE_CSGFONT_INC_TEMP = version;
#version 3.6;

#ifdef(View_POV_Include_Stack)
    #debug "\nincluding srs.wire.csg_font.inc\n"
#end

#include "srs.torlipse.sphere_sweep.inc"

// wire_font()
// Description:
//  Generates a CSG font out of spheres, cylinders, tori and sphere_sweeps.
//  See "srs.csg_font.standards.txt" for details.
// Usage:
//  wire_font( r[float] )
//  r: relative thickness of characters
// Recommended range of values for 'r':  0 < r <= 1.0

#macro wire_font( r )
    #local wf = array[95];
    #local dummy = sphere { <0, 0, 0>, 0 }
    #local s = 1/(12 + 2*r);
/* */
    #local wf[0] = union {
        object { dummy }
        object { dummy }
    }
/*!*/
    #local wf[1] = union {
        wf_segment ( <0, 8>, <0, 3>, r, 1, 1 )
        sphere { <0, 0, 0>, r }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*"*/
    #local wf[2] = union {
        wf_segment ( <0, 8>, <0, 6>, r, 1, 1 )
        wf_segment ( <3, 8>, <3, 6>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*#*/
    #local wf[3] = union {
        wf_segment ( <1, 6, 0>, <1, 0, 0>, r, 1, 1  )
        wf_segment ( <4, 6, 0>, <4, 0, 0>, r, 1, 1  )
        wf_segment ( <0, 1, 0>, <5, 1, 0>, r, 1, 1  )
        wf_segment ( <0, 5, 0>, <5, 5, 0>, r, 1, 1  )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*$*/
    #local wf[4] = union {
        wf_arc ( <2, 4.5>, 2.12132, 1.5, r, 0.339837, 1.5708 )
        wf_arc ( <2, 4.5>, 2, 1.5, r, 1.5708, 4.71239 )
        wf_arc ( <2, 1.5>, 2, 1.5, r, -1.5708, 1.5708 )
        wf_arc ( <2, 1.5>, 2.12132, 1.5, r, 3.48143, 4.71239 )
        wf_segment ( <2, 7>, <2, -1>, r, 1, 1  )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*%*/
    #local wf[5] = union {
        wf_segment ( <5, 7>, <0, 0>, r, 1, 1  )
        wf_arc ( <1, 6>, 1, 1, r, 0, 6.2832 )
        wf_arc ( <4, 1>, 1, 1, r, 0, 6.2832 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*&*/
    #local wf[6] = union {
        wf_segment ( <5, 0>, <1.18223, 5.42445>, r, 1, 0 )
        wf_arc ( <2, 6>, 1, 1, r, -0.848062, 3.75487 )
        wf_segment ( <2.66144, 5.25>, <0.677125, 3.5>, r, 0, 0 )
        wf_arc ( <2, 2>, 2, 2, r, 2.29353, 5.75959 )
        wf_segment ( <3.73205, 1>, <5, 3.19615>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*'*/
    #local wf[7] = union {
        wf_segment ( <0, 8>, <0, 6>, r, 1, 1 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*(*/
    #local wf[8] = union {
        wf_arc ( <5.66667, 3>, 5.66667, 5.66667, r, 2.06075, 4.22243 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*)*/
    #local wf[9] = union {
        wf_arc ( <-2.66667, 3>, 5.66667, 5.66667, r, -1.08084, 1.08084 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/***/
    #local wf[10] = union {
        wf_segment ( <2.5, 6.62866>, <2.5, 4>, r, 1, 0 )
        wf_segment ( <0, 4.8123>, <2.5, 4>, r, 1, 0 )
        wf_segment ( <0.954915, 1.87337>, <2.5, 4>, r, 1, 0 )
        wf_segment ( <4.04508, 1.87337>, <2.5, 4>, r, 1, 0 )
        wf_segment ( <5, 4.8123>, <2.5, 4>, r, 1, 0 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*+*/
    #local wf[11] = union {
        wf_segment ( <0, 4>, <4, 4>, r, 1, 1 )
        wf_segment ( <2, 2>, <2, 6>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*,*/
    #local wf[12] = union {
        wf_segment ( <0, -2, 0>, <1, 0, 0>, r, 1, 1 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*-*/
    #local wf[13] = union {
        wf_segment ( <0, 4>, <4, 4>, r, 1, 1 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*.*/
    #local wf[14] = union {
        sphere { <0, 0, 0>, r }
        object{ object { dummy } }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*fwd_slash*/
    #local wf[15] = union {
        wf_segment ( <0, 0, 0>, <4, 8, 0>, r, 1, 1 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*0*/
    #local wf[16] = union {
        wf_arc ( <3, 4>, 3, 4, r, 0, 6.2832 )
        wf_segment ( <1, 1, 0>, <5, 7, 0>, r, 0, 0 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*1*/
    #local wf[17] = union {
        wf_segment ( <0, 6>, <2, 8>, r, 1, 0 )
        wf_segment ( <2, 8>, <2, 0>, r, 1, 0 )
        wf_segment ( <0, 0>, <4, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*2*/
    #local wf[18] = union {
        wf_arc ( <3, 6>, 3.4641, 2, r, 1.5708, 2.61799 )
        wf_arc ( <3, 6>, 3, 2, r, -1.5708, 1.5708 )
        wf_arc ( <3, 0>, 3, 4, r, 1.5708, 3.14159 )
        wf_segment ( <0, 0>, <6, 0, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*3*/
    #local wf[19] = union {
        wf_arc ( <3, 6>, 3.4641, 2, r, 1.5708, 2.61799 )
        wf_arc ( <3, 6>, 3, 2, r, -1.5708, 1.5708 )
        wf_segment ( <3, 4, 0>, <4, 4, 0>, r, 1, 0 )
        wf_arc ( <3, 2>, 3, 2, r, -1.5708, 1.5708 )
        wf_arc ( <3, 2>, 3.4641, 2, r, -2.61799, -1.5708 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*4*/
    #local wf[20] = union {
        wf_segment ( <4, 0, 0>, <4, 8, 0>, r, 1, 0 )
        wf_segment ( <4, 8, 0>, <0, 2, 0>, r, 1, 0 )
        wf_segment ( <0, 2, 0>, <6, 2, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*5*/
    #local wf[21] = union {
        wf_segment ( <6, 8>, <0, 8>, r, 1, 0 )
        wf_segment ( <0, 8>, <0, 4>, r, 1, 0 )
        wf_arc ( <2.66667, 2.5>, 3.33333, 2.5, r, -2.49809, 2.49809 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*6*/
    #local wf[22] = union {
        wf_arc ( <3, 6>, 3, 2, r, 0.523599, 1.5708 )
        wf_arc ( <3, 5>, 3, 3, r, 1.5708, 3.14159 )
        wf_segment ( <0, 5>, <0, 2.5>, r, 0, 0 )
        wf_arc ( <3, 2.5>, 3, 2.5, r, 0, 6.2832 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*7*/
    #local wf[23] = union {
        wf_segment ( <0, 7>, <0, 8>, r, 1, 0 )
        wf_segment ( <0, 8>, <6, 8>, r, 1, 0 )
        wf_segment ( <6, 8>, <6, 7>, r, 1, 0 )
        wf_arc ( <12.6667, 0>, 9.66667, 9.66667, r, 2.33181, 3.14159 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*8*/
    #local wf[24] = union {
        wf_arc ( <3, 6.25>, 2, 1.75, r, 0, 6.2832 )
        wf_arc ( <3, 2.25>, 3, 2.25, r, 0, 6.2832 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*9*/
    #local wf[25] = union {
        wf_arc ( <3, 5.5>, 3, 2.5, r, 0, 6.2832 )
        wf_segment ( <6, 3>, <6, 5.5>, r, 0, 0 )
        wf_arc ( <3, 3>, 3, 3, r, -1.5708, 0 )
        wf_arc ( <3, 2>, 3, 2, r, 3.66519, 4.71239 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*;*/
    #local wf[26] = union {
        sphere { <1, 4>, r }
        wf_segment ( <1, 0>, <0, -2>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*:*/
    #local wf[27] = union {
        sphere { <0, 4>, r }
        sphere { <0, 0>, r }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*<*/
    #local wf[28] = union {
        wf_segment ( <4, 6>, <0, 4>, r, 1, 0 )
        wf_segment ( <0, 4>, <4, 2>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*=*/
    #local wf[29] = union {
        wf_segment ( <0, 3>, <4, 3>, r, 1, 1 )
        wf_segment ( <0, 5>, <4, 5>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*>*/
    #local wf[30] = union {
        wf_segment ( <0, 6>, <4, 4>, r, 1, 0 )
        wf_segment ( <4, 4>, <0, 2>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*?*/
    #local wf[31] = union {
        wf_arc ( <2, 6.5>, 2.12132, 1.5, r, 1.5708, 2.80176 )
        wf_arc ( <2, 6.5>, 2, 1.5, r, -0.753151, 1.5708 )
        wf_arc ( <15.6618, 3>, 13.6618, 5.50214, r, 2.67521, 3.14159 )
        sphere { <2, 0, 0>, r }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*@*/
    #local wf[32] = union {
        wf_arc ( <3, 3.5>, 1, 1.5, r, 0, 6.2832 )
        wf_arc ( <5, 3.5>, 1, 1.5, r, 3.14159, 6.2832 )
        wf_arc ( <3, 3.5>, 3, 3.5, r, 0, 5.1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*A*/
    #local wf[33] = union {
        wf_segment ( <0, 0>, <3, 8>, r, 1, 0 )
        wf_segment ( <3, 8>, <6, 0>, r, 1, 1 )
        wf_segment ( <0.75, 2>, <5.25, 2>, r, 0, 0 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*B*/
    #local wf[34] = union {
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        wf_segment ( <0, 8>, <4, 8>, r, 0, 0 )
        wf_arc ( <4, 6>, 2, 2, r, -1.5708, 1.5708 )
        wf_segment ( <4, 4>, <0, 4>, r, 0, 0 )
        wf_arc ( <4, 2>, 2, 2, r, -1.5708, 1.5708 )
        wf_segment ( <4, 0>, <0, 0>, r, 0, 0 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*C*/
    #local wf[35] = union {
        wf_arc ( <3.61133, 4>, 3.61133, 4, r, 0.848062, 5.43512 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*D*/
    #local wf[36] = union {
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        wf_segment ( <0, 8>, <3, 8>, r, 0, 0 )
        wf_arc ( <3, 4>, 3, 4, r, -1.5708, 1.5708 )
        wf_segment ( <3, 0>, <0, 0>, r, 0, 0 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*E*/
    #local wf[37] = union {
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        wf_segment ( <0, 8>, <6, 8>, r, 0, 1 )
        wf_segment ( <0, 4>, <4, 4>, r, 0, 1 )
        wf_segment ( <0, 0>, <6, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*F*/
    #local wf[38] = union {
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        wf_segment ( <0, 8>, <6, 8>, r, 0, 1 )
        wf_segment ( <0, 4>, <4, 4>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*G*/
    #local wf[39] = union {
        wf_arc ( <3.61133, 4>, 3.61133, 4, r, 0.848062, 5.43512 )
        wf_segment ( <6, 1>, <6, 4>, r, 0, 1 )
        wf_segment ( <6, 4>, <4, 4>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*H*/
    #local wf[40] = union {
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        wf_segment ( <6, 8>, <6, 0>, r, 1, 1 )
        wf_segment ( <0, 4>, <6, 4>, r, 0, 0 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*I*/
    #local wf[41] = union {
        wf_segment ( <0, 8>, <4, 8>, r, 1, 1 )
        wf_segment ( <2, 8>, <2, 0>, r, 0, 0 )
        wf_segment ( <0, 0>, <4, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*J*/
    #local wf[42] = union {
        wf_segment ( <1, 8>, <6, 8>, r, 1, 1 )
        wf_segment ( <4, 8>, <4, 2>, r, 0, 0 )
        wf_arc ( <2, 2>, 2, 2, r, -3.14159, 0 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*K*/
    #local wf[43] = union {
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        wf_segment ( <6, 8>, <0, 2>, r, 1, 0 )
        wf_segment ( <2, 4>, <6, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*L*/
    #local wf[44] = union {
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        wf_segment ( <0, 0>, <6, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*M*/
    #local wf[45] = union {
        wf_segment ( <0, 0>, <0, 8>, r, 1, 1 )
        wf_segment ( <0, 8>, <3, 4>, r, 0, 1 )
        wf_segment ( <3, 4>, <6, 8>, r, 0, 1 )
        wf_segment ( <6, 8>, <6, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*N*/
    #local wf[46] = union {
        wf_segment ( <0, 0>, <0, 8>, r, 1, 1 )
        wf_segment ( <0, 8>, <6, 0>, r, 0, 1 )
        wf_segment ( <6, 0>, <6, 8>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*O*/
    #local wf[47] = union {
        wf_arc ( <3, 4>, 3, 4, r, 0, 6.2832 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*P*/
    #local wf[48] = union {
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        wf_segment ( <0, 8>, <4, 8>, r, 0, 0 )
        wf_arc ( <4, 6>, 2, 2, r, -1.5708, 1.5708 )
        wf_segment ( <4, 4>, <0, 4>, r, 0, 0 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*Q*/
    #local wf[49] = union {
        wf_arc ( <3, 4>, 3, 4, r, 0, 6.2832 )
        wf_segment ( <4, 2>, <6, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*R*/
    #local wf[50] = union {
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        wf_segment ( <0, 8>, <4, 8>, r, 0, 0 )
        wf_arc ( <4, 6>, 2, 2, r, -1.5708, 1.5708 )
        wf_segment ( <4, 4>, <0, 4>, r, 0, 0 )
        wf_segment ( <4, 4>, <6, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*S*/
    #local wf[51] = union {
        wf_arc ( <3, 6>, 3.4641, 2, r, 0.523599, 1.5708 )
        wf_arc ( <3, 6>, 3, 2, r, 1.5708, 4.71239 )
        wf_arc ( <3, 2>, 3, 2, r, -1.5708, 1.5708 )
        wf_arc ( <3, 2>, 3.4641, 2, r, 3.66519, 4.71239 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*T*/
    #local wf[52] = union {
        wf_segment ( <0, 8>, <6, 8>, r, 1, 1 )
        wf_segment ( <3, 8>, <3, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*U*/
    #local wf[53] = union {
        wf_segment ( <0, 8>, <0, 3>, r, 1, 0 )
        wf_arc ( <3, 3>, 3, 3, r, -3.14159, 0 )
        wf_segment ( <6, 3>, <6, 8>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*V*/
    #local wf[54] = union {
        wf_segment ( <0, 8>, <3, 0>, r, 1, 1 )
        wf_segment ( <3, 0>, <6, 8>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*W*/
    #local wf[55] = union {
        wf_segment ( <0, 8>, <1, 0>, r, 1, 1 )
        wf_segment ( <1, 0>, <3, 4>, r, 0, 1 )
        wf_segment ( <3, 4>, <5, 0>, r, 0, 1 )
        wf_segment ( <5, 0>, <7, 8>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*X*/
    #local wf[56] = union {
        wf_segment ( <0, 8>, <6, 0>, r, 1, 1 )
        wf_segment ( <6, 8>, <0, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*Y*/
    #local wf[57] = union {
        wf_segment ( <0, 8>, <3, 4>, r, 1, 0 )
        wf_segment ( <3, 4>, <6, 8>, r, 0, 1 )
        wf_segment ( <3, 4>, <3, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*Z*/
    #local wf[58] = union {
        wf_segment ( <0, 8>, <6, 8>, r, 1, 1 )
        wf_segment ( <6, 8>, <0, 0>, r, 0, 1 )
        wf_segment ( <0, 0>, <6, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*[*/
    #local wf[59] = union {
        wf_segment ( <3, 8>, <0, 8>, r, 1, 1 )
        wf_segment ( <0, 8>, <0, -2>, r, 0, 1 )
        wf_segment ( <0, -2>, <3, -2>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*\*/
    #local wf[60] = union {
        wf_segment ( <4, 0>, <0, 8>, r, 1, 1 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*]*/
    #local wf[61] = union {
        wf_segment ( <0, 8>, <3, 8>, r, 1, 1 )
        wf_segment ( <3, 8>, <3, -2>, r, 0, 1 )
        wf_segment ( <3, -2>, <0, -2>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*^*/
    #local wf[62] = union {
        wf_segment ( <0, 6>, <2, 8>, r, 1, 1 )
        wf_segment ( <2, 8>, <4, 6>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*_*/
    #local wf[63] = union {
        wf_segment ( <0, -2>, <6, -2>, r, 1, 1 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*`*/
    #local wf[64] = union {
        wf_segment ( <0, 8>, <2, 6>, r, 1, 1 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*a*/
    #local wf[65] = union {
        wf_arc ( <2, 2>, 2, 2, r, 0, 6.2832 )
        wf_segment ( <4, 4>, <4, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*b*/
    #local wf[66] = union {
        wf_arc ( <2, 2>, 2, 2, r, 0, 6.2832 )
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*c*/
    #local wf[67] = union {
        wf_arc ( <2.40755, 2>, 2.40755, 2, r, 0.848062, 5.43512 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*d*/
    #local wf[68] = union {
        wf_arc ( <2, 2>, 2, 2, r, 0, 6.2832 )
        wf_segment ( <4, 8>, <4, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*e*/
    #local wf[69] = union {
        wf_segment ( <0, 2>, <4, 2>, r, 0, 1 )
        wf_arc ( <2, 2>, 2, 2, r, 0, 3.14159 )
        wf_arc ( <2.40755, 2>, 2.40755, 2, r, 3.14159, 5.43512 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*f*/
    #local wf[70] = union {
        wf_arc ( <2, 7>, 1, 1, r, 0, 3.14159 )
        wf_segment ( <1, 7>, <1, 0>, r, 0, 1 )
        wf_segment ( <0, 4>, <3, 4>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*g*/
    #local wf[71] = union {
        wf_arc ( <2, 2>, 2, 2, r, 0, 6.2832 )
        wf_segment ( <4, 4>, <4, 0>, r, 1, 0 )
        wf_arc ( <1.59245, 0>, 2.40755, 2, r, 3.98965, 6.2832 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*h*/
    #local wf[72] = union {
        wf_arc ( <2, 2>, 2, 2, r, 0, 3.14159 )
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        wf_segment ( <4, 2>, <4, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*i*/
    #local wf[73] = union {
        sphere { <0, 6, 0>, r }
        wf_segment ( <0, 4>, <0, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*j*/
    #local wf[74] = union {
        sphere { <2, 6, 0>, r }
        wf_segment ( <2, 4>, <2, -1>, r, 1, 0 )
        wf_arc ( <1, -1>, 1, 1, r, 3.14159, 6.2832 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*k*/
    #local wf[75] = union {
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        wf_segment ( <0, 0>, <4, 4>, r, 0, 1 )
        wf_segment ( <2, 2>, <4, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*l*/
    #local wf[76] = union {
        wf_segment ( <0, 8>, <0, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*m*/
    #local wf[77] = union {
        wf_arc ( <1.5, 2.5>, 1.5, 1.5, r, 0, 3.14159 )
        wf_arc ( <4.5, 2.5>, 1.5, 1.5, r, 0, 3.14159 )
        wf_segment ( <0, 4>, <0, 0>, r, 1, 1 )
        wf_segment ( <3, 2.5>, <3, 0>, r, 0, 1 )
        wf_segment ( <6, 2.5>, <6, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*n*/
    #local wf[78] = union {
        wf_arc ( <2, 2>, 2, 2, r, 0, 3.14159 )
        wf_segment ( <0, 4>, <0, 0>, r, 1, 1 )
        wf_segment ( <4, 2>, <4, 0>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*o*/
    #local wf[79] = union {
        wf_arc ( <2, 2>, 2, 2, r, 0, 6.2832 )
        object { dummy }
        translate <r, 0, r>
        scale <s, s, s>
    }
/*p*/
    #local wf[80] = union {
        wf_arc ( <2, 2>, 2, 2, r, 0, 6.2832 )
        wf_segment ( <0, 4>, <0, -2>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*q*/
    #local wf[81] = union {
        wf_arc ( <2, 2>, 2, 2, r, 0, 6.2832 )
        wf_segment ( <4, 4>, <4, -2>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*r*/
    #local wf[82] = union {
        wf_arc ( <2.40755, 2>, 2.40755, 2, r, 0.848062, 3.14159 )
        wf_segment ( <0, 4>, <0, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*s*/
    #local wf[83] = union {
        wf_arc ( <2.40755, 3>, 2.40755, 1, r, 0.848062, 1.5708 )
        wf_arc ( <2, 3>, 2, 1, r, 1.5708, 4.71239 )
        wf_arc ( <2, 1>, 2, 1, r, -1.5708, 1.5708 )
        wf_arc ( <1.59245, 1>, 2.40755, 1, r, 3.98965, 4.71239 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*t*/
    #local wf[84] = union {
        wf_segment ( <1, 6>, <1, 1>, r, 1, 0 )
        wf_arc ( <2, 1>, 1, 1, r, 3.14159, 6.2832 )
        wf_segment ( <0, 4>, <3, 4>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*u*/
    #local wf[85] = union {
        wf_segment ( <0, 4>, <0, 2>, r, 1, 0 )
        wf_arc ( <2, 2>, 2, 2, r, 3.14159, 6.2832 )
        wf_segment ( <4, 4>, <4, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*v*/
    #local wf[86] = union {
        wf_segment ( <0, 4>, <2, 0>, r, 1, 1 )
        wf_segment ( <2, 0>, <4, 4>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*w*/
    #local wf[87] = union {
        wf_segment ( <0, 4>, <1.5, 0>, r, 1, 1 )
        wf_segment ( <1.5, 0>, <3, 4>, r, 0, 1 )
        wf_segment ( <3, 4>, <4.5, 0>, r, 1, 1 )
        wf_segment ( <4.5, 0>, <6, 4>, r, 0, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*x*/
    #local wf[88] = union {
        wf_segment ( <0, 4>, <4, 0>, r, 1, 1 )
        wf_segment ( <0, 0>, <4, 4>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*y*/
    #local wf[89] = union {
        wf_segment ( <0, 4>, <0, 2>, r, 1, 0 )
        wf_arc ( <2, 2>, 2, 2, r, 3.14159, 6.2832 )
        wf_segment ( <4, 4>, <4, 0>, r, 1, 0 )
        wf_arc ( <1.59245, 0>, 2.40755, 2, r, 3.98965, 6.2832 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*z*/
    #local wf[90] = union {
        wf_segment ( <0, 4>, <4, 4>, r, 1, 1 )
        wf_segment ( <4, 4>, <0, 0>, r, 1, 1 )
        wf_segment ( <0, 0>, <4, 0>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*{*/
    #local wf[91] = union {
        wf_arc ( <3, 5.5>, 1.5, 2.5, r, 1.5708, 3.14159 )
        wf_arc ( <0, 5.5>, 1.5, 2.5, r, 4.71239, 6.2832 )
        wf_arc ( <0, 0.5>, 1.5, 2.5, r, 0, 1.5708 )
        wf_arc ( <3, 0.5>, 1.5, 2.5, r, 3.14159, 4.71239 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*|*/
    #local wf[92] = union {
        wf_segment ( <0, 8>, <0, -2>, r, 1, 1 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*}*/
    #local wf[93] = union {
        wf_arc ( <0, 5.5>, 1.5, 2.5, r, 0, 1.5708 )
        wf_arc ( <3, 5.5>, 1.5, 2.5, r, 3.14159, 4.71239 )
        wf_arc ( <3, 0.5>, 1.5, 2.5, r, 1.5708, 3.14159 )
        wf_arc ( <0, 0.5>, 1.5, 2.5, r, 4.71239, 6.2832 )
        translate <r, 0, r>
        scale <s, s, s>
    }
/*~*/
    #local wf[94] = union {
        wf_arc ( <1, 2.26795>, 2, 2, r, 1.0472, 2.0944 )
        wf_arc ( <3, 5.73205>, 2, 2, r, 4.18879, 5.23599 )
        translate <r, 0, r>
        scale <s, s, s>
    }
    wf//return array
#end//wire_font

// wire_font_widths()
// Description:
//  Generates the array of widths for 'wire_font()'.
//  See "srs.csg_font.standards.txt" for details.
// Usage:
//  wire_font_widths( r[float] )
//  r: use same 'r' value passed into 'wire_font()'

#macro wire_font_widths( r )
    #local s = 1/(12 + 2*r);
    #local wf_widths = array[95] {
        6, 2, 5, 7, 6, 7, 7, 2, 5, 5, 7, 6,
        3, 6, 2, 6, 8, 6, 8, 8, 8, 8, 8, 8,
        8, 8, 3, 2, 6, 6, 6, 6, 8, 8, 8, 8,
        8, 8, 8, 8, 8, 6, 8, 8, 8, 8, 8, 8,
        8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 5,
        6, 5, 6, 8, 4, 6, 6, 6, 6, 6, 5, 6,
        6, 2, 4, 6, 2, 8, 6, 6, 6, 6, 6, 6,
        5, 6, 6, 8, 6, 6, 6, 5, 2, 5, 6
    }
    #local i = 0;
    #while ( i < 95 )
        #local wf_widths[i] = ( wf_widths[i] + 2 * r ) * s;
        #local i = i + 1;
    #end//while
    wf_widths
#end

// Internal macro - not intended to be called by user.
#macro wf_segment( A, B, r, sphere_at_A, sphere_at_B )
    #if ( sphere_at_A )
        sphere { <A.x, A.y, 0>, r }
    #end
    #if ( sphere_at_B )
        sphere { <B.x, B.y, 0>, r }
    #end
    cylinder { <A.x, A.y, 0>, <B.x, B.y, 0>, r }
#end//wf_segment

// Internal macro - not intended to be called by user.
#macro wf_arc( o, a, b, r, th0, th1 )
    #if ( a = b & !(abs(th1-th0) < 2*pi) )
        torus { a, r rotate -90*x translate <o.x, o.y, 0> }
    #else
        object {
            torlipse ( a, b, r, th0, th1, 72, 1 )
            rotate -90*x
            translate <o.x, o.y, 0>
        }
    #end//if
#end//wf_arc

#version SRS_WIRE_CSGFONT_INC_TEMP;
#end//srs.wire.csg_font.inc
