//  Persistence of Vision Ray Tracer version 3.6 Include File
//  File srs.torlipse.sphere_sweep.inc
//  Author: Randall Sawyer
//  Last updated: 2006.11.30
//  Manifest: #macro torlipse
//  Dependencies: none

#ifndef(SRS_TORLIPSE_SPHERESWEEP_INC_TEMP)
#declare SRS_TORLIPSE_SPHERESWEEP_INC_TEMP = version;
#version 3.6;

#ifdef(View_POV_Include_Stack)
    #debug "\nincluding srs.torlipse.sphere_sweep.inc\n"
#end

// torlipse()
// Description:
//  Sweeps a constant sphere about a parameterized ellipse in the x-z plane, centered at <0, 0, 0>.
// <x, y, z> = <a*cos(th), 0, b*sin(th)>
// Usage:
//  torlipse( a[float], b[float], r[float], th0[float], th1[float], n[float[integer]], tol[float] )
//  a: radius of ellipse on x-axis
//  b: radius of ellipse on z-axis
//  r: radius of sphere
//  th0: initial parameter value
//  th1: terminal parameter value
// Use th0 = 0 and th1 = 2*pi for a complete torlipse object.
// If the difference of th0 and th1 is less than 2*pi, then the result is an arc.
// Either value, th0 or th1, may be greater.
//  n: number of spline nodes along a complete torlipse - excepting redundancies
// Increase 'n' if the object looks lumpy.
//  tol: tolerance value to be passed on to sphere_sweep object
// Adjust 'tol' as needed.

#macro torlipse( a, b, r, th0, th1, n, tol )
    #local m = floor( n*abs(th1-th0)/(2*pi)+0.5 );
    sphere_sweep {
        b_spline
            m+3,
            #local i = -1;
            #while ( i <= m+1 )
                #local th = th0 + (th1 - th0) * i / m;
                <a*cos(th), 0, b*sin(th)>, r
                #local i=i+1;
            #end//while
         tolerance tol
    }
#end//torlipse


#version SRS_TORLIPSE_SPHERESWEEP_INC_TEMP;
#end//srs.torlipse.sphere_sweep.inc
