//  Persistence of Vision Ray Tracer version 3.6 Include File
//  File srs.csg_font.utility.inc
//  Author: Randall Sawyer
//  Last updated: 2006.11.30
//  Manifest: #macro csg_text
//  Dependencies: intended for use with *.csg_font.inc

#ifndef(SRS_CSGFONT_UTILITY_INC_TEMP)
#declare SRS_CSGFONT_UTILITY_INC_TEMP = version;
#version 3.6;

#ifdef(View_POV_Include_Stack)
    #debug "\nincluding srs.csg_font.utility.inc\n"
#end

// #macro csg_text()
// Description:
//  Emulates POVRay finite solid primitive 'text' for use with a CSG font.
//  See "srs.csg_font.standards.txt" for details about CSG fonts.
// Usage:
//  csg_text( csg_font[CSG array], font_widths[float array], string[string] )
//  csg_font: the font you want to use: an array of CSGs
//  font_widths: the companion array of character widths
//  string: the line of text you would want

#macro csg_text( csg_font, font_widths, string )
    #local len = strlen( string );
    #if ( len > 0 )
        #local tr = 0;
        #local i = 0;
        #if ( len > 1 ) union { #end//if
        #while ( i < strlen(string) )
            object {
                csg_font[asc(substr(string,i+1,1))-32]
                translate tr*x
            }
            #local tr = tr + font_widths[asc(substr(string,i+1,1))-32];
            #local i = i + 1;
        #end//while
        #if ( len > 1 ) } #end//if
    #end//if
#end//macro

#version SRS_CSGFONT_UTILITY_INC_TEMP;
#end//srs.csg_font.utility.inc
