//  Persistence of Vision Ray Tracer version 3.6 Render File
//  File csg_font.preview.inc
//  Author: Randall Sawyer
//  Last updated: 2006.11.30
//  Dependencies: "srs.csg_font.utility.inc", "srs.wire.csg_font.inc"
//  Description: File for rendering all of the objects in a CSG font.
//  Replace the file name in the second #include line to view a different CSG font.

#include "srs.csg_font.utility.inc"
#include "srs.wire.csg_font.inc"

#declare csg_font = wire_font( 1 )
#declare font_widths = wire_font_widths( 1 )

#declare line_1 = csg_text( csg_font, font_widths, " !\"#$%&'()*+,-./" )
#declare line_2 = csg_text( csg_font, font_widths, "0123456789;:<" )
#declare line_3 = csg_text( csg_font, font_widths, "=>?@ABCDEFGH" )
#declare line_4 = csg_text( csg_font, font_widths, "IJKLMNOPQRS" )
#declare line_5 = csg_text( csg_font, font_widths, "TUVWXYZ[\\]^_`" )
#declare line_6 = csg_text( csg_font, font_widths, "abcdefghijklmnop" )
#declare line_7 = csg_text( csg_font, font_widths, "qrstuvwxyz{|}~" )

#declare h = 1.1*(max_extent(line_1).y - min_extent(line_1).y);



union {
    object { line_1 translate -0.5*max_extent(line_1).x*x + 3.0*h*y }
    object { line_2 translate -0.5*max_extent(line_2).x*x + 2.0*h*y }
    object { line_3 translate -0.5*max_extent(line_3).x*x + 1.0*h*y }
    object { line_4 translate -0.5*max_extent(line_4).x*x + 0.0*h*y }
    object { line_5 translate -0.5*max_extent(line_5).x*x - 1.0*h*y }
    object { line_6 translate -0.5*max_extent(line_6).x*x - 2.0*h*y }
    object { line_7 translate -0.5*max_extent(line_7).x*x - 3.0*h*y }
    pigment { color rgb <1, 1, 1> }
    finish { ambient color 0.25 }
}

camera {
    orthographic
    up <0, 9*h, 0>
    right <12*h, 0, 0>
    location <0, 0, -100>
    look_at  <0, 0,  0>
}

light_source { <-100, 200, -223.607> color rgb <1, 1, 1> }
