// wavl_rgb.inc v1.0 (2005) by Florian Siegmund (florian.siegmund@gmx.at)
//
// "convert_wl_to_rgb" macro:
// output: three-dimensional vector (rgb)
// average of all possible output vectors is <1, 1, 1> (white)
//
// "convert_wl_to_rgb_n" macro:
// output: three-dimensional vector (rgb)
// maximum value for red, green and blue is 1 to keep it in range of displayable colors
// (spectrum is normalized)
//
// syntax:
//
// color rgb convert_wl_to_rgb (FLOAT)  // FLOAT = [380; 700]  // (wavelength in nanometres)
//
// or:
//
// colour rgb convert_wl_to_rgb (FLOAT) // FLOAT = [380; 700]  // (wavelength in nanometres)

#version 3.6;

// blue:    [380; 445] & ]445; 550]  (max: 1.8)
// green:   [420; 690]  (max: 1.0)
// red_1:   [380; 500]  (max: 0.35)
// red_2:   ]500; 700]  (max: 1.05)

#macro convert_wl_to_rgb (wavelength_0)
    // red:
    (
    #if (wavelength_0 >= 380 & wavelength_0 <= 500)
        (cos (pi+2*pi*(wavelength_0-380)/120)+1)/2*0.35/0.393789375*x
    #else
        #if (wavelength_0 > 500 & wavelength_0 <= 700)
            (cos (pi+2*pi*(wavelength_0-500)/200)+1)/2*1.05/0.393789375*x
        #else
            <0, 0, 0>
        #end
    #end
    +
    // green:
    #if (wavelength_0 >= 420 & wavelength_0 <= 690)
        (cos (pi+2*pi*(wavelength_0-420)/270)+1)/2/0.4219171875*y
    #else
        <0, 0, 0>
    #end
    +
    // blue:
    #if (wavelength_0 >= 380 & wavelength_0 <= 445)
        (cos (pi+pi*(wavelength_0-380)/65)+1)/2*1.8/0.478125*z
    #else
        #if (wavelength_0 > 445 & wavelength_0 <= 550)
            (cos (pi*(wavelength_0-445)/105)+1)/2*1.8/0.478125*z
        #else
            <0, 0, 0>
        #end
    #end
    )
#end

#macro convert_wl_to_rgb_n (wavelength_0)
    // red:
    (
    #if (wavelength_0 >= 380 & wavelength_0 <= 500)
        (cos (pi+2*pi*(wavelength_0-380)/120)+1)/2*0.35/0.393789375/1.8*0.478125*x
    #else
        #if (wavelength_0 > 500 & wavelength_0 <= 700)
            (cos (pi+2*pi*(wavelength_0-500)/200)+1)/2*1.05/0.393789375/1.8*0.478125*x
        #else
            <0, 0, 0>
        #end
    #end
    +
    // green:
    #if (wavelength_0 >= 420 & wavelength_0 <= 690)
        (cos (pi+2*pi*(wavelength_0-420)/270)+1)/2/0.4219171875/1.8*0.478125*y
    #else
        <0, 0, 0>
    #end
    +
    // blue:
    #if (wavelength_0 >= 380 & wavelength_0 <= 445)
        (cos (pi+pi*(wavelength_0-380)/65)+1)/2*z
    #else
        #if (wavelength_0 > 445 & wavelength_0 <= 550)
            (cos (pi*(wavelength_0-445)/105)+1)/2*z
        #else
            <0, 0, 0>
        #end
    #end
    )
#end
