// Persistence of Vision Ray Tracer Scene Description File
// File: ChessPieces.pov
// Vers: 3.5
// Desc: Render the chess pieces included in chess.inc
// Date: 12/1/2004
// Auth: Sean Day
//                                                        
/*      I apologise for the lack of comments/descriptions for how this source file actually works. I can't remember
        exactly what the parameters to the macro's do. Also I am sure they don't work very well anyway when changed from 
        the default values. I think they are roughly      

        Piece(effect_radius_of_base, effect_height_of_base, effect_edge_radius, effect_total_height, type_of_piece)
        
*/ 


#version 3.5;

#include "colors.inc"    
#include "math.inc"
#include "functions.inc"      
#include "textures.inc"     
#include "chess.inc"  

camera {    
  location  <0, 5, -15>  
  direction 1.5*z
  up y
  right     x*image_width/image_height
  look_at   <0, 0,  0>      
}
// Create an infinite sphere around scene and allow any pigment on it
sky_sphere {
  pigment {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color rgb <0.5, 0.5, 1> ] }
  }
}

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source {
  0*x                 // light's position (translated below)
  color rgb 1.0       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <400, 800, -400>   // <x y z> position of light
}


#declare MyPineYellow = colour rgb <0.81, 0.7, 0.32>;
#declare MyPineOrange = colour rgb <0.5, 0.2, 0>;
#declare MyPineBrown = colour rgb <0.2, 0.085, 0>;  
   
#declare MyPine = texture 
{ 
        pigment 
        {       
                ripples  
                turbulence 0.75
                //frequency 2  
                octaves 6
                lambda 2
                omega 2   
                colour_map
                { 
                        [ 0.0 MyPineYellow ]
                        [ 1.001 MyPineOrange ]
                }                  
                scale 50
                rotate <30, 40, 20>
        }          
} 
texture
{
        pigment
        {
                bozo       
                turbulence 0.345   
                colour_map
                {
                        [ 0.0 MyPineYellow+<0, 0, 0, 0.2, 0.3> ] 
                        [ 0.67 MyPineOrange+<0, 0, 0, 0.2, 0.6> ]
                        [ 1.001 MyPineBrown+<0, 0, 0,0.2, 0.8> ]
                }
        }
}        
texture
{
        pigment
        {
                wood       
                turbulence <0.04, 0.75, 0.1>
                octaves 4
                lambda 5  
                omega 1.5
                
                colour_map
                {
                        [ 0.0   MyPineYellow+<0, 0, 0, 0.0, 0.8> ] 
                        [ 0.85  MyPineOrange+<0, 0, 0, 0.0, 0.6> ]
                        [ 1.001 MyPineBrown+ <0, 0, 0, 0.0, 0.3> ]
                }     
                scale <0.5, 2, 0.3>                 
                rotate <2, 1, 0>
        }
}        
texture
{
        pigment
        {
                wood       
                turbulence <0.04, 0.75, 0.1>
                octaves 6
                lambda 9  
                omega 1.0
                
                colour_map
                {
                        [ 0.0   MyPineYellow+<0, 0, 0, 0.0, 0.6> ] 
                        [ 0.6   MyPineYellow+<0, 0, 0, 0.0, 0.7> ] 
                        [ 0.95  MyPineOrange+<0, 0, 0, 0.0, 0.75> ]
                        [ 1.001 MyPineBrown+ <0, 0, 0, 0.0, 0.1> ]
                }     
                scale <0.625, 0.25, 0.3>                 
                rotate <1, -1.25, 0>
        }         
        normal
        {              
                average
                normal_map
                {
                        [ 1, wrinkles 0.5 turbulence 0.115 scale <1, 0.5, 5> ]
                        [ 1, ripples 0.3 turbulence 0.75 octaves 6 lambda 2 omega 2 scale 80 rotate <30, 40, 20> ]
                }
        }          
} 
 
#declare VarnishedPine = texture
{
        MyPine
}
texture 
{
        pigment { rgbf <1, 0.9, 0.8, 0.95> }
        finish 
        { 
                specular 0.25
                roughness 0.02
                ambient 0
                diffuse 0.4
                reflection 0.085
        }        
}


// Call the macro to create a chess piece - Piece(        

union
{     
                union
                {
                        Piece(1.75, 0.2, 0.05, 2.5, tPawn)  
                        scale 0.225
                        translate <-5, 0, 0>      
                }      
                
                // Other pieces
                union
                {
                        Piece(1.95, 0.2, 0.05, 3.5, tBishop)
                        scale 0.225
                        translate <-3, 0, 0>      
                }      
                union
                {
                        Piece(2.25, 0.2, 0.05, 4.75, tQueen)
                        scale 0.225
                        translate <-1, 0, 0>      
                }      
                union
                {
                        Piece(2.5, 0.2, 0.05, 5.25, tKing)   
                        scale 0.225  
                        rotate <0, 20, 0>
                        translate <1, 0, 0>      
                }      
                union
                {
                        Piece(1.8, 0.2, 0.05, 3.25, tRook)
                        scale 0.225  
                        rotate <0, 20, 0>
                        translate <3, 0, 0>
                }  
                union
                {
                        Piece(1.8, 0.2, 0.05, 2, tKnight)    
                        scale 0.225  
                        rotate <0, 20, 0>
                        translate <5, 0, 0>
                }  
                translate <0, 0, 0>
                
                texture { VarnishedPine }//T_Wood21 scale 10 }
}
                        







                    