/*  Headphones made in JPatch. Cord is bspline.
    All textures are procedural.

    You may use the headphones in any scene you want without asking.
*/

#version unofficial megapov 1.1;  //

#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "logo.inc"

camera{
  location <-1.5, 2.5 , -2.0>
  look_at <-.9,-.5,-.4>
}

//key
light_source {
  <50,200,-200>, rgb .8 //adaptive 1
  fade_power 2
  area_light
  <-50,-50,0>,<50,50,0>,5,5
  jitter
  adaptive 1
  circular
  orient
}

//fill right up
light_source {
  <0,70,-200>, rgb <0.4,0.5,0.55> //adaptive 1
  fade_power 2
  shadowless
}

//fill bottom
light_source {
  <0,-70,-100>, rgb <0.3,0.3,0.4>/1.5 //adaptive 1
  fade_power 2
  shadowless
}

//fill back right
light_source {
  <-7,-10,100>, rgb <0.3,0.3,0.3>/1.5 //adaptive 1
  fade_power 2
  shadowless
}


//spotlights
//final angle
/*light_source{
  <0,10,0>,1
  spotlight
  radius 7
  falloff 10
  point_at <.1,0,0>
}

light_source{
  <-3,10,-8>,.4
  spotlight
  radius 7
  falloff 9
  point_at <.1,0,0>
}*/


#declare useradiosity = 1;
#declare showheadphones = true;
#declare showtable = true;
#declare showcord = true;

global_settings{
  hf_gray_16 off
  max_trace_level 30
  ambient_light 0.0
  
  #if (useradiosity)
    radiosity {
      load_file "earphone.pov.rad"
      normal off
      pretrace_start 0.08
      pretrace_end   0.04
      count 20
      nearest_count 6
      error_bound 0.1
      recursion_limit 1
      low_error_factor 0.2
      gray_threshold 0.0
      minimum_reuse 0.01
      brightness .1
      adc_bailout 0.01
    }
  #end
  
}

background{Gray*1.6}

#declare earphone = union{
  #include "earphone.inc"
}

#declare cord_r = 0.017;

#if (showheadphones)
  //headphone laying on back, slightly on side.
  union{
    object{
      earphone
      scale .5
      rotate z*155
      //rotate z*205
      translate y*.08
      rotate x*.5
      translate x*.5
      rotate y*180
    }
    #if (showcord)
      sphere_sweep {
        b_spline, 8,
        <-.498,.05,-.4>, cord_r
        <-.5,.06,-.5>, cord_r
        <-.505,.04,-.9>, cord_r
        <-.42,cord_r,-1.3>, cord_r
        <-.6,cord_r,-2>, cord_r        
        <-1.75,cord_r,-3.5>, cord_r
        <20,cord_r,-3.7>, cord_r
        <10,cord_r,-5.7>, cord_r
        tolerance 1.0e-3
        texture{
          normal{spotted .7 scale .08}
          finish {
	          ambient 0.0
	          diffuse 0.75 brilliance 1.0
	          specular 0.3 roughness 0.033113107 metallic 0.0
	          conserve_energy
	          reflection {
		          0.1,0.3
		          falloff 1.0
		          metallic 0.0
	          } //reflection
          } //finish
          pigment{Black}
        } //texture
      } //sweep
    #end
  } //union
  
  
  //headphone laying on front, slightly slanted. Also cord.
  union{
    object{
      earphone
      scale .5
      rotate z*10
      translate y*.29 //bring up
      rotate x*17     //set back on ground
      rotate y*195    //rotate nearly equal with other headphone
      translate x*.25
    }

    //point of intersection of cords: <-.67,cord_r,-1.967>, cord_r*2
        
    #if (showcord)
    sphere_sweep {
      b_spline, 11,
      <.065,.08,-.54>, cord_r
      <.06,.08,-.65>, cord_r
      <-.01,.02,-1>, cord_r
      <-.2,cord_r,-1.7>, cord_r
      <-.5,cord_r,-1.9>, cord_r       //bring up and over other cord
      <-.67,cord_r*3,-1.967>, cord_r  // should use trace...but...don't know how yet.
      <-.9,cord_r,-2>, cord_r         //
      <-1.52,cord_r,-1.8>, cord_r
      <-3,cord_r,-1.1>, cord_r
      <-5,cord_r,-3.2>, cord_r
      <-10,cord_r,-10>, cord_r
      tolerance 1.0e-3
      texture{
        normal{spotted .7 scale .08}
        finish {
	        ambient 0.0
	        diffuse 0.75 brilliance 1.0
	        specular 0.3 roughness 0.033113107 metallic 0.0
	        conserve_energy
	        reflection {
		        0.1,0.3
		        falloff 1.0
		        metallic 0.0
	        } //reflection
        } //finish
        pigment{Black}
      } //texture
    } //sweep
  #end
 }
#end

//blurred reflection for table surface.
#declare NRand = seed(123);
#declare Blurred_Reflection_Samples = 20;  //more of these means smoother blur with greater render time
#declare blurredtexture = texture{
  average
  texture_map{
    #declare Sample=1;
    #while (Sample<=Blurred_Reflection_Samples)
      [ 1 pigment{ White }
      normal{
        bozo 1 scale .002 translate <rand(NRand),rand(NRand),rand(NRand)>*15
      }
      finish{diffuse .2 reflection .175}
      ]
      #declare Sample=Sample+1;
    #end
  }
}

#if (showtable)
  plane{
    y,0
    texture{ blurredtexture }
  }
#end