// This is a scene file to test out eye.inc

#include "eye.inc"

global_settings{
        max_trace_level 255
}

background{ rgb 0.5 }

camera{
        sky <0,0,1>
        location <0,4.5,-0.2>
        look_at 0
}

light_source{
        <4,4,4> color rgb 1
}

plane{
        z,-2
        pigment{
                checker rgb 0, rgb 1
        }
}

object{
        eye()
        rotate <-15,0,-30>
        translate -1.5*x
}

#declare eye_color = rgbt <0.8,0.8,0,0>;
#declare eye_cornea_size = 0.6;
#declare eye_pupil_size = 0.2;

object{
        eye()
        rotate <20,0,30>
        translate 1.5*x
}

#declare Count=0;
#declare randSeed=seed(65465);
#while(Count<100)
        #declare eye_cornea_size=0.1+(rand(randSeed)*0.7);
        #declare eye_cornea_scale=eye_cornea_size+rand(randSeed)*(1-eye_cornea_size);
        #declare eye_pupil_size=rand(randSeed);
        #declare eye_pupil_scale=rand(randSeed);
        #declare eye_color=rgbt <rand(randSeed),rand(randSeed),rand(randSeed),0>;
        #declare eye_size=1+(rand(randSeed));
        #declare xRot=90-(rand(randSeed)*180);
        #declare zRot=90-(rand(randSeed)*180);
        #declare xLoc=20-(rand(randSeed)*40);
        #declare yLoc=-1-(rand(randSeed)*40);
        #declare zLoc=-2+(rand(randSeed)*40);
        object{
                eye()
                rotate xRot*x+zRot*z
                translate xLoc*x+yLoc*y+zLoc*z
        }
        #declare Count=Count+1;
#end