// *****
// *EYE*
// *****

// by Alex Wollangk, Copyright (c) 2004
// (see end of file if you care about licensing details)

// An include file to create somewhat realistic-ish looking eyes with
// reasonable default values which may be overridden for detailed control of
// the eyes' look.

// Settings:

// **********
// *Settings*
// **********

// eye_color:         color value  any valid color
//    the color used in the color map to create the default iris texture.

// eye_cornea_scale:  float value  0 <  x <= 1.0
//    the amount to scale the cornea.
//    1.0 means the cornea is perfectly spherical
//    as the value approaches 0.0, the cornea approaches a disc
//    NOTE: large, flat corneas may cause odd artifacts

// eye_cornea_size:   float value  0 <  x <= 0.8
//    the size of the cornea wrt. the eye
//    NOTE: values beyond 0.8 create odd artifacts

// eye_iris_curve:    float value  0 <= x <= 1.0
//    the curvature of the iris.
//    0.0 creates an iris that is flush with the whites of the eye
//    1.0 creates an iris on the front of the cornea

// eye_pupil_scale:   float value  any positive value
//    the amount to scale the pupil (horizontally)
//    <1=vertically oriented oval pupil
//     1=round pupil
//    >1=horizontally oriented oval pupil
 
// eye_pupil_size:    float value  0 <= x <= 1.0
//    the size of the pupil wrt. the iris
//    1=the pupil is so big no iris shows
//    0=no pupil at all

// eye_size:          float value  any positive value
//    the size of the eye itself

// Eye Geometry Settings
// ---------------------

#ifndef(eye_cornea_size)  #declare eye_cornea_size  = 1/3; #end
#ifndef(eye_cornea_scale) #declare eye_cornea_scale = 0.5; #end
#ifndef(eye_pupil_size)   #declare eye_pupil_size   = 1/3; #end
#ifndef(eye_pupil_scale)  #declare eye_pupil_scale  = 1.0; #end
#ifndef(eye_size)         #declare eye_size         = 1.0; #end
#ifndef(eye_iris_curve)   #declare eye_iris_curve   = 0.5; #end

// Eye Textures
// ------------

#ifndef(eye_color) #declare eye_color = rgbft <0.0,0.3,0.5,0,0>; #end

// Macro to create a layered texture based on the eye_color variable
#macro layered_texture()
        #declare _layered_texture =
                texture{
                        pigment{
                                granite color_map{
                                        [0.00 rgbft <1,1,1,0,0.3>]
                                        [0.15 rgbft <1,1,1,0,0.3>]
                                        [0.50 rgbft <1,1,1,0,0.9>]
                                        [0.70 rgbft <1,1,1,1,1.0>]
                                        [1.00 rgbft <1,1,1,1,1.0>]
                                }
                                turbulence 0.6
                                ramp_wave
                                scale 0.3
                        }
                }
                texture{
                        pigment{
                                radial color_map{
                                        [0.0 rgbft <1,1,1,0.1,0.3>]
                                        [0.5 eye_color]
                                        [1.0 rgbft <1,1,1,0.1,0.3>]
                                }
                                frequency 80
                                turbulence 0.2
                        }
                }
#end // macro layered_texture()

// eye_white_texture is the texture applied to the white of the eye
#ifndef(eye_white_texture)
        #declare eye_white_texture = material{
                texture{
                        pigment{
                                color rgb <1,1,1>
                        }
                        finish{
                                ambient 0.3
                                reflection {0.0, 1}
                                specular 0.7
                                roughness 0.005
                                conserve_energy
                        }
                }
       }
#end // ifndef(eye_white_texture)

// eye_cornea_texture is the texture applied to the cornea
#ifndef(eye_cornea_texture)
        #declare eye_cornea_texture = material{
                texture{
                        pigment{
                                color rgbt 1
                        }
                        finish{
                                ambient 0.0
                                reflection {0.2, 0.5}
                                specular 0.7
                                roughness 0.005
                                conserve_energy
                        }
                }
        }
#end // ifndef(eye_cornea_texture)

// eye_back_texture is the texture applied to the back of the eye
#ifndef(eye_back_texture)
        #declare eye_back_texture = material{ texture{
                pigment{
                        color rgb 0
                }
        } }
#end // ifndef(eye_back_texture)

// ****************
// *Eye Components*
// ****************

#macro _buildComponents()

        // eye_iris_texture is the texture applied to the iris
        // must be done within the macro so that if eye_color
        // changes, the texture can be re-created
        #declare _def_eye_iris_texture = false;
        #ifndef(eye_iris_texture)
                #declare _def_eye_iris_texture = true;
                layered_texture()
                #declare eye_iris_texture = material{
                        texture{ _layered_texture }
                }
        #end // ifndef(eye_iris_texture)

        #declare corneaTranslate = sqrt(1-pow(eye_cornea_size,2));
        // This object becomes the white of the eye
        #declare eyeBody = difference{
                sphere{
                        0,1
                }
                union{
                        sphere{
                                0,eye_cornea_size
                                scale <1,eye_cornea_scale,1>
                                translate corneaTranslate*y
                        }
                        cylinder{
                                <0,corneaTranslate,0>,
                                <0,1.1,0>,
                                eye_cornea_size
                        }
                }                       
                material{ eye_white_texture }
        }
        
        // This is the cornea
        #declare eyeCornea = sphere{
                0,eye_cornea_size
                scale <1,eye_cornea_scale,1>
                translate corneaTranslate*y
                material{ eye_cornea_texture }
        }

        // This is the iris of the eye
        #declare irisScale = 1+eye_iris_curve*(eye_cornea_scale-1);
        #declare irisSize = 1+eye_iris_curve*(eye_cornea_size-1);
        #if((irisSize-eye_cornea_size)<0) #declare irisSize=eye_cornea_size; #end
        #declare eyeIris = difference{
                intersection{
                        cylinder{
                                <0,corneaTranslate-(eye_cornea_size*eye_cornea_scale),0>,
                                <0,corneaTranslate+(eye_cornea_size*eye_cornea_scale),0>,
                                eye_cornea_size
                        }
                        sphere{
                                0,irisSize
                                scale <1,irisScale,1>
                                translate (corneaTranslate-irisScale*sqrt((irisSize*irisSize)-(eye_cornea_size*eye_cornea_size)))*y
                        }
                }
                union{
                        #if(eye_pupil_size>0)
                                cylinder{
                                        <0,corneaTranslate-(eye_cornea_size*eye_cornea_scale),0>,
                                        <0,corneaTranslate+(eye_cornea_size*eye_cornea_scale),0>,
                                        eye_cornea_size*eye_pupil_size
                                        scale <eye_pupil_scale,1,1>
                                }
                        #end // if(eye_pupil_size>0)
                        sphere{
                                0,irisSize*0.99
                                scale <1,irisScale,1>
                                translate (corneaTranslate-irisScale*sqrt((irisSize*irisSize)-(eye_cornea_size*eye_cornea_size)))*y
                        }
                }
                material{ eye_iris_texture }
        }

        // If we created the default iris texture, we need to
        // undefine it so in future calls the eye color can
        // be set appropriately if 
        #if(_def_eye_iris_texture)
                #undef eye_iris_texture
        #end

        // This blocks out the back of the eye
        #declare eyeBack = disc{
                0,y,eye_cornea_size,0
                material{ eye_back_texture }
                translate corneaTranslate*y
        }
#end // macro _buildComponents()

// ****************
// *Create the Eye*
// ****************

#macro eye()
        _buildComponents()
        union{
                object{ eyeBody }
                object{ eyeCornea }
                object{ eyeIris }
                object{ eyeBack }
                scale eye_size
        }
#end // macro eye()

/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/