//*****************************************************************************************************************************
// scene environment
//*****************************************************************************************************************************
#version unofficial MegaPov 0.7;
#local quality=1;
#declare pov = <3,100,-10>;
#declare poi = <0,0,0>;

camera {
	location pov
	sky y
	right 4/3*x
	look_at poi
}

//fog { fog_type 2 distance 100 colour rgb 1 fog_alt 1 fog_offset -30 }

//light_source { 100 rgb 1 }
//light_source { -100 rgb 0.5 }

global_settings {
	max_trace_level 30
	#if (quality >=1)
		#if(quality >= 2)
	  		// High Quality - slow rendering
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=8"
		  	ini_option "Preview_End_Size=4"
		  
		  	radiosity{
			    count 80             // CHANGE range from 20 to 150
			    nearest_count 6      // CHANGE range from 3 to 10
			    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16 (or 8 for high quality)
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 4    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
		  	}
		#else
		  	// Medium Quality - works for most scenes
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=16"
		  	ini_option "Preview_End_Size=8"
		  
		  	radiosity{
			    count 40             // CHANGE range from 20 to 150
			    nearest_count 3      // CHANGE range from 3 to 10
			    error_bound 3        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 3    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
			}
		#end
	#end
}

#declare kp=<0,-1,0>;
#declare rp=vrotate(kp,z*120);
#declare gp=vrotate(rp,y*120);
#declare bp=vrotate(gp,y*120);

#macro gmesh_dif(s1,n1,def) n1+(s1-n1)*def #end

#macro gmesh(s1,s2,s3,n1,n2,n3,def,dep,col)
	#local p1=gmesh_dif(s1,n1,def);
	#local p2=gmesh_dif(s2,n2,def);
	#local p3=gmesh_dif(s3,n3,def);
	#if (dep=0)
		triangle { p1,p2,p3
			texture {
				pigment { rgb col }
				finish {
					ambient 0
					diffuse 0.45
					reflection 0.45
				}
			}
		}
	#else
		#local vl=vlength(s1);
		#local s12=vnormalize((s1+s2)/2)*vl;
		#local s23=vnormalize((s2+s3)/2)*vl;
		#local s31=vnormalize((s3+s1)/2)*vl;
		#local n12=((n1+n2)/2);
		#local n23=((n2+n3)/2);
		#local n31=((n3+n1)/2);
		#local p12=gmesh_dif(s12,n12,def);
		#local p23=gmesh_dif(s23,n23,def);
		#local p31=gmesh_dif(s31,n31,def);
		gmesh(s1,s12,s31,n1,n12,n31,def,dep-1,(col*3+0)/4)
		gmesh(s2,s23,s12,n2,n23,n12,def,dep-1,(col*3+0)/4)
		gmesh(s3,s31,s23,n3,n31,n23,def,dep-1,(col*3+0)/4)
		gmesh(s12,s23,s31,n12,n23,n31,def,dep-1,(col*3+1)/4)
	#end
#end

#macro gmesh_setup(p1,p2,p3,def,dep,col)
	#local vl=max(vlength(p1),max(vlength(p2),vlength(p3)));
	#local v1=vnormalize(p1);
	#local v2=vnormalize(p2);
	#local v3=vnormalize(p3);
	#local s1=v1*vl;
	#local s2=v2*vl;
	#local s3=v3*vl;
	gmesh(s1,s2,s3,p1,p2,p3,def,dep,col)
#end 

#macro geosphere(dep)
	gmesh_setup(kp,rp,gp,1,dep,z)
	gmesh_setup(rp,gp,bp,1,dep,1)
	gmesh_setup(gp,bp,kp,1,dep,x)
	gmesh_setup(bp,kp,rp,1,dep,y)
#end

union {
	geosphere(4)
	scale 30
}

sphere { <0,0,0> 1 scale <50,100,50> translate y*70
	hollow
	inverse
	texture {
		pigment {
			rgb 1
		}
		finish {
			ambient 0
			diffuse 0.2
			reflection 0.8
		}
	}
}

#macro gpos(p1,p2,p3,dis,col)
	glow { location vnormalize((p1+p2+p3)/3)*dis size 1 colour col type 0 }
#end

gpos(kp,rp,gp,30,z)
gpos(rp,gp,bp,30,1)
gpos(gp,bp,kp,30,x)
gpos(bp,kp,rp,30,y)