/*

LOTW ROCK TEXTURE GENERATOR

REVISION HISTORY
---------------- 
19/06/04 ISSUE A. INITIAL ISSUE

*/

// ROCK COLOUR MAKER
#macro ROCK_COLOUR ()
	#local R = (.2 + (rand(LOTW_R04) * .8));
	#local G = ((R * .5) + (rand(LOTW_R04) * R * .5));
	#local B = ((G * .5) + (rand(LOTW_R04) * G * .5));
	
	<R,G,B>;
#end

// SIGNLE ROCK TEXTURE MAKER
#macro MAKE_ROCK ()
//STEP 1. GENERATE A ROCK LIKE SEED COLOUR AND COLO_MAP 
#local Rock_Colour = ROCK_COLOUR ()                     
//STEP 2. RANDOMLY GENERATE ROCK PATTERN  
MAKE_ROCK_PATTERN(int(rand(LOTW_R04) * PROCK_QTY))
// STEP 3. MAKE TEXTURE
#local TEXTURE_A = 
texture {
	pigment{
		PIGMENT
		MAKE_CMAP (Rock_Colour,1)
	}
	MAKE_ROCK_NORMAL (int(rand(LOTW_R04) * NROCK_QTY)) 
}

#local TEXTURE_B =
texture {
	average
	texture_map {
		[1 TEXTURE_A]
		[1 TEXTURE_A scale .3]
	}
}

#declare TEXTURE_C = 
texture {
	pigment_pattern {
		spherical
		scale 300
	}
	texture_map {
		[0 TEXTURE_B]
		[1 TEXTURE_B scale .05]
	}
}
#end

//  A LAYERED SEDIMENRARY ROCK
#macro MAKE_SEDIMENTARY ()

#declare Layer_Infill =
texture {
	pigment {rgb .4}
	normal {bozo 1 scale .5}
}

#declare LROCK_TEXTURE =
texture {
	pigment_pattern {
		gradient y  
		scale .1
		warp {turbulence (.1 + (rand(LOTW_R04) * .2)) octaves 4 omega .75} 
		scale 10
		warp {turbulence (.1 + (rand(LOTW_R04) * .2))}
		scale (25 + (rand(LOTW_R04) * 25)) 
		warp {turbulence (.5 + (rand(LOTW_R04) * .5))} 
		scale 2 
		warp {turbulence (.5 + (rand(LOTW_R04) * .5))} 
	}
	texture_map {  
		#local Qty 		= (int(rand(LOTW_R04) * 10) + 3);
		#local Steps 	= (1 / (Qty - 1));        
		#local Count	= 0;  
		#local Flag1	= 0;  
		#local Start 	= 0;
		#local Remainder= 0;
		#while (Count < Qty)
			#if (Count = 0)
				MAKE_ROCK ()
				[0 TEXTURE_C]
				#local Range = (rand(LOTW_R04) * Steps * 3);
				#local Start = Range;
				[Start TEXTURE_C]
			#else
				[(Start + .01) Layer_Infill]
				MAKE_ROCK ()
				[(Start + .02) TEXTURE_C]
				#local Range = (rand(LOTW_R04) * Steps * 3);
				#local Start = (Start + Range + .02);
				#if (Start > 1) 
					#local Start = 1;
					#local Count = Qty;
				#end
				[Start TEXTURE_C]
			#end
			#local Count = (Count + 1);
		#end
	}  
	rotate <(rand(LOTW_R04) * 60),(rand(LOTW_R04) * 360),0> 
	warp {turbulence (.1 + (rand(LOTW_R04) * .3))} 
}

#end

// VOLCANIC ROCK 
#macro MAKE_VOLCANIC ()
#declare LROCK_TEXTURE =
texture {
	pigment_pattern {
		wrinkles
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}
		warp {turbulence .5}   
		scale (200 + (rand(LOTW_R04) * 200))
		warp {turbulence .5}   
	}
	texture_map {
		MAKE_ROCK ()
		[0 TEXTURE_C] 
		[.35 TEXTURE_C]
		MAKE_ROCK ()
		[.65 TEXTURE_C]
		[1 TEXTURE_C]
	}
	rotate <(rand(LOTW_R04) * 60),(rand(LOTW_R04) * 360),0> 
	warp {turbulence (.1 + (rand(LOTW_R04) * .3))}
}
#end