/*
**********************************************************************
POVWORLD LANDSCAPE GENERATOR FILE
CREATED 2003 - 2004 BY NATHAN O'BRIEN

ROCK GENERATION MACROS  

**********************************************************************
*/

// ROCK TYPE 1
// A SIMPLE BLOB ROCK
// COMPLEXITY SHOULD BE FROM 10 -20

#macro Rock1 (SIZE,COMPLEXITY,RAND)

	#declare R13_Rand 	= seed(RAND);
	#local THRESHOLD 	= .75;
	#local Rad1			= ((SIZE * 2) / THRESHOLD);
	
	blob {
		threshold THRESHOLD
		
		sphere {<0,0,0>,Rad1,1}
		
		#local Count1 = 0;
		#while (Count1 < COMPLEXITY) 
		
			#local Power = rand(R13_Rand);
			#if (Power > .5) #local Rad2 = (Rad1 * .35); #local Sign = 1; #else #local Rad2 = (Rad1 * .75); #local Sign = -1; #end
			#local P2 = <0,Rad2,0>;
			
			sphere {P2,SIZE,Sign rotate <(rand(R13_Rand) * 360),(rand(R13_Rand) * 360),(rand(R13_Rand) * 360)> }
			
			#local Count1 = (Count1 + 1);
		#end   
	}

#end   

