/* 

REVISED AND ADVANCED OBJECT DISTRIBUTION MACROS 
WILL CREATE AN "INC" FILE OF VALID <X,Y,Z> COORDINATES

COORDINATES WILL BE TESTED AGAINST THE FOLLOWING CRITERIA

1. A VALID MATCH ON FROM THE SELECTED BOOLEAN PATTERN
2. A VALID INTERSECTION WITH THE SELECTED OBJECT
3. A VALID MATCH AGAINST THE MIN AND MAX ELEVATION
4. A VALID MATCH AGAINST THE MIN AND MAX SLOPE 

*/ 

// INTERNAL DECLARES
#declare INORMAL = <0,0,0>;

// STEP ONE
// GENERATE A <X,Z> POINT VALUE WITHIN THE SAMPLE AREA
// SAMPLE AREA IS DEFINE BY THE "Camera_Angle" AND THE SAMPLE DEPTH  
// SAMPLE ARE IS SYMETRICALLY TILED. 25 TILES EACH SIDE.

#macro RANDOM_POINT ()

#local Half_Angle = (Camera_Angle / 2);  
#local Steps = (Test_Depth / 5);

#switch (int((rand(LOTW_R05) * 25) + 1)) // RANDOMLY SELECT 1 TILE OF 25
#case (1) 
	#local Test_Depth = 0;
#break 
#range (2,4)
	#local Test_Depth = 1;
#break
#range (5,9)
	#local Test_Depth = 2;
#break
#range (10,16)
	#local Test_Depth = 3; 
#break
#range (17,25)
	#local Test_Depth = 4;
#break
#end 

#local Test_Distance = ((rand(LOTW_R05) * Steps) + (Test_Depth * Steps)); 
#if (rand(LOTW_R05) <= .5) #local Test_Direction = 1; #else #local Test_Direction = -1; #end
#local Temp_Point = <0,0,Test_Distance>;

#declare Random_Point = vrotate(Temp_Point,<0,(Test_Direction * rand(LOTW_R05) * Half_Angle),0>.y);
 
#end

// STEP TWO
// CHECK THE SAMPLE POINT FOR A PATTERN MATCH 

#macro TEST_PATTERN (POINT)
	
#local fn = function {pigment {Dpattern}}
   #local COLOUR = (fn(POINT.x, POINT.y, POINT.z));
	
#if (((COLOUR.x = Control_Colour.x) & (COLOUR.y = Control_Colour.y)) & (COLOUR.z = Control_Colour.z))
	#local RESULT = true;
#else
	#local RESULT = false;
#end 
RESULT

#end

// STEP THREE
// CHECK THE SAMPLE FOR A TRUE INTERSECTION  

#macro TEST_OBJECT (POINT)

#local Test_Point 	= (POINT + <0,10000,0>);
#declare Trace_Point 	= trace(Primary_Object,Test_Point,<0,-1,0>,INORMAL); 

#if ((Trace_Point.x = 0)& (Trace_Point.y = 0) & (Trace_Point.z = 0))
	#local RESULT = false;
#else
	#local RESULT = true;
#end 
RESULT

#end 

// STEP FOUR
// TEST THE SAMPLE FOR ELEVATIONAL CONTROL 

#macro TEST_ELEVATION (POINT)

#if ((POINT.y <= Max_Elevation) & (POINT.y >= Min_Elevation))
	#local RESULT = true;
#else
	#local RESULT = false;
#end     
RESULT

#end  

// STEP FIVE
// TEST THE SAMPLE FOR SLOPE CONTROL 

#macro TEST_SLOPE (SLOPE) 

#local Unit 	= vnormalize(SLOPE);	// JUST IN CASE NON UNIT NORMAL IS PROVIDED 
#local Angle	= acos(sqrt((Unit.x * Unit.x) + (Unit.z * Unit.z)));  
#local Value	= (1 - ((Angle * 2) / pi)); 
#if ((Value <= Max_Slope) & (Value >= Min_Slope)) 
	#local RESULT = true;
#else
	#local RESULT = false;
#end  
RESULT

#end  

// PRIMARY MACRO

#macro MAKE_POINTS_FILE ()

#fopen TEMPFILE Output_File_Name write 

#local Count = 0;
#while (Count < Max_True_Samples)

	RANDOM_POINT ()
	#if (TEST_PATTERN (Random_Point))
		#if (TEST_OBJECT (Random_Point))
			#if (TEST_ELEVATION (Trace_Point))
				#if (TEST_SLOPE (INORMAL))
				    
				    #write (TEMPFILE Trace_Point)
				    #write (TEMPFILE ",\n")
				    
				    #if (Record_Normals = on)
				    
				    #write (TEMPFILE INORMAL)
				    #write (TEMPFILE ",\n")
				    
				    #end
				    
					#local Count = (Count + 1);
					
				#end
			#end
		#end
	#end

#end  

#fclose TEMPFILE

#end       

// DISTRIBUTION MACROS

// DISTRIBUTING ROCKS
#macro DISTRIBUTE_ROCKS (MIN,RANGE,TEXTURE)
	#fopen TEMPFILE Output_File_Name read
	#while (defined(TEMPFILE))
		#read (TEMPFILE Point)
		#local Rscale = ((rand(LOTW_R05) * RANGE) + MIN);
		object {Rock1 (Rscale,int(rand(LOTW_R05) * 40),int(rand(LOTW_R05) * 1000)) translate Point texture {TEXTURE}}
	#end
#end