/*

LOTW PATTERNS 
VARIOUS PATTERN DEFINITIONS TO BE USED BY THE VARIOUS TEXTURE PACKS

REVISION HISTORY
---------------- 
11/06/04 ISSUE A. INITIAL ISSUE

*/

#declare PROCK_QTY = 5;

#macro MAKE_ROCK_PATTERN (PATTERN)
#switch (PATTERN)
#case (0) //  HORIZONTAL PATTERN
#declare PIGMENT 	= 
pigment {
	granite
	scale <10,1,10>  
	warp {turbulence .1 octaves 4 omega .75}
	scale 50
	scale .5
}
#break
#case (1) // A BLOTCHY PATTERN
#declare PIGMENT =
pigment {
	granite
	warp {turbulence .5}
	scale 10
	warp {turbulence .5}
	scale 20
	scale .5
}
#break
#case (2) // A PATCHY PATTERN
#declare PIGMENT =
pigment {
	bozo
	warp {turbulence .5}
	scale 5
	warp {turbulence .5}
	scale 10 
	scale .5
} 
#break
#case (3) // A MARBLE PATTERN
#declare PIGMENT =
pigment {
	dents
	warp {turbulence .5}
	scale 5
	warp {turbulence .5}
	scale 10 
	scale .5
}
#break
#case (4) // A SPOTTY PATTERN
#declare PIGMENT =
pigment {
	crackle form <1,0,0>
	warp {turbulence .5}
	scale 5
	warp {turbulence .7}
	scale 10 
	scale .5
}
#break
#end
#end
