/*

LOTW GENERAL MACROS

REVISION HISTORY
---------------- 
21/05/04 ISSUE A. INITIAL ISSUE

*/
// SPECIFIC PATTERN DECLARES
#declare rmf = pigment {function {f_ridged_mf(x,y,z, 1,2,5,.75,5,5)}}

// VALID PATTERNS
#declare LF_ARRAY = array[12]
	{"bozo","wrinkles","granite","crackle","crackle form <1,0,0>","agate","waves","rmf","crackle form <0,1,0>","crackle form <.5,1,0>","crackle form <-1,.5,1>","crackle form <-1,0,1>"}

#declare LS_ARRAY = array[12]
	{"1","1.5","15","2","2","5",".25","5","2","2","2","2"}

// UNIVERSAL PATTERN ROUTINE
#macro Set_Pattern ()

#local DEPTH = dimension_size(LF_ARRAY,1); 
#local DATAP = int(rand(LOTW_R01) * DEPTH);
#local PTYPE = LF_ARRAY[DATAP]; 
#local STYPE = LS_ARRAY[DATAP];

#fopen Temp_File "temp_data.inc" write
#write (Temp_File,concat("#declare RANDOM_PIGMENT = pigment {",PTYPE,"}")) 
#write (Temp_File,concat("#declare SCALE_FACTOR = ",STYPE,";"))
#fclose Temp_File

#include "temp_data.inc"

#end   

// UNIVERSAL CLOUD PATTERN ROUTINE
#macro Set_Cloud_Pattern ()

#if (Force_Earth = on)
	#local CSET = array[4] {0,1,2,7}
#else 
	#local CSET = array[9] {0,1,2,4,7,8,9,10,11}
#end

#local DEPTH = dimension_size(CSET,1); 
#local DATAP = CSET[int(rand(LOTW_R01) * DEPTH)];
#local PTYPE = LF_ARRAY[DATAP]; 
#local STYPE = LS_ARRAY[DATAP];

#fopen Temp_File "temp_data.inc" write
#write (Temp_File,concat("#declare RANDOM_PIGMENT = pigment {",PTYPE,"}")) 
#write (Temp_File,concat("#declare SCALE_FACTOR = ",STYPE,";"))
#fclose Temp_File

#include "temp_data.inc"

#end 

// WAVE SELECTION
#macro SET_WAVE ()

#switch (int(rand(LOTW_R01) * 2.99))
		#case (1)
			cubic_wave
		#break
		#case (2)
			poly_wave ((rand(LOTW_R01) * 4) + .5)
		#break
	#end
#end  



