/*

LOTW HEIGHT FIELD PATTERN

REVISION HISTORY
---------------- 
21/05/04 ISSUE A. INITIAL ISSUE

*/
// SUB PATTERN
#macro make_sub_pattern (START,END,SCALE)
#declare SUB_PATTERN =
pigment {
	RANDOM_PIGMENT
	color_map {
		[0 rgb START]
		[1 rgb END]
	}   
	warp {turbulence rand(LOTW_R01) octaves 2 lambda 1.25 omega .25}
	SET_WAVE ()
	scale (SCALE * SCALE_FACTOR)
}	
#end

// BASE PATTERN
#macro BASE_PATTERN ()

// SETTING THE BASE PATTERN
Set_Pattern ()

// BUILDING THE BASE PATTERN
#declare WORLD_PATTERN =
pigment {  
	pigment_pattern {
		RANDOM_PIGMENT  
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}  
		warp {turbulence rand(LOTW_R01) octaves 2 lambda 1.25 omega .25}
		SET_WAVE () 
		translate (rand(LOTW_R01) * 1000000)
		scale ((.5 + (2.5 * rand(LOTW_R01))) * SCALE_FACTOR)
	}
	pigment_map { 
	
		// SETTING THE BASE PATTERN
		Set_Pattern ()
		
		// 3 OPTIONS FOR OVERSCALING
		// A. UNIFORM OVERSCALE
		// B. ASCENDING OVERSCALE
		// C. DESCENDING OVERSCALE 
		// D. RANDOM LAYERED OVERSCALE WITH DIFFERENT APTTERN LAYERS
		
		#declare OS_TYPE = int(rand(LOTW_R01) * 4);
		
		// UNIFORM  
		#if (OS_TYPE = 0)
		    #local OVERSCALE = ((rand(LOTW_R01) * .05) + .01);
		    #local PSCALE = ((rand(LOTW_R01) *(OVERSCALE * 1.6)) + .01);
		#end
	
		#local COUNT = 0;  
		#local START = 0;
		
		#while (COUNT < 21)
		     
		    #if (OS_TYPE > 0)
		    	#if (OS_TYPE = 1) 
		    		// BIG TO SMALL
		    		#local OVERSCALE = (.06 - (COUNT * .0025));
		    		#local PSCALE	 = (.1 - (COUNT * .0045)); 
		    	#end
		    	#if (OS_TYPE = 2)
		    		// SMALL TO BIG 
		    		#local OVERSCALE = (.01 + (COUNT * .0025));
		    		#local PSCALE	 = (.01 + (COUNT * .0045)); 
		      	#end
		      	#if (OS_TYPE = 3)
		    		// NON UNIFORM LAYERS  
		    		Set_Pattern ()
		    		#local OVERSCALE = ((rand(LOTW_R01) * .05) + .01);
		    		#local PSCALE = ((rand(LOTW_R01) *(OVERSCALE * 1.6)) + .005);
		    	#end
		    #end
		    
			#local POSITION = (COUNT * .05);
			#local END = (START + OVERSCALE);
			
			make_sub_pattern (START,END,PSCALE)
			[POSITION SUB_PATTERN]
		
			#local COUNT = (COUNT + 1); 
			#local START = (START + .05);
		#end
	}
}

#end 

// SETTING THE BASE PATTERN
Set_Pattern ()

#declare NEW_WORLD =
pigment {
	pigment_pattern {
		RANDOM_PIGMENT  
		color_map {
			[0 rgb 0] 
			[.3 rgb 0]
			[.6 rgb 1]
			[1 rgb 1]
		}  
		warp {turbulence rand(LOTW_R01) octaves 2 lambda 1.25 omega .25}
		SET_WAVE () 
		translate (rand(LOTW_R01) * 1000000)
		scale ((1 + (3 * rand(LOTW_R01))) * SCALE_FACTOR)
	}
	pigment_map { 
		BASE_PATTERN ()
		[0 WORLD_PATTERN]
		BASE_PATTERN ()
		[1 WORLD_PATTERN]
	}
}