/*

LOTW HEIGHT FIELD PATTERN

REVISION HISTORY
---------------- 
06/06/04 ISSUE A. INITIAL ISSUE

CLOUD SPHERE GENERATOR FILE

BASED UPON ORIGINAL TEXTURE CODE FROM
fake_elevation2.pov
April 2004 Samuel Benge

MODIFIED TO FLIP THE TEXTURE TO BE SEEN FROM BELOW AND WORK WITH OTHER
WORLD MODEL FILES AND CHOICE OF PATTERN

**********************************************************************
*/    

// GLOBAL CALCULATIONS  
#macro SET_CLOUD ()
#local Cloud_Sphere = sphere{<0,-640000,0>,642000} 

#local Glow_Vector 	= <0,0,175000>;
#local Glow_Vector 	= vaxis_rotate(Glow_Vector,<1,0,0>,- Sun_Altitude);
#local Glow_Vector 	= vaxis_rotate(Glow_Vector,<0,1,0>,Sun_Azimuth);
#local Glow_Point	= trace(Cloud_Sphere,<0,0,0>,vnormalize(Glow_Vector));

#declare Sun_Vector	= vnormalize(Glow_Point - <0,-640000,0>); 
#declare Glow_Factor = (.03 / sqrt(Sun_Altitude)); 

#declare Glow_Colour1 = (((Glare_Colour * 2) + Decay_Red) / 3);
#declare Glow_Colour2 = (((Light_Colour * 2) + Sun_Colour) / 3); 

#if (Sun_Altitude > 75)
	#declare Ratio_Factor = 75;
#else
	#declare Ratio_Factor = Sun_Altitude;
#end

#declare Glow_Ratio = ((76 - Ratio_Factor) / 75);

#declare Base_Cloud_Colour1 = ((Glow_Ratio * Glow_Colour1) + ((1 - Glow_Ratio) * Glow_Colour2));
#declare Base_Cloud_Colour2 = ((1 - Glow_Ratio) * Glow_Colour2);

#end

// GRADIENT PIGMENT MACRO
#macro Make_Sun_Glow (COLOUR1,COLOUR2) 

#declare Sun_Glow_Pigment = 
pigment {
	slope Sun_Vector                                                
	color_map {
		[0.0			rgb COLOUR1] 
		[Glow_Factor	rgb COLOUR2]         
		[1.0			rgb COLOUR2]
	} 
} 

#declare Sun_Glow_Pigment2 = 
pigment {
	slope Sun_Vector                                                
	color_map {
		[0.0			rgbt <COLOUR1.x,COLOUR1.y,COLOUR1.z,.8>] 
		[Glow_Factor	rgbt <COLOUR2.x,COLOUR2.y,COLOUR2.z,.8>]        
		[1.0			rgbt <COLOUR2.x,COLOUR2.y,COLOUR2.z,.8>]
	} 
}

#end 

// THE SKY SPHERE  

#macro CLOUDS_LOW ()

SET_CLOUD ()
Set_Cloud_Pattern ()              

#declare Cloud_Tex1=
pigment{  
	RANDOM_PIGMENT  
	translate Sky_Translate
	#if (Cloud_Warp > 0) 
		warp {turbulence Cloud_Warp octaves 8 lambda 1.25 omega .25}
	#end
	scale (Sky_Scale * SCALE_FACTOR)  
	rotate (y * Sky_Rotate)
} 

sphere {<0,-640000,0>,(640000 + Cloud_Height) 

#local Value = 1;
#while (Value >= 0)
	texture{ 
		#if (Value > Rim_Depth)
			Make_Sun_Glow ((Base_Cloud_Colour1 * 1.5),(Base_Cloud_Colour2 * 1.5)) 
			pigment{Cloud_Tex1
				pigment_map{   
					[0 rgbt <1,1,1,1>]  
					[(Value + Sky_Clear) rgbt <1,1,1,1>]
					[(Value + Sky_Clear + Rim_Sharpness) Sun_Glow_Pigment]
				}
				#if (Cloud_Warp > 0) 
					warp {turbulence Cloud_Warp}
				#end
			} 
		#else     
			Make_Sun_Glow (Base_Cloud_Colour1,Base_Cloud_Colour2) 
			pigment{Cloud_Tex1
				pigment_map{   
					[0 rgbt <1,1,1,1>]
					[(Value + Sky_Clear) rgbt<1,1,1,1>]
					[(Value + Sky_Clear + Rim_Sharpness) Sun_Glow_Pigment]
				}
				#if (Cloud_Warp > 0) 
					warp {turbulence Cloud_Warp}
				#end
			}
		#end
		finish{
			ambient Cloud_Ambient
			diffuse 1
			brilliance 2
		}
		normal{
			pigment_pattern{Cloud_Tex1} (120 - ((1 - Value) * 100))   //-
			accuracy 5
		}
		scale <(1 - (Value / 1.5)),1,(1 - (Value / 1.5))>
		translate (y * Value * 5)   
		translate (z * -60)
	}
#local Value = (Value - (1 / Texture_Depth));
#end

hollow
} 

#end

#macro CLOUDS_HIGH ()

SET_CLOUD ()
Set_Cloud_Pattern ()              

#declare Cloud_Tex1=
pigment{ 
	RANDOM_PIGMENT  
	translate Sky_Translate
	#if (Cloud_Warp > 0) 
		warp {turbulence Cloud_Warp octaves 10 lambda 3 omega .75}
	#end
	scale Sky_Scale  
	rotate (y * Sky_Rotate)
} 

sphere {<0,-640000,0>,(640000 + Cloud_Height) 

#local Value = 1;
#while (Value >= 0)
	texture{ 
		#if (Value > Rim_Depth)
			Make_Sun_Glow ((Base_Cloud_Colour1 * 1.5),(Base_Cloud_Colour2 * 1.5)) 
			pigment{Cloud_Tex1
				pigment_map{   
					[0 rgbt <1,1,1,1>]  
					[(Value + Sky_Clear) rgbt <1,1,1,1>]
					[(Value + Sky_Clear + Rim_Sharpness) Sun_Glow_Pigment2]
				}
				#if (Cloud_Warp > 0) 
					warp {turbulence Cloud_Warp octaves 10 lambda 3 omega .75}
				#end
			} 
		#else     
			Make_Sun_Glow (Base_Cloud_Colour1,Base_Cloud_Colour2) 
			pigment{Cloud_Tex1
				pigment_map{   
					[0 rgbt <1,1,1,1>]
					[(Value + Sky_Clear) rgbt<1,1,1,1>]
					[(Value + Sky_Clear + Rim_Sharpness) Sun_Glow_Pigment2]
				}
				#if (Cloud_Warp > 0) 
					warp {turbulence Cloud_Warp}
				#end
			}
		#end
		finish{
			ambient Cloud_Ambient
			diffuse 1
			brilliance 2
		}
		normal{
			pigment_pattern{Cloud_Tex1} (120 - ((1 - Value) * 100))   //-
			accuracy 5
		}
		scale <(1 - (Value / 10)),1,(1 - (Value / 10))>
		translate (y * Value * .01)   
		translate (z * -1)
	}
#local Value = (Value - (1 / Texture_Depth));
#end

hollow 
no_shadow
} 

#end



