/*
**********************************************************************
POVWORLD LANDSCAPE GENERATOR FILE
CREATED 2003 - 2004 BY NATHAN O'BRIEN

TREE GENERATION MACROS  

**********************************************************************
*/

// TREE TYPE 1
// TREE MODEL BY Gilles Tran http://www.oyonale.com
#macro GT_TREE()
    // creates a media-filled sphere that looks like a tree 
    #local SC = (rand(LOTW_R05) + 1);
    #if (rand(LOTW_R05)<0.2) // yellowish
        #local C_Media=<28+rand(LOTW_R05)*30,44+rand(LOTW_R05)*10,42>/255;
    #else // blueish
        #local C_Media=<28+rand(LOTW_R05)*10,53+rand(LOTW_R05)*10,49>/255;
    #end
    sphere{0,2 
        texture{pigment{rgbt<1,1,1,1>}}
        hollow
        interior{
            media{
                scattering {1,C_Media*(0.3+rand(LOTW_R05)*0.3)}
                absorption (1-C_Media*(0.1+rand(LOTW_R05)*0.4))
                samples 1,1
                density{
                    spherical
                    turbulence 0.5+rand(LOTW_R05)
                    lambda 2.5+rand(LOTW_R05)
                    rotate y*360*rand(LOTW_R05)
                    translate y*rand(LOTW_R05)*0.5
                    
                }
            }
        }
        translate y*0.6 scale 2+rand(LOTW_R05)*7 scale 1*<SC,0.5+rand(LOTW_R05)*2,SC>
        scale .4
    }            
#end