// LOTW TEXTURE PACK
// RANDOM VOLCANIC MOUNTAINS WITH SMALL PLOT FARMLAND ON FLATTER AREAS

// TEXTURE DEFINITIONS  

#macro Make_Grass ()  

	#local G = (.2 + (rand(LOTW_R04) * .8));
	#local R = ((G * .75) + (rand(LOTW_R04) * G * .25));
	#local B = ((R * .5) + (rand(LOTW_R04) * R * .5));
	
	#local Grass_Colour = <R,G,B>;
	
	MAKE_ROCK_PATTERN(int(rand(LOTW_R04) * PROCK_QTY)) 
	
	#declare Grass_Texture =
	texture {
		pigment {
			PIGMENT
			MAKE_CMAP (Grass_Colour,1)   
			scale 10
		}  
		MAKE_GRASS_NORMAL (int(rand(LOTW_R04) * NGRASS_QTY)) 
	}

#end

#declare High_Slope =
texture {
	slope {-y,0,.5}
	texture_map {  
		Make_Grass ()
		MAKE_VOLCANIC ()
		[0 Grass_Texture] 
		[.3 Grass_Texture] 
		[.4 LROCK_TEXTURE]
		[1 LROCK_TEXTURE]
	}
}

#declare Farm_Translate = (rand(LOTW_R04) * 50000);

#declare Farmland =
texture {
	pigment_pattern {
		crackle 
		solid 
		metric 1.5
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}                   
		translate Farm_Translate
		scale <75,100000,75> 
	}
	texture_map {
		Make_Grass ()
		[0 Grass_Texture]
		Make_Grass ()
		[.2 Grass_Texture]  
		Make_Grass ()
		[.4 Grass_Texture]
		Make_Grass ()
		[.6 Grass_Texture] 
		Make_Grass ()
		[.8 Grass_Texture]
		Make_Grass ()
		[1 Grass_Texture]
	}
}

#declare Mid_Slope =
texture {
	slope {-y,0,.5}
	texture_map {  
		Make_Grass ()
		MAKE_VOLCANIC ()
		[0 Farmland]
		[.4 Farmland] 
		[.5 Grass_Texture] 
		[.6 LROCK_TEXTURE]
		[1 LROCK_TEXTURE]
	}
}

#declare Landform_Texture =
texture {
	pigment_pattern {
		gradient y
		scale Tile_Height
	}
	texture_map {
		[0 Mid_Slope]
		[.6 Mid_Slope]
		[.7 High_Slope]
		[1 High_Slope]
	}
}

// BOULDER DISTRIBUTION
// FILE CONTROL  
#declare Output_File_Name	= "rocks.dat";  

// TESTING CONTROL
#declare Primary_Object		= object{HF_WORLD}	// = THE PRIMARY OBJECT THAT THE POINTS ARE TO BE DISTRIBUTED ON   

#declare Test_Depth			= 3000;				// = DISTANCE FROM ORIGIN OF THE POINTS DISTRIBUTION FIELD
#declare Max_True_Samples	= 20000;			// TOTAL NUMBER OF TRUE SAMPLES RECORDED TO FILE
#declare Record_Normals		= off;				// RECORD THE SURFCAE NORMAL WITH THE FILES AS WELL

// ELEVATION CONTROL
#declare Max_Elevation	= 1000;
#declare Min_Elevation	= 0; 

// SLOPE
#declare Max_Slope		= .4;		// = 1 IS THE MAXIMUM POSSIBLE SLOPE
#declare Min_Slope		= 0;		// = 0 IS THE MINIMUM POSSIBLE SLOPE 

// PATTERN
#declare Control_Colour	= <0,0,0>;	// = THIS COLOUR PRODUCES A TRUE TEST RESULT  

// USER DECLARED PATTERN
#declare Dpattern = 
// MUST USE THIS NAME
pigment {
	crackle
	metric 1.5
	color_map {
		[0.0 rgb 0]
		[0.015 rgb 0]
		[0.015 rgb 1]
		[1.0 rgb 1]
	}
	translate Farm_Translate
	scale <75,100000,75>
} 

// CALL THE POINT CREATION MACRO 
// ASSUMED IT ALREADY EXISTS ONCE 2 PASS RADIOSITY IS INITIATED
#if ((Scene_Detail != 5)&(Scene_Detail != 1))
	#if (Scene_Detail < 7)
		MAKE_POINTS_FILE ()
	#end 
	DISTRIBUTE_ROCKS (1,2.5,LROCK_TEXTURE)  
#end

// TREE DISTRIBUTION
// FILE CONTROL  
#declare Output_File_Name	= "trees.dat";  

// TESTING CONTROL
#declare Primary_Object		= object{HF_WORLD}	// = THE PRIMARY OBJECT THAT THE POINTS ARE TO BE DISTRIBUTED ON   

#declare Test_Depth			= 3000;				// = DISTANCE FROM ORIGIN OF THE POINTS DISTRIBUTION FIELD
#declare Max_True_Samples	= 10000;			// TOTAL NUMBER OF TRUE SAMPLES RECORDED TO FILE
#declare Record_Normals		= off;				// RECORD THE SURFCAE NORMAL WITH THE FILES AS WELL

// ELEVATION CONTROL
#declare Max_Elevation	= (Tile_Height * .7);
#declare Min_Elevation	= 0; 

// SLOPE
#declare Max_Slope		= .4;		// = 1 IS THE MAXIMUM POSSIBLE SLOPE
#declare Min_Slope		= 0;		// = 0 IS THE MINIMUM POSSIBLE SLOPE 

// PATTERN
#declare Control_Colour	= <0,0,0>;	// = THIS COLOUR PRODUCES A TRUE TEST RESULT  

// USER DECLARED PATTERN
#declare Dpattern = 
// MUST USE THIS NAME
pigment {
	crackle
	metric 1.5
	color_map {
		[0.0 rgb 1]
		[0.015 rgb 1]
		[0.015 rgb 0]
		[0.03 rgb 0]
		[0.03 rgb 1]
		[1.0 rgb 1]
	}        
	translate Farm_Translate
	scale <75,100000,75>
} 

// CALL THE POINT CREATION MACRO 
// ASSUMED IT ALREADY EXISTS ONCE 2 PASS RADIOSITY IS INITIATED
#if ((Scene_Detail != 5)&(Scene_Detail != 1))
	#if (Scene_Detail < 7)
		MAKE_POINTS_FILE ()
	#end 
	DISTRIBUTE_TREES ()  
#end
 