// LOTW TEXTURE PACK
// ROCKY SEDIMENTARY OUTCROPPINGS WITH SAND AND SCATTERED BOULDERS

// TEXTURE DEFINITIONS

MAKE_SEDIMENTARY ()

#declare Sand1 = 
texture{
	pigment{ 
		wrinkles
		MAKE_CMAP (<.9,.85,.5>,1)
		warp {turbulence .5}
		scale 20
	}
	normal {ripples .5 scale 2 turbulence .5}
}
    
#declare Sand2 = 
texture{
	pigment{ 
		wrinkles
		MAKE_CMAP (<.8,.55,.3>,1)
		warp {turbulence .5}
		scale 20
	} 
	normal {bumps .5 scale 1 turbulence .25}
}

#declare Slope_Sand =
texture {
	slope {-y,0,.3}
	texture_map {
		[0 Sand1]   
		[.3 Sand1] 
		[.6 Sand2] 
		[1 Sand2]
	}
}

#declare Mix_Sand_Rock =
texture {  
	pigment_pattern {
		granite  
		warp {turbulence .5}
		scale 50
		warp {turbulence .5}
	}
	texture_map {
		[0 Slope_Sand]
		[.4 Slope_Sand]
		[.6 LROCK_TEXTURE]
		[1 LROCK_TEXTURE]
	}
}

#declare Landform_Texture =
texture {
	slope {-y,0,.5}
	texture_map {
		[0 Slope_Sand]
		[.45 Slope_Sand]
		[.5 Mix_Sand_Rock]
		[.55 LROCK_TEXTURE]
		[1 LROCK_TEXTURE]
	}
	warp {turbulence .5}
}

// BOULDER DISTRIBUTION
// FILE CONTROL  
#declare Output_File_Name	= "rocks.dat";  

// TESTING CONTROL
#declare Primary_Object		= object{HF_WORLD}	// = THE PRIMARY OBJECT THAT THE POINTS ARE TO BE DISTRIBUTED ON   

#declare Test_Depth			= 4000;				// = DISTANCE FROM ORIGIN OF THE POINTS DISTRIBUTION FIELD
#declare Max_True_Samples	= 20000;			// TOTAL NUMBER OF TRUE SAMPLES RECORDED TO FILE
#declare Record_Normals		= off;				// RECORD THE SURFCAE NORMAL WITH THE FILES AS WELL

// ELEVATION CONTROL
#declare Max_Elevation	= 1000;
#declare Min_Elevation	= 0; 

// SLOPE
#declare Max_Slope		= .5;		// = 1 IS THE MAXIMUM POSSIBLE SLOPE
#declare Min_Slope		= 0;		// = 0 IS THE MINIMUM POSSIBLE SLOPE 

// PATTERN
#declare Control_Colour	= <0,0,0>;	// = THIS COLOUR PRODUCES A TRUE TEST RESULT  

// USER DECLARED PATTERN
#declare Dpattern = 
// MUST USE THIS NAME
pigment {
	bozo
	color_map {
		[0.0 rgb 0]
		[0.5 rgb 0]
		[0.5 rgb 1]
		[1.0 rgb 1]
	}
	scale 50
} 

// CALL THE POINT CREATION MACRO 
#if ((Scene_Detail != 5)&(Scene_Detail != 1))
	#if (Scene_Detail < 7)
		MAKE_POINTS_FILE ()
	#end 
	DISTRIBUTE_ROCKS (1,4,LROCK_TEXTURE)
#end