/*

LOTW NORMALS 
VARIOUS NORMAL DEFINITIONS TO BE USED BY THE VARIOUS TEXTURE PACKS

REVISION HISTORY
---------------- 
11/06/04 ISSUE A. INITIAL ISSUE

*/ 

#declare NROCK_QTY = 5;

#macro MAKE_ROCK_NORMAL (NORMAL)
#switch (NORMAL) 
#case (0) // HORIZONTAL SHALE
normal {
	granite 1 
	scale <8,1,8>  
	turbulence <.1,.2,.1> octaves 4 omega .75
	scale 25 
	scale .5
} 
#break
#case (1) // GRANITE
normal {
	granite 1 
	scale 100 
	scale .5
} 
#break
#case (2) // WIDE HORIZONTAL
normal {
	agate 1 
	scale <250,70,250> 
	scale .5
} 
#break
#case (3) // BLOBBY HORIZONTAL
normal {
	bozo 2
	turbulence <.05,.1,.05> octaves 4 omega .75
	scale <10,2,10> 
	scale .5
}
#break
#case (4) // BIG ROCK FACE
normal {
	wrinkles 2
	scale 50 
	scale .5
}
#break
#end
#end

#declare NGRASS_QTY = 5;

#macro MAKE_GRASS_NORMAL (NORMAL)
#switch (NORMAL) 
#case (0) 
normal {
	granite 1 
	scale <8,1,8>  
	turbulence <.1,.2,.1> octaves 4 omega .75
	scale 25 
	scale .25
} 
#break
#case (1) 
normal {function {f_ridged_mf(x,y,z, 1,2,5,.75,5,5)} .5 scale 5}
#break
#case (2) 
normal {
	dents 1 
	scale <250,70,250> 
	scale .25
} 
#break
#case (3) 
normal {
	bozo 1
	turbulence <.05,.1,.05> octaves 4 omega .75
	scale <10,2,10> 
	scale .25
}
#break
#case (4) // BIG ROCK FACE
normal {
	wrinkles 1
	scale 20 
	scale .25
}
#break
#end
#end

