/*

LOTW PRIMARY ENGINE

*/

// SCENE CONTROLS FOR LEVEL OF DETAIL
#switch (Scene_Detail)
#case (1)
	#declare Detail_Steps 		= 50;		// = MAXIMUM HEIGHT FIELD DETAIL
	#declare Render_Clouds 		= off; 
	#declare Render_Atmosphere 	= off;
	#declare Render_Ocean		= off;
	#declare Radiosity_Pass 	= off; 
	#declare No_Texture			= off;
#break
#case (2)
	#declare Detail_Steps 		= 200;		// = MAXIMUM HEIGHT FIELD DETAIL
	#declare Render_Clouds 		= off; 
	#declare Render_Atmosphere 	= off;
	#declare Render_Ocean		= off;
	#declare Radiosity_Pass 	= off; 
	#declare No_Texture			= off;
#break
#case (3)
	#declare Detail_Steps 		= 200;		// = MAXIMUM HEIGHT FIELD DETAIL
	#declare Render_Clouds 		= off; 
	#declare Render_Atmosphere 	= off;
	#declare Render_Ocean		= on;
	#declare Radiosity_Pass 	= off; 
	#declare No_Texture			= off;
#break
#case (4)
	#declare Detail_Steps 		= 500;		// = MAXIMUM HEIGHT FIELD DETAIL
	#declare Render_Clouds 		= on; 
	#declare Render_Atmosphere 	= on;
	#declare Render_Ocean		= on;
	#declare Radiosity_Pass 	= off; 
	#declare No_Texture			= off;
#break
#case (5)
	#declare Detail_Steps 		= 50;		// = MAXIMUM HEIGHT FIELD DETAIL
	#declare Render_Clouds 		= on; 
	#declare Render_Atmosphere 	= on;
	#declare Render_Ocean		= off;
	#declare Radiosity_Pass 	= off; 
	#declare No_Texture			= on;
#break
#case (6)
	#declare Detail_Steps 		= 500;		// = MAXIMUM HEIGHT FIELD DETAIL
	#declare Render_Clouds 		= off; 
	#declare Render_Atmosphere 	= off;
	#declare Render_Ocean		= on;
	#declare Radiosity_Pass 	= 1; 
	#declare No_Texture			= off;
#break
#case (7)
	#declare Detail_Steps 		= 600;		// = MAXIMUM HEIGHT FIELD DETAIL
	#declare Render_Clouds 		= on; 
	#declare Render_Atmosphere 	= on;
	#declare Render_Ocean		= on;
	#declare Radiosity_Pass 	= 2; 
	#declare No_Texture			= off;
#break
#end

// AUTOMATIC STUFF 
// THERE IS NO NEED TO EDIT ANY OF THE CODE BELOW TO GENERATE A LANDSCAPE

#ifndef (LOTW_R01)
	#declare R01		= int(rand(LOTW_RAND) * 1000000);
	#declare LOTW_R01 	= seed(R01); // SEED01 IS USED TO CONTROL THE LANDFORM PATTERN
#end 
#ifndef (LOTW_R02) 
	#declare R02		= int(rand(LOTW_RAND) * 1000000);		
	#declare LOTW_R02 	= seed(R02); // SEED02 IS USED TO CONTROL THE ATMOSPHERE
#end
#ifndef (LOTW_R03)       
	#declare R03		= int(rand(LOTW_RAND) * 1000000);
	#declare LOTW_R03 	= seed(R03); // SEED03 IS USED TO CONTROL THE CLOUDS
#end  
#ifndef (LOTW_R04) 
	#declare R04		= int(rand(LOTW_RAND) * 1000000);
	#declare LOTW_R04 	= seed(R04); // SEED04 IS USED TO CONTROL THE LANDSCAPE TEXTURE (+ WATER LEVEL)
#end 
#ifndef (LOTW_R05) 
	#declare R05		= int(rand(LOTW_RAND) * 1000000);
	#declare LOTW_R05 	= seed(R05); // SEED05 IS USED FOR OBJECT DISTRIBUTION
#end  

// LOTW DECLARES
// CAMERA CONTROL 
#declare Camera_Angle		= 70;	// = VIEW ANGLE 

// TILED HEIGHTFIELD CONTROL 
#declare Tile_Size			= 500; 	// = SIZE OF EACH INDIVIDUAL TILE
#declare Tile_Depth			= 20;  	// = DEPTH OF TILE ARRAY
#declare Tile_Detail_Min	= 50;	// = MIMIMUM TILE DETAIL
#declare Detail_Falloff		= 2;    // = RATE OF DECAY IN THE LEVEL OF HF DETAIL 

// LOTW INCLUDES 
#include "functions.inc"			// STANDARD POV INCLUDE        
#include "lotw_macros.inc"			// GENERAL MACROS USED BY SEVERAL FILES
#include "lotw_hftile.inc"			// HEIGHT FIELD TILING MACRO 
#include "lotw_hfp.inc"  			// HEIGHTFIELD PATTERN
#include "lotw_atmos.inc"			// ATMOSPHERIC CONTROLS 
#include "lotw_clouds.inc"			// CLOUD CONTROL    
#include "lotw_cmaps.inc"  			// MAKES RANDOMLY GENERATED COLOR_MAPS
#include "lotw_patterns.inc"		// VARIOUS PATTERNS
#include "lotw_normals.inc"			// VARIOUS NORMALS
#include "lotw_trocks.inc" 			// ADVANCED ROCK TEXTURES
#include "lotw_place.inc"			// OBJECT DISTRIBUTION MACROS
#include "lotw_rocks.inc"			// BLOB ROCK CREATION MACRO 
#include "lotw_trees.inc"

// THE SUN
#declare Sun_Altitude		= (5 + (rand(LOTW_R02) * 35)); 
#declare Sun_Azimuth		= (rand(LOTW_R02) * 360);

// BUILD THE LAND FORM
//#declare NEW_WORLD = pigment {bozo color_map {[0 rgb 0][1 rgb 1]}} // UNCOMMENT FOR TESTING
#declare Tile_Height 	= ((rand(LOTW_R01) * 400) + 400); 

Make_HFSurface (NEW_WORLD) 

// SET SOME TEXTURE CONTROLS  
#local CLEVEL = trace(CAM_ORIGIN,<0,(Tile_Height * 2),0>,<0,-1,0>).y;
#declare Water_Level 	= (rand (LOTW_R04) * (CLEVEL - 1));
#declare Snow_Line 		= ((rand (LOTW_R04) * (Tile_Height - CLEVEL)) + CLEVEL);

light_group {

SUN2 (Sun_Altitude,Sun_Azimuth,(<1,.8891,.6152> * 1.5))

#include "lotw_tpack2.inc"

// DISPLAY THE FINISH WORLD FORM
object {HF_WORLD #if (No_Texture = off)texture{Landform_Texture} #else pigment {rgb 1} #end}      

#if (Radiosity_Pass = 1)
sphere {<0,-640000,0>,642000
	pigment {rgb <1,.8891,.6152>}
	finish {ambient .2}
	double_illuminate 
	no_shadow
	hollow
}
#end

global_lights on

}

// ATMOSPHERIC STUFF  
light_group {
// THE AIR
#if (Force_Earth = on)
	#declare Sky_Blue		= <.6,.7,1>;
	#declare Decay_Red		= <1,.5,.5>; 
	#declare Light_Colour	= <1,1,1>; 
	
	#declare Sun_Colour			= <1,.5,0>;  	// VISIBLE COLOUR OF THE SUN OBJECT
	#declare Glare_Colour		= <1,.8,.6>;	// COLOUR OF THE GLARE AROUND THE SUN	
	#declare Sun_Size			= .5;			// RELATIVE SIZE OF THE SUN
	#declare Glare_Size			= 3;			// RELATIVE SIZE OF THE GLARE
	#declare Glare_Soft			= .1;			// GIVES THE GLARE A SOFT/HARD EDGE 
	#declare Sun_Scale			= 1;			// A RELATIVE SCALE FACTOR 

#else 
	#declare Light_Colour	= <((rand(LOTW_R02) * .3) + .8),((rand(LOTW_R02) * .3) + .8),((rand(LOTW_R02) * .3) + .8)>;		// RAW COLOUR OF SUNLIGHT (UNFILTERED BY THE ATMOSPHERE) 
	#declare Sky_Blue		= <((rand(LOTW_R02) * .4) + .6),((rand(LOTW_R02) * .4) + .6),((rand(LOTW_R02) * .4) + .6)>;	// BASE BLUE COLOUR OF THE SKY <.6,.7,1>
	#declare Decay_Red		= <((rand(LOTW_R02) * .5) + .5),((rand(LOTW_R02) * .5) + .5),((rand(LOTW_R02) * .5) + .5)>;	// BASE RED DECAY COLOUR <1,.5,.5>

	#declare Sun_Colour			= (Light_Colour * .5);  	
	#declare Glare_Colour		= Light_Colour;	
	#declare Sun_Size			= ((rand(LOTW_R02) * .5) + .5);			
	#declare Glare_Size			= 3;			
	#declare Glare_Soft			= .1;			
	#declare Sun_Scale			= 1;			

#end

#declare Sky_Method		= 2; 			// MEDIA METHOD    

// BUILD THE ATMOSPHERE
SUN (Sun_Altitude,Sun_Azimuth,Light_Colour)
#if (Render_Atmosphere = on)
Visible_Sun ()   
Sky_Density1 (1,800)						//THESE VALUES HAVE BEEN PRE SET 
Build_Atmosphere (Sky_Blue,15,Sky_Method)	// THESE VALUES HAVE BEEN PRE SET 
#end
// CLOUD SPHERE CONTROLS 

#if (Render_Clouds = on)
#if (rand(LOTW_R03) <= .75)
#if (rand(LOTW_R03) <= .75)
#declare Sky_Scale			= ((rand(LOTW_R03) * 3000) + 1000); 	// SCALE OF THE CLOUDS
#declare Sky_Clear			= ((rand(LOTW_R03) * .3) + .3);        	// RATIO OF OPEN SKY
#declare Sky_Translate		= (rand(LOTW_R03) * 10000);   	// TRANSLATE THE SKY PATTERN
#declare Sky_Rotate			= (rand(LOTW_R03) * 360);           // ROTATE THE SKY PATERN
#declare Cloud_Height		= 1500;  		// CLOUD ELEVATION   
#declare Rim_Depth			= ((rand(LOTW_R03) * .2) + .2);       	// DEPTH OF LIGHT RIM
#declare Rim_Sharpness		= ((rand(LOTW_R03) * .2) + .1);;		// SHARPNESS OF LIGHT RIM
#declare Texture_Depth		= 80;        	// TEXTURE ITERATIONS
#declare Cloud_Ambient		= .85;       	// AMBIENT FINISH VALUE
#declare Cloud_Warp      	= (rand(LOTW_R03) * .5);          	// TURBULENCE
CLOUDS_LOW ()
#else
#declare Sky_Scale			= ((rand(LOTW_R03) * 4000) + 1000); 	// SCALE OF THE CLOUDS
#declare Sky_Clear			= ((rand(LOTW_R03) * .3) + .3);        	// RATIO OF OPEN SKY
#declare Sky_Translate		= (rand(LOTW_R03) * 10000);   	// TRANSLATE THE SKY PATTERN
#declare Sky_Rotate			= (rand(LOTW_R03) * 360);           // ROTATE THE SKY PATERN
#declare Cloud_Height		= 2500;  		// CLOUD ELEVATION   
#declare Rim_Depth			= ((rand(LOTW_R03) * .2) + .2);       	// DEPTH OF LIGHT RIM
#declare Rim_Sharpness		= ((rand(LOTW_R03) * .2) + .1);;		// SHARPNESS OF LIGHT RIM
#declare Texture_Depth		= 80;        	// TEXTURE ITERATIONS
#declare Cloud_Ambient		= .85;       	// AMBIENT FINISH VALUE
#declare Cloud_Warp      	= (rand(LOTW_R03) * .5);          	// TURBULENCE
CLOUDS_HIGH ()
#if (rand(LOTW_R03) <= .25)
#declare Sky_Scale			= ((rand(LOTW_R03) * 3000) + 1000); 	// SCALE OF THE CLOUDS
#declare Sky_Clear			= ((rand(LOTW_R03) * .3) + .3);        	// RATIO OF OPEN SKY
#declare Sky_Translate		= (rand(LOTW_R03) * 10000);   	// TRANSLATE THE SKY PATTERN
#declare Sky_Rotate			= (rand(LOTW_R03) * 360);           // ROTATE THE SKY PATERN
#declare Cloud_Height		= 1500;  		// CLOUD ELEVATION   
#declare Rim_Depth			= ((rand(LOTW_R03) * .2) + .2);       	// DEPTH OF LIGHT RIM
#declare Rim_Sharpness		= ((rand(LOTW_R03) * .2) + .1);;		// SHARPNESS OF LIGHT RIM
#declare Texture_Depth		= 80;        	// TEXTURE ITERATIONS
#declare Cloud_Ambient		= .85;       	// AMBIENT FINISH VALUE
#declare Cloud_Warp      	= (rand(LOTW_R03) * .5);          	// TURBULENCE
CLOUDS_LOW ()
#end
#end
#end
#end

global_lights off
}

// FINISH WITH THE CAMERA INCLUDE AND MACRO
#include "lotw_camera.inc"	// CAMERA DECLARES AND MACROS
CAMERA ()                              

// 2 PASS RADIOSITY 
#include "lotw_radios.inc"  

global_settings {
	ambient_light 0
	assumed_gamma 1.8  
	max_trace_level 15
}
#default {finish{ambient 0}}

// REPORT ON FULL RANDOM NUMBER STREAM
#debug concat("R01-",str(R01,0,0),",R02-",str(R02,0,0),",R03-",str(R03,0,0),",R04-",str(R04,0,0),",R05-",str(R05,0,0),"\n")
