/*

LOTW COLOR_MAP UTILITIES
MAP TYPE 1. MONOCHROMATIC BASED UPON A SEED COLOUR
MAP TYPE 2. TOTALLY RANDOM COLOUR SET WITH 1 ENTRY BEING THE SEED VALUE

REVISION HISTORY
---------------- 
11/06/04 ISSUE A. INITIAL ISSUE

*/

#macro CYCLE_DCOLOUR (LIMIT,MIN,RANGE,C1,C2,SIGN)
	#local TEST = 3;
	#local LOOP_LIMIT = 10;
	#local LOOP_COUNT = 0;
	#while (TEST > LIMIT)
		#local CHANGE = ((rand(LOTW_R04) * RANGE) + MIN); 
		#if (C1 > C2)
			#local TEST = (C1 + (CHANGE * C2 * SIGN));
		#else
			#local TEST = (C1 + (CHANGE * C1 * SIGN));
		#end   
		#if (LOOP_COUNT > LOOP_LIMIT) #local TEST = LIMIT; #end
		#local LOOP_COUNT = (LOOP_COUNT + 1);
	#end
	#if (TEST > 1) #local TEST = 1; #end
	#if (TEST < 0) #local TEST = 0; #end 
	TEST;
#end

#macro MAKE_DCOLOUR (SEED)

	#local R1 = SEED.x;
	#local G1 = SEED.y;
	#local B1 = SEED.z;
	
	#local R2 = (1 - R1);
	#local G2 = (1 - G1);
	#local B2 = (1 - B1);

	// DIRECTION OF COLOUR SHIFT
	#if (rand(LOTW_R04) <= .5) #local S1 = 1; #else #local S1 = -1; #end
	
	#if ((R1 >= G1) & (R1 >= B1))
	// RED IS LARGEST COLOUR COMPONENT. POSSIBLE 50%-90% CHANGE
	#local R3 = CYCLE_DCOLOUR (2,.5,.4,R1,R2,S1) 
	#if (G1 >= B1)  
	// GREEN IS SECOND COLOUR COMPONENT. POSSIBLE 30%-70% CHANGE 
	#local G3 = CYCLE_DCOLOUR (R3,.3,.4,G1,G2,S1)
	// BLUE IS LAST COLOUR COMPONENT   
	#local B3 = CYCLE_DCOLOUR (G3,.1,.4,B1,B2,S1)
	#else  
	// BLUE IS SECOND COLOUR COMPONENTS. POSSIBLE 30%-70% CHANGE  
	#local B3 = CYCLE_DCOLOUR (R3,.3,.4,B1,B2,S1)
	// GREEN IS LAST COLOUR COMPONENT       
	#local G3 = CYCLE_DCOLOUR (B3,.1,.4,G1,G2,S1)
	#end
	#else  
	#if ((G1 >= R1) & (G1 >= B1))
	// GREEN IS LARGEST COMPONENTS. POSSIBLE 50%-90% CHANGE 
	#local G3 = CYCLE_DCOLOUR (2,.5,.4,G1,G2,S1)
	#if (R1 >= B1)   
	// RED IS SECOND COLOUR COMPONENT. POSSIBLE 30%-70% CHANGE  
	#local R3 = CYCLE_DCOLOUR (G3,.3,.4,R1,R2,S1)
	// BLUE IS LAST COLOUR COMPONENT 
	#local B3 = CYCLE_DCOLOUR (R3,.1,.4,B1,B2,S1)
	#else  
	// BLUE IS SECOND COLOUR COMPONENTS. POSSIBLE 30%-70% CHANGE 
	#local B3 = CYCLE_DCOLOUR (G3,.3,.4,B1,B2,S1)
	// RED IS LAST COLOUR COMPONENT 
	#local R3 = CYCLE_DCOLOUR (B3,.1,.4,R1,R2,S1)
	#end
	#else
	// BLUE IS LARGEST COMPONENT. POSSIBLE 50%-90% CHANGE 
	#local B3 = CYCLE_DCOLOUR (2,.5,.4,B1,B2,S1)
	#if (R1 >= G1)  
	// RED IS SECOND COLOUR COMPONENT. POSSIBLE 30%-70% CHANGE
	#local R3 = CYCLE_DCOLOUR (B3,.3,.4,R1,R2,S1)
	// GREEN IS LAST COLOUR COMPONENT 
	#local G3 = CYCLE_DCOLOUR (R3,.1,.4,G1,G2,S1)
	#else     
	// GREEN IS SECOND COLOUR COMPONENT. POSSIBLE 30%-70% CHANGE  
	#local G3 = CYCLE_DCOLOUR (B3,.3,.4,G1,G2,S1)
	// RED IS LAST COLOUR COMPONENT 
	#local R3 = CYCLE_DCOLOUR (G3,.1,.4,R1,R2,S1)
	#end
	#end
	#end
	
	<R3,G3,B3>

#end

#macro MAKE_CMAP (SEED,TYPE)

#if (TYPE = 1)

	#local R1 = SEED.x;
	#local G1 = SEED.y;
	#local B1 = SEED.z;
	
	#local R2 = (1 - R1);
	#local G2 = (1 - G1);
	#local B2 = (1 - B1);
	
	color_map {
		[0 rgb SEED]
		[.2 rgb (SEED * .8)]     
		[.4 rgb MAKE_DCOLOUR (SEED)]
		[.6 rgb (SEED + (<R2,G2,B2> * .2))]  
		[.8 rgb MAKE_DCOLOUR (SEED)]
		[1 rgb SEED]
	}
#else

	color_map { 
		[0 rgb SEED]
		[.2 rgb <rand(LOTW_R04),rand(LOTW_R04),rand(LOTW_R04)>] 
		[.4 rgb <rand(LOTW_R04),rand(LOTW_R04),rand(LOTW_R04)>]
		[.6 rgb <rand(LOTW_R04),rand(LOTW_R04),rand(LOTW_R04)>]
		[.8 rgb <rand(LOTW_R04),rand(LOTW_R04),rand(LOTW_R04)>]
		[1 rgb <rand(LOTW_R04),rand(LOTW_R04),rand(LOTW_R04)>]
	}
#end

#end
