/*

LOTW HEIGHT FIELD PATTERN

REVISION HISTORY
---------------- 
2/06/04 ISSUE A. INITIAL ISSUE

BASIC NUMBERS FOR THE ATMOSPHERIC MODEL
PLANET RADIUS 		= 640,000 UNITS
ATMOSPHERIC DEPTH	= 3,000 UNITS

*/

// SUN LOCATION AND BASIC LIGHT MACRO
#macro SUN (ALTITUDE,AZIMUTH,COLOUR) 

#declare Sun_Location 		= vaxis_rotate(<0,0,12000000>,<-1,0,0>,ALTITUDE);
#declare Sun_Location 		= vaxis_rotate(Sun_Location,<0,1,0>,AZIMUTH);    
#declare Factor_Adjust		= (<1,1,1> - Decay_Red);                           
#declare Factor_Multiplyer	= (90 - ALTITUDE); 
#declare Altitude_Factor1	= <	(1.5 + ((Factor_Adjust.x / 90) * Factor_Multiplyer)),
								(1.5 + ((Factor_Adjust.y / 90) * Factor_Multiplyer)),
								(1.5 + ((Factor_Adjust.z / 90) * Factor_Multiplyer))
							  >;
#declare Altitude_Factor2	= (.2 + (.5 / 90 * Factor_Multiplyer));

light_source {   
	Sun_Location
	color rgb COLOUR
	media_interaction on
	media_attenuation on   
	parallel
	point_at <0,0,0>
}

#end 

#macro SUN2 (ALTITUDE,AZIMUTH,COLOUR)  

#declare Sun_Location 		= vaxis_rotate(<0,0,12000000>,<-1,0,0>,ALTITUDE);
#declare Sun_Location 		= vaxis_rotate(Sun_Location,<0,1,0>,AZIMUTH);    

light_source {   
	Sun_Location
	color rgb COLOUR
	media_interaction off
	media_attenuation off   
	parallel
	point_at <0,0,0>
}

#end
    
// FULL ATMOSPHERIC DENSITY
#macro Sky_Density1 (BASE_DENSITY,HALF_HEIGHT)

#declare Start_Density 		= (1 - (640000 / 643000)); 
#declare Half_Density		= (1 - ((640000 + HALF_HEIGHT) / 643000));

#declare Atmospheric_Density1 = 
density {
	spherical 
	density_map { 
		[0 rgb 0]  
		[Half_Density rgb (BASE_DENSITY / 2)]
		[Start_Density rgb BASE_DENSITY] 
		[1 rgb 1]
	}
	poly_wave 2
	scale 643000 
	translate <0,-640000,0>
}
#end   

// BUILDING THE ATMOSPHERE 
#macro Build_Atmosphere (SKY_BLUE,FACTOR,METHOD)
sphere {
	<0,-640000,0>,643000
	texture{pigment{rgbt<0,0,0,1>}}
	interior {
		media {  
			absorption (SKY_BLUE / FACTOR * Altitude_Factor1)
			emission (SKY_BLUE / FACTOR * Altitude_Factor2)                
			scattering {
				4,
				(SKY_BLUE / FACTOR)
				extinction 0
			} 
			density {Atmospheric_Density1}
			method METHOD        
		}                           
	}
	hollow
} 
# end

// VISIBLE SUN AND SUN GLARE

#macro Visible_Sun ()
#declare Sun_Pigment_Scale = (Sun_Size + Glare_Size + Glare_Soft);

#declare Sun_Pigment =
pigment {
	spherical
	color_map {
		[0.0 								rgbt <0,0,0,1>]
		[(Glare_Size / Sun_Pigment_Scale)	rgb Glare_Colour]
		[((Glare_Size + Glare_Soft) / Sun_Pigment_Scale) 	rgb  Sun_Colour]
		[1.0 rgb  Sun_Colour]
	}
	scale (10000 * Sun_Pigment_Scale * Sun_Scale)
	translate <0,0,175000>
	rotate <-Sun_Altitude,0,0>
	rotate <0,Sun_Azimuth,0>
}

sphere {
	<0,0,0>
	175000
	pigment {Sun_Pigment}
	double_illuminate     
	no_shadow
	hollow
} 

#end

 

