/* 

LANDSCAPE OF THE WEEK MASTER POV FILE
GENERATES A RANDOM LANDSCAPE BASED UPON EITHER

1. A SINGLE SEED VALUE FOR TOTALY RANDOM LANDSCAPES, OR
2. A SET OF SEED VALUES GIVING YOU PSEUDO CONTROL OVER THE VARIOUS LANDSCAPE COMPONENTS  

THERE IS AN OPTIONAL INI FILE FOR RENDERING. THE CAMERA SETUP WILL DETECT THE IMAGE SIZE SETTINGS.

ORIGINAL LOTW CONCEPT BY Christoph Hormann
THIS VERSION BY NATHAN O'BRIEN 2004 

CURRENT LANDFORMS ARE HEIGHT FIELDS

REVISION HISTORY
---------------- 
21/05/04 ISSUE A. LANDFORM GENERATION ONLY
02/06/04 ISSUE B. ATMOSPHERE AND CLOUDS ADDED
26/06/04 ISSUE C. LARGE SECTIONS OF CODE MOVED TO NEW ENGINE INCLUDE
			LIGHT_GROUPS ADDED
			DETAIL LEVEL ADDED AND INCORPORATED INTO TEXTURE PACKS				  

*/

#declare Scene_Detail	= 7;	// 1 = LOW DETAIL. NO ROCKS OR TREES. NO WATER, ATMOSPHERE OR CLOUDS.
								// 2 = MEDIUM DETAIL. WITH ROCKS AND TREES. NO WATER, ATMOSPHERE OR CLOUDS   
								// 2 = MEDIUM DETAIL. WITH ROCKS TREES AND WATER. NO ATMOSPHERE OR CLOUDS
								// 4 = HIGH DETAIL. WITH ROCKS, TREES, WATER, ATMOSPHERE AND CLOUDS
								// 5 = SKY TEST. LOW RES LANDSCAPE, NO TEXTURES, ROCKS, TREES, WATER. JUST ATMOSPHERE AND CLOUDS
								// 6 = V.HIGH DETAIL FIRST PASS RADIOSITY
								// 7 = V.HIGH DETAIL SECOND PASS RADIOSITY
		
#declare Camera_Height	= 100;	// HEIGHT ABOVE NATURAL GROUND (OR WATER LEVEL IF HIGHER)
#declare Force_Earth	= on;	// FORCES THE LANDSCAPE TO BE MORE EARTH LIKE (LESS ALIEN)   
#declare Texture_Pack	= 2;	// USE A SPECIFIC TEXTURE PACK. IF = 0 THEN A RANDOM PACK WILL BE CHOSEN

// OPTION 1 A SINGLE SEED
#declare LOTW_RAND = seed(67);    // 101 for rock test 67

// OPTION 2 INDIVIDUAL SEED VALUES
// SIMPLY REMOVE // AND APPLY
//#declare LOW_R01 = seed(1234); // R01 IS USED TO CONTROL THE LANDFORM PATTERN 
//#declare LOW_R02 = seed(1234); // R02 IS USED TO CONTROL THE ATMOSPHERE 

#include "lotw_engine.inc"