/*

LOTW HEIGHT FIELD CONTROL FILE  
CREATES A TILED SET OF HEIGHT FIELDS WITH A DIMINISHING LEVEL OF DETAIL
TILES ARE LIMITED BY THE FIELD OF VIEW SET BY THE CAMERA ANGLE

REVISION HISTORY
---------------- 
21/05/04 ISSUE A. INITIAL ISSUE

*/


// INTERNAL DECLARES

#declare Tile_DCount = 1;

// INTERNAL FUNCTIONS

#macro HF_Tile (TRANSLATE,STEPS,PIGMENT) 

#declare HF_Box =
height_field {
	function Detail_Steps,Detail_Steps {
		pigment{PIGMENT translate (<-TRANSLATE.x,TRANSLATE.z,0> / Tile_Size)}
	} 
	smooth
	translate <-.5,0,0>
	scale <Tile_Size,Tile_Height,Tile_Size>  
} 

#if (STEPS > Tile_DCount)

	#declare Detail_Steps = (Detail_Steps / Detail_Falloff);
	#if (Detail_Steps < Tile_Detail_Min) #declare Detail_Steps = Tile_Detail_Min; #end 
	
	#declare Tile_DCount = (Tile_DCount + 1);
	
#end

#end

#macro Make_HFSurface (PIGMENT)

#local Count1 = 0;

#declare HF_WORLD =
union {

#while (Count1 < Tile_Depth)

	// CHECK THE QTY OF TILES TO THE SIDE FROM THE CENTRE TILE USING THE CAMERA ANGLE
	#local Test_Condition	= false;
	#local Column			= (Count1 + 1); 
	#local Columns = 1;
	
	#while (Test_Condition = false)
	    
		#local Test_Value1 = (Column * Tile_Size);    		
		#local Test_Value2 = (((Tile_Size / 2) + (Tile_Size * (Columns -1))) * tan(radians(90 - (Camera_Angle / 2))));
		#if (Test_Value2 > Test_Value1)
			#local Test_Condition = true;
		#else
			#local Columns = (Columns + 1);
		#end 
	#end
	
	// PLACE THE HF_BOX  
	// CENTRE BOX   
	HF_Tile (<0,0,(Count1 * Tile_Size)>,Count1,PIGMENT)
	object {HF_Box translate <0,0,(Count1 * Tile_Size)>}
	
	#if (Count1 = 0)
		#declare CAM_ORIGIN = object {HF_Box}
	#end
	
	// SIDE BOXS
	#local Count2 = 1;
	
	#while (Count2 < Columns)
	    HF_Tile (<(Count2 * Tile_Size),0,(Count1 * Tile_Size)>,Count1,PIGMENT)
		object {HF_Box translate <(Count2 * Tile_Size),0,(Count1 * Tile_Size)>}
		HF_Tile (<-(Count2 * Tile_Size),0,(Count1 * Tile_Size)>,Count1,PIGMENT) 
		object {HF_Box translate <-(Count2 * Tile_Size),0,(Count1 * Tile_Size)>} 
	
		#local Count2 = (Count2 + 1);  
		
	#end

	#local Count1 = (Count1 + 1); 
	
#end 

} 

#end