/*

LOTW EARTH LIKE TEXTURE FILE TEMPLATE

REVISION HISTORY
---------------- 
21/05/04 ISSUE A. INITIAL ISSUE

*/ 

// THE BASE PIGMENT
// RANDOMIZE THESE FOR ALIEN TEXTURES

#declare PSNOW 	= pigment {rgb 1}
#declare PGRASS =
pigment {
	wrinkles
	color_map {
		[0 rgb <0.471,0.733,0.184>]
		[.5 rgb <.7,.8,.1>] 
		[.75 rgb <0.939,0.837,0.727>]  
		[1 rgb <0.25,0.4,0.1>]
	} 
	warp {turbulence .5} 
	scale 10
}
#declare PSAND 	=
pigment {
	wrinkles
	color_map {
		[0 rgb <0.739,0.637,0.527>]
		[.5 rgb <0.5,0.45,0.2>]
		[1 rgb <0.886,0.769,0.675>]
	}       
	warp {turbulence .5}
	scale 10
}
#declare PROCK 	=
pigment {
	granite
	color_map {
		[0 rgb <0.939,0.837,0.727>] 
		[.5 rgb <0.5,0.45,0.2>]
		[1 rgb <0.686,0.569,0.475>]
	} 
	scale <4,1,4>  
	warp {turbulence <.1,.2,.1> octaves 4 omega .75}
	scale 25
}

// THE BASE TEXTURES
// RANDOMIZE FOR ALIENT TEXTURES

#declare LNORMAl = normal {function {f_ridged_mf(x,y,z, 1,2,5,.75,5,5)}.5}
#declare LNORMAL2 =
normal {
	granite 1 
	scale <4,1,4>  
	turbulence <.1,.2,.1> octaves 4 omega .75
	scale 15
}

#declare TSNOW 	= texture{pigment{PSNOW} normal{LNORMAl scale 10} finish {phong 1}} 
#declare TGRASS = texture{pigment{PGRASS} normal{LNORMAl scale 10}}
#declare TSAND 	= texture{pigment{PSAND} normal{LNORMAl scale 5}}
#declare TROCK 	= texture{pigment{PROCK} normal {LNORMAL2}} 

// TRANSITION TEXTURES
#declare TSNOW_GRASS =
texture {
	pigment_pattern {
		wrinkles
		color_map {[0 rgb 0][1 rgb 1]}
		warp {turbulence .2}
		scale 30 
	}
	texture_map {
		[0.0 TSNOW]
		[0.3 TSNOW]
		[0.6 TGRASS]
		[1.0 TGRASS]
	}
} 
#declare TSAND_GRASS =
texture {
	pigment_pattern {
		wrinkles
		color_map {[0 rgb 0][1 rgb 1]}
		warp {turbulence .2}
		scale 20
	}
	texture_map {
		[0.0 TSAND]
		[0.3 TSAND]
		[0.6 TGRASS]
		[1.0 TGRASS]
	}
} 

// GRADIENT Y TEXTURES 
#declare Slope_Range  	= (Tile_Height * 1.2); 
#declare YWATER 		= ((Water_Level * 1.1) / Slope_Range);	
#declare YSNOW 			= ((Snow_Line * 1.1) / Slope_Range);
#declare TZONE			= .07;
#declare SHORE			= .04;

#declare TGRADIENT1 =
texture {
	pigment_pattern {
		gradient y  
		warp {turbulence .1 octaves 4 omega .75}
		warp {turbulence <.5,0,.5>}
		scale Slope_Range 
		translate (Tile_Height * -.1)
	}
	texture_map {  
		[0 TSAND]
		[(YWATER + SHORE) TSAND] 
		[(YWATER + SHORE + TZONE) TSAND_GRASS]
		[(YWATER + SHORE + (TZONE * 2)) TGRASS]    
		[(YSNOW - TZONE) TGRASS]
		[(YSNOW + TZONE) TSNOW_GRASS] 
		[(YSNOW + TZONE) TSNOW]
		[1]
	}
}

// SLOPE TEXTURE
#declare TSLOPE1 =
texture {
	slope {-y,0,.5}
	texture_map {
		[0 TGRADIENT1]
		[.55 TGRADIENT1] 
		[.575 TROCK]
		[1 TROCK]
	}
}  

// WATER 
#if (Render_Ocean = on)

#declare Foam_Pattern =
pigment {
	object {
		object {HF_WORLD translate <0,10,0>}
		color rgb 0
		color rgb 1
	}
	warp {turbulence .5}
}

#declare Water_Normal = 
normal {
	function {f_ridged_mf(x,y,z, 1,2,5,.75,5,5)}
	.2
	scale 20
}

#declare Water_Finish =
finish {
	specular 4.0
	roughness 0.0005
	conserve_energy
	reflection {
		0 , 1
		fresnel  on
		falloff  2
		exponent .75
	}
} 

#declare Water_Interior =
interior {
	caustics 2
	ior 1.34
	fade_distance 10 
	fade_power 1
	fade_color rgb <0.1, 0.1, 0.4> 
}

#declare Water_Tex1 = 
texture{
	pigment {rgbt <.9,.9,1,.9>}
	normal {Water_Normal}
	finish {Water_Finish}
} 

#declare Water_Tex2a =
texture {
	pigment {rgbt <.9,.9,1,.9>}
	normal {Water_Normal}
	finish {Water_Finish}
}

#declare Water_Tex2b =
texture {
	pigment {rgb 1}
	normal {Water_Normal scale .5}
	finish {phong .5 ambient .3}
}

#declare Water_Tex2 = 
texture {
	crackle form <1,0,0>
	texture_map {
		[0 	Water_Tex2b]
		[.1 Water_Tex2b]
		[.6 Water_Tex2a]
		[1 Water_Tex2a]
	}
	warp {turbulence 1}
	scale 5
}

#declare Ocean_Texture =
texture {
	pigment_pattern {Foam_Pattern}
	texture_map {
		[0 Water_Tex1]
		[1 Water_Tex2]
	}
}

plane {y,Water_Level texture{Ocean_Texture}interior{Water_Interior}} 

#end


