
 
///////////////////////////// Final Render ///////
// +a0.1 +w1220 +h915 
// +a0.1 +w1708 +h1281   
// +a0.1 +w2440 +h1830  
// 
// +a0.1
//
// for hdr add:  
// +fh
// +fh +a0.1 +w1220 +h915 
// +fh +a0.1 +w1708 +h1281   
// +fh +a0.1 +w2440 +h1830 
/////////////////////////////

// PoVRay 3.7 Scene File Test
// author:  ... Gerhard Oosthuizen aka Nekar Xenos
// 

//*************************************************************************  
//
//                          -Instructions-
//
// a) First declare scene to render as a colour map =>  SceneClock=1    
// b) then rename rendered image to "PaintMap.png" by adding the following to the commandline  
// +OPaintMap  
//
// c) Then render with =>  SceneClock=2      
//
//--------------------------------------------------------------------------
#version 3.7;   
 
global_settings {
  max_trace_level 5
   assumed_gamma 1
}
   
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "woods.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "functions.inc"
#include "math.inc"
#include "transforms.inc"

//
#declare MapFile="PaintMap.png";  // <<= the image to be used for colour information derived from SceneClock=1 

#declare SceneClock=1;  //0=Original scene; 1=Colour Map (high ambient) ; 2=dripscene  
#declare PaintReflect=off;  
#declare FadeInt=off;  

//--------------------------------------------------------------------------

#if(SceneClock=2) // Final Render background -  Change this as you please

background { color rgb 1 }
fog { fog_type   2
      distance   150
      color      rgb 1  
      fog_offset 1
      fog_alt    .5
      turbulence 1.8
    }
         
#declare NormScale=.03;

plane{ <0,1,0>, 0 
       texture{ pigment{ color rgb <1.00,0.95,0.8>}
                normal { bumps  scale 0.005  }
                finish { phong 0.1 } 
              }
     }
//--------------------------------------------------------------------------
//---------------------------- objects in scene ----------------------------
//--------------------------------------------------------------------------

   
#else  // Original scene background   -  Change this as you please
 
    plane {
      y, -1
       pigment{ //rgb <.1,.03,.01>
           crackle scale 2 warp{turbulence <1,0,.1>}  pigment_map {[0 crackle scale .1 colour_map{[0 rgb <.05,.08,.1>*.001][1 rgb<.05,.07,.05>*.02] } ]
                                            [.5 crackle scale .01 colour_map{[0 rgb <.05,.08,.1>*.002][1 rgb <.05,.08,.1>*.03]}]}
                                            } 
             normal{crackle   scale .02 }
             finish{roughness .1 specular .5}  
             
            } 
       
#end // SceneClock=2  

#declare CamPos= <0, 1.5,-4 >; // <0.5, 1.5,4.5 >;
#declare CamLook= <0,1.2,1>; //  <1.3,1.5,0>; 
#declare CamDirect=<0,0,1>;
#declare CamWidth=image_width;
#declare CamHeight=image_height;   

#declare ColMap=MapFile;
#declare Rand=seed(197531); 

#declare ShowRad=off;
#declare ShowMedia=off;  
#declare AreaLight=off; 
#declare FocalBlur=off;  
#declare BlurFinish=off; 
#declare ShowLights=off;   
#declare AreaSpot=off; 
#declare LightGroups=on; 
#declare Modelling=off;


#if(SceneClock=1)
    #declare ShowRad=off;
    #declare ShowMedia=off;  
    #declare AreaLight=off; 
    #declare FocalBlur=off;  
    #declare BlurFinish=off; 
    #declare ShowSpotLight=off;
    #declare SpotAttenuate=off; // fades through media
    #declare ShowLights=off;   
    #declare AreaSpot=off; 
    #declare LightGroups=off; 
    #declare Modelling=off;

#elseif(SceneClock=2)
   
    #declare ShowRad=off; 
    #declare AreaLight=off;  
    #declare ShowMedia=off;  
    #declare FocalBlur=off;  
    #declare BlurFinish=off; 
    #declare ShowLights=on;   
    #declare AreaSpot=off; 
    #declare LightGroups=off; 
    #declare MoonLight=1;// moon brightness
    #declare Modelling=off;
    
    #declare Map=
        plane {
          z, -1
          texture {
            pigment {
              image_map {
                png MapFile 
                interpolate 2 // smooth it
                }
              translate -0.5*(x+y) 
            }
            finish { ambient 1}
          }
        }
#end // #if(SceneClock

#if(Modelling)
    #declare ShowRad=off;
    #declare ShowMedia=off;
    #declare AreaLight=off; 
    #declare FocalBlur=off;  
    #declare BlurFinish=off; 
    #declare SpotAttenuate=off; // fades through media
    #declare AreaSpot=off;
    #declare SpotAttenuate=off;
    #declare LightGroups=off;
#end

#declare FinalRender=0 ; //2; // 0; // 1; // 2 ;// 3; //


#if (SceneClock=1)
   #default{ finish{ ambient 1 diffuse 1 metallic 1 specular 0 phong 0}}  
#end

global_settings { 
    assumed_gamma 1.0
    
    #if(!ShowRad) 
        ambient_light .001*<.8,.9,1>
    #else
        ambient_light 0 //.15*<.8,.9,1>
    #end 
    
    #if (SceneClock=1)
        ambient_light 1
    #end   
       }  
   

//===================== RADIANCE AND ENVIRONMENT SETTINGS =====================
#if(ShowRad)  // Show Radiosity
    
    global_settings {
    assumed_gamma 1.0
    radiosity {
              //pretrace_start 0.08           // start pretrace at this size
              //pretrace_end   0.04           // end pretrace at this size
              count 160// 35                      // higher -> higher quality (1..1600) [35]
              //nearest_count 5               // higher -> higher quality (1..10) [5]
              //error_bound 1.8               // higher -> smoother, less accurate [1.8]
              recursion_limit 2 //3             // how much interreflections are calculated (1..5+) [3]
              //low_error_factor .5           // reduce error_bound during last pretrace step
              //gray_threshold 0.0            // increase for weakening colors (0..1) [0]
             // minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
              brightness .3                  // brightness of radiosity effects (0..1) [1]
        
              //adc_bailout 0.001
              normal on                   // take surface normals into account [off]
              //media on                    // take media into account [off]
              //save_file "file_name"       // save radiosity data
              //load_file "file_name"       // load saved radiosity data
              //always_sample off           // turn sampling in final trace off [off]
              //max_sample 1.0              // maximum brightness of samples
          }
   }
#end // Show Radiosity

// ----------------------------------------

 
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ************************************* ORIGINAL SCENE **************************************************************************** //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 
#declare Scene=union{  // Change this to your scene

    sphere { <0,0,0>, 0.5 
            texture { pigment{ color Red }} // end of texture 
            translate<0,0.5,0>   
            scale 2  translate<1,0,0>  
            }  // end of sphere ----------------------------------- 
    
    box { <-5,0,3>,<3,5,3>
        texture { pigment{ color Blue } } // end of texture 
        
        translate<0,0,3>  
        }
         
   ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    }// end of Original Scene union                                                                                              //
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    

 
//////////////////////////////////////////////////////////////////////////////////////

 //////// ******************************LIGHTS********************************* ////////////

#if(SceneClock<1) 
    union{ object{Scene } }
#end // if(SceneClock<1) 

#if (SceneClock=2)
    #declare Obj=object{Scene}
       
    
    ///      
    
    #declare Rnd= seed(7531);
    #declare Rand=seed(97531);
    #declare Seed=seed(97531);
    #declare Object=Obj;
    
    ////////////////////=================================================================================================================
    
    #include"PaintNX.inc"
           
    ///////////////////////
      
    #declare Col=<-1,-1,-1>; // Col=<-1,-1,-1>; for ColourMap (ColMap) or change to an actual colour to predefine a colour 
    
    #declare PFinish=finish{diffuse 1  specular .1 phong 1 phong_size 180 roughness.005 brilliance 2  
                    #if (PaintReflect)
                       reflection{0,.3 } //conserve_energy 
                    #end
                    };  
    
    #local ColVar=0; // Colour variation
                            
    #declare Spacing=.1; // Dabs/Drops Spacing
    #declare MaxDrops=1000; 
    #declare MinThickness=.007;
    #declare MaxThickness=.6;
    #declare Merge=0;
    #declare MaxLength=10; //lenght of drip or dab
    #declare Squiglyness=.3;   // 0-1 +
    #declare ContainerStart=max_extent(Scene);// or add specific co-ordinates to trace within // use <0,0,0> to ignore (default)   
    #declare ContainerEnd=min_extent(Scene);// or add specific co-ordinates to trace within  // use <0,0,0> to ignore (default)    
    #declare Threshold=2;// Blob Threshold // 2= detail  // .1= Bigger   
    #declare Direction=<1,-1,0>; // Wind/gravity: <xDirection,yDirection,zDirection>;  Random directions: <0,0,0> 
    #declare ColSystem=0; // 0= colourize, 1 CMYK, 2=CMYbw, 3=CMYKrgbW . 4=CMYw  , 5=CMY to original
    #declare Brush=0;  // amount of extra clumps per brush stroke. Negative value changes to amount of arms per splat
    
    // Paint Macro  
    PaintNX (Scene, ColMap, CamPos, CamLook, CamDirect, image_width, image_height, Col, ColVar, PFinish, Brush, Spacing, MaxDrops, MaxLength, 
           MinThickness, MaxThickness, Merge, Seed, Squiglyness, ColSystem, Threshold, Direction, ContainerStart, ContainerEnd 
           )
           
    ////////////////////=================================================================================================================
   
#end  // #if (SceneClock=2)
 
/////////////////////////////////////////////////////////////////////// 
#if (SceneClock=1)
    union{object{Scene }}
#end  

// = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = * = *

light_source {<10, 10, -10> color rgb 1.0 }

camera { 
        location  CamPos
        direction CamDirect 
        right   x*image_width/image_height
        look_at CamLook
        }     
 