#include"Functions.inc"

/////////////////////////////////////////////////////////////////////////////////   
// Math macros

#macro RandVect(Seed)
    (2*<.5-rand(Seed),.5-rand(Seed),.5-rand(Seed)>)
#end 

#macro RandDir(Seed)
    (.5-rand(Seed))
#end

#macro Sign(A)
    (A!=0)*A/abs(A)
#end

#macro SignVect(A)
    <Sign(A.x),Sign(A.x),Sign(A.x)>
#end

#macro AbsVect(A)
    <abs(A.x),abs(A.y),abs(A.z)>
#end

#macro IfSign(A,B)
    (AbsVect(B)*<(Sign(A.x)=Sign(B.x)), (Sign(A.y)=Sign(B.y)), (Sign(A.z)=Sign(B.z))>)
#end 

////////   // Colour macros
 
#macro Colourize(Col, ColVar, Seed)
    
    #local RGBVar=<min(Col.x,(1-Col.x)), .5*min(Col.y,(1-Col.y)), min(Col.z,(1-Col.z))>;  
    #local MaxVar=ColVar*(1-Col);  
    #local MinVar=ColVar*Col;
    #local Colours=Col-(MinVar*<rand(Seed),rand(Seed),rand(Seed)>)+(MaxVar*<rand(Seed),rand(Seed),rand(Seed)> );
     
    #declare Colour=Colours;

#end// Colours(Col, ColVar, Seed)

#macro ColourizeCMY(Col, ColVar, Seed) /// ==============**** * * * * * * 
    
    #local ColSep=< (Col.red >0.5) , (Col.green >0.5), (Col.blue >0.5) >;

    #if ((ColSep.red)*(ColSep.green=0)*(ColSep.blue=0)*(Col.blue>Col.green))
                #local ColSep=<1,0,1>;
    #eleseif ((ColSep.red)*(ColSep.green=0)*(ColSep.blue=0)*(Col.blue<Col.green))
                #local ColSep=<1,1,0>;
    #end
    
    
    #if ( (ColSep.red=0)*(ColSep.green)*(ColSep.blue=0)*(Col.red>Col.blue))
                #local ColSep=<1,1,0>;
    #elseif ((ColSep.red=0)*(ColSep.green)*(ColSep.blue=0)*(Col.red<Col.blue))
                #local ColSep=<0,1,1>;
    #end
    
    #if ((ColSep.red=0)*(ColSep.green=0)*(ColSep.blue))
                #local ColSep=<0,1,1>;
    #end
    
    
    #if ((ColSep.red=0)*(ColSep.green=0)*(ColSep.blue=0))
        #local ColSep=<0,0,.5>;
    #end

    #local VarScale=rand(Seed);  
    
    #local ColDiff=ColSep-Col; 
    
    #declare ColLength=1;
    
    (Col+VarScale*ColVar*ColDiff)
    
#end// Colours(Col, ColVar, Seed)

//////////////////////////////////////////////////////////////////////


     /*  rgb to cmyk conversion
        Black   = minimum(1-Red,1-Green,1-Blue)
        Cyan    = (1-Red-Black)/(1-Black)
        Magenta = (1-Green-Black)/(1-Black)
        Yellow  = (1-Blue-Black)/(1-Black)      
      */
      
      

////////
 
#macro CMYK(Col, ColVar, Seed, ColCount)

    #local Colours=Col; // add variety of colours
     
    #if (Colours.x>1) #local Colours=<1,Colours.y,Colours.z>; #end  // "Normalize" bright colours
    #if (Colours.y>1) #local Colours=<Colours.x,1,Colours.z>; #end
    #if (Colours.z>1) #local Colours=<Colours.x,Colours.y,1>; #end  
    
    #if ( (Colours.x<0)+(Colours.y<0)+(Colours.z<0) ) // "Normalize" negative colours
        #local Colours=<(Colours.x)*(Colours.x>0),(Colours.y)*(Colours.y>0),(Colours.z)*(Colours.z>0)>; 
    #end 
    /////
    
    #declare BlackLength=min(1-Col.x,1-Col.y,1-Col.z);
    #declare WhiteLength=1-BlackLength;
    #declare CyanLength=(1-Col.x-BlackLength)/WhiteLength; 
    #declare MagentaLength=(1-Col.y-BlackLength)/WhiteLength;
    #declare YellowLength=(1-Col.z-BlackLength)/WhiteLength;
    ////
    #switch(ColCount)
        #case(0) #declare ColLength=BlackLength; <0,0,ColVar*rand(Seed)> #break  // Colourize
        #case(1) #declare ColLength=WhiteLength; <1,1,1>-ColVar*.1*<rand(Seed),rand(Seed),rand(Seed)>#break  // CMYKw
        #case(2) #declare ColLength=CyanLength; <0, .68,.93>+ColVar*<0,.32,.07>*rand(Seed) #break  // CMYbw
        #case(3) #declare ColLength=MagentaLength; <.92,0,.56>+ColVar*<.08,0,.44>*rand(Seed) #break  // CMYKrgbW  
        #case(4) #declare ColLength=YellowLength; <1,.94,.07>+ColVar*<0,.06,-.07>*rand(Seed) #break  // CMYw 
        //#case(5) #local ColCountMax=4; #break  // Orig to CMY
    #end
    

#end// Colours(Col, ColVar, Seed)

////////////////////////////////////////////////////////////////// 
#macro CMYbw(Col, ColVar, Seed, ColCount)

    #local Colours=Col; //+ColVar*.5*(Col-.5+<rand(Seed),rand(Seed),rand(Seed)>); // add variety of colours
     
    #if (Colours.x>1) #local Colours=<1,Colours.y,Colours.z>; #end  // "Normalize" bright colours
    #if (Colours.y>1) #local Colours=<Colours.x,1,Colours.z>; #end
    #if (Colours.z>1) #local Colours=<Colours.x,Colours.y,1>; #end  
    
    #if ( (Colours.x<0)+(Colours.y<0)+(Colours.z<0) ) // "Normalize" negative colours
        #local Colours=<(Colours.x)*(Colours.x>0),(Colours.y)*(Colours.y>0),(Colours.z)*(Colours.z>0)>; 
    #end 
    /////
    
    #declare BlackLength=min(1-Col.x,1-Col.y,1-Col.z);
    #declare WhiteLength=1-BlackLength;
    #declare CyanLength=(1-Col.x-BlackLength)/WhiteLength; 
    #declare MagentaLength=(1-Col.y-BlackLength)/WhiteLength;
    #declare YellowLength=(1-Col.z-BlackLength)/WhiteLength;
    #declare YellowCol=<1,.94,.07>+ColVar*<0,.06,-.07>*rand(Seed);
    ////
    #switch(ColCount)
        #case(0) #declare ColLength=BlackLength;  (<0,0,.5*rand(Seed)>) #break  // Colourize
        #case(1) #declare ColLength=WhiteLength; (<1,1,1>-ColVar*.1*<rand(Seed),rand(Seed),rand(Seed)>) #break  // CMYKw
        #case(2) #declare ColLength=CyanLength; (<0, .68,.93>+ColVar*<0,.32,.07>*rand(Seed)) #break  // CMYbw
        #case(3) #declare ColLength=MagentaLength; (<.92,0,.56>+ColVar*<.08,0,.44>*rand(Seed)) #break  // CMYKrgbW  
        #case(4) #declare ColLength=YellowLength; (<1,.94,.07>+ColVar*<0,.06,-.07>*rand(Seed)) #break  // CMYw 
        //#case(5) #local ColCountMax=4; #break  // Orig to CMY
    #end    

#end// Colours(Col, ColVar, Seed)


////////////////////////////////////////////////////////////////// 
#macro CMYw(Col, ColVarMem, Seed, ColCount)

    #local Colours=Col; //+ColVar*.5*(Col-.5+<rand(Seed),rand(Seed),rand(Seed)>); // add variety of colours
     
    #if (Colours.x>1) #local Colours=<1,Colours.y,Colours.z>; #end  // "Normalize" bright colours
    #if (Colours.y>1) #local Colours=<Colours.x,1,Colours.z>; #end
    #if (Colours.z>1) #local Colours=<Colours.x,Colours.y,1>; #end  
    
    #if ( (Colours.x<0)+(Colours.y<0)+(Colours.z<0) ) // "Normalize" negative colours
        #local Colours=<(Colours.x)*(Colours.x>0),(Colours.y)*(Colours.y>0),(Colours.z)*(Colours.z>0)>; 
    #end 
    /////
    
    #declare BlackLength=min(1-Col.x,1-Col.y,1-Col.z);
    #declare WhiteLength=max(Col.x,Col.y,Col.z);
    #declare CyanLength=(1-Col.x); 
    #declare MagentaLength=(1-Col.y);
    #declare YellowLength=(1-Col.z);
    #declare YellowCol=<1,.94,.07>+ColVar*<0,.06,-.07>*rand(Seed);
    ////
    #switch(ColCount)
        #case(0) #declare ColLength=WhiteLength; (<1,1,1>-ColVar*.1*<rand(Seed),rand(Seed),rand(Seed)>) #break  // Colourize
        #case(1) #declare ColLength=CyanLength; (<0, .68,.93>+ColVar*<0,.32,.07>*rand(Seed)) #break  // CMYKw
        #case(2) #declare ColLength=MagentaLength; (<.92,0,.56>+ColVar*<.08,0,.44>*rand(Seed)) #break  // CMYbw
        #case(3) #declare ColLength=YellowLength;(<1,.94,.07>+ColVar*<0,.06,-.07>*rand(Seed)) #break  // CMYKrgbW  
        //#case(4) <1,.94,.07>+ColVar*<0,.06,-.07>*rand(Seed) #break  // CMYw 
        //#case(5) #local ColCountMax=4; #break  // Orig to CMY
    #end   

#end// CMYw(ColMem, ColVarMem, Seed)

////////////////////////////////////////////////////////////////// 
#macro CMYOrig(Col, ColVarMem, Seed, ColCount)

    #local Colours=Col; //+ColVar*.5*(Col-.5+<rand(Seed),rand(Seed),rand(Seed)>); // add variety of colours
     
    #if (Colours.x>1) #local Colours=<1,Colours.y,Colours.z>; #end  // "Normalize" bright colours
    #if (Colours.y>1) #local Colours=<Colours.x,1,Colours.z>; #end
    #if (Colours.z>1) #local Colours=<Colours.x,Colours.y,1>; #end  
    
    #if ( (Colours.x<0)+(Colours.y<0)+(Colours.z<0) ) // "Normalize" negative colours
        #local Colours=<(Colours.x)*(Colours.x>0),(Colours.y)*(Colours.y>0),(Colours.z)*(Colours.z>0)>; 
    #end 
    /////
    
    #declare BlackLength=min(1-Col.x,1-Col.y,1-Col.z);
    
    #declare WhiteLength=max(Col.x,Col.y,Col.z);
    #declare WhiteCol=<1,1,1>-ColVar*.1*<rand(Seed),rand(Seed),rand(Seed)>;
    
    #declare CyanLength=(1-Col.x); 
    #declare CyanCol=<0, .68,.93>+ColVar*<0,.32,.07>*rand(Seed); // C= <0, .68,.93>
    
    #declare MagentaLength=(1-Col.y);
    #declare MagentaCol=<.92,0,.56>+ColVar*<.08,0,.44>*rand(Seed); // M= <.92,0,.56> // <.92,.149,.56>  
    
    #declare YellowLength=(1-Col.z);
    #declare YellowCol=<1,.94,.07>+ColVar*<0,.06,-.07>*rand(Seed);
    ////
    #switch(ColCount)
        #case(0) #declare ColLength=WhiteLength; (<1,1,1>-ColVar*.1*<rand(Seed),rand(Seed),rand(Seed)>) #break  // Colourize
        #case(1) #declare ColLength=CyanLength; (<0, .68,.93>+ColVar*<0,.32,.07>*rand(Seed)) #break  // CMYKw
        #case(2) #declare ColLength=MagentaLength; (<.92,0,.56>+ColVar*<.08,0,.44>*rand(Seed )) #break  // CMYbw
        #case(3) #declare ColLength=YellowLength; (<1,.94,.07>+ColVar*<0,.06,-.07>*rand(Seed)) #break  // CMYKrgbW  
        //#case(4) <1,.94,.07>+ColVar*<0,.06,-.07>*rand(Seed) #break  // CMYw 
        //#case(5) #local ColCountMax=4; #break  // Orig to CMY
    #end 

#end// CMYw(ColMem, ColVarMem, Seed)

// Colour sorting macro ///////////////////////////////////////////////////////////////////////////////

#macro ColSort(ColSystem, ColCountMax, ColMem, ColVarMem, LengthMem, Seed)
 
                 #if (ColSystem=0)  // Colourize
                     Colourize(ColMem, ColVar, Seed); 
                     #local Col=Colour;
                     #local ColVar=ColVarMem;
                     #local Thickness=MinThickness+(rand(Seed)*(MaxThickness-MinThickness));
                     
                 #elseif(ColSystem=1)  // CMYKw
                 
                     CMYK(ColMem, ColVarMem, Seed) 
                     #switch(ColCount)
                        #case (0) 
                            #local Col=BlackCol; 
                            #local Thickness=MaxThickness*BlackLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(BlackLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=BlackLength*LengthMem; 
                            #end
                            #local ColVar=0; 
                        #break
                        #case (1) 
                            #local Col=MagentaCol; 
                            #local Thickness=MaxThickness*MagentaLength ;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(BlackLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=MagentaLength*LengthMem; 
                            #end
                            #local ColVar=0; 
                        #break
                        #case (2) 
                            #local Col=YellowCol; 
                            #local Thickness=MaxThickness*YellowLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(YellowLength*(MaxThickness-MinThickness));  
                                #local MaxLength=YellowLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                        #case (3) 
                            #local Col=WhiteCol; 
                            #local Thickness=MaxThickness*WhiteLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(WhiteLength*(MaxThickness-MinThickness));  
                                #local MaxLength=WhiteLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                        #case (4) 
                            #local Col=CyanCol; 
                            #local Thickness=MaxThickness*CyanLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(CyanLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=CyanLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                     
                     #end  
                 #elseif(ColSystem=2)   // CMYbw
                     CMYbw(ColMem, ColVarMem, Seed) 
                     #switch(ColCount)
                        #case (0) 
                            #local Col=BlackCol; 
                            #local Thickness=MaxThickness*BlackLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(BlackLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=BlackLength*LengthMem; 
                            #end
                            #local ColVar=0; 
                        #break
                        #case (1) 
                            #local Col=MagentaCol; 
                            #local Thickness=MaxThickness*MagentaLength ;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(BlackLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=MagentaLength*LengthMem; 
                            #end
                            #local ColVar=0; 
                        #break
                        #case (2) 
                            #local Col=YellowCol; 
                            #local Thickness=MaxThickness*YellowLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(YellowLength*(MaxThickness-MinThickness));  
                                #local MaxLength=YellowLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                        #case (3) 
                            #local Col=WhiteCol; 
                            #local Thickness=MaxThickness*WhiteLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(WhiteLength*(MaxThickness-MinThickness));  
                                #local MaxLength=WhiteLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                        #case (4) 
                            #local Col=CyanCol; 
                            #local Thickness=MaxThickness*CyanLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(CyanLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=CyanLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                     
                     #end
                #elseif(ColSystem=3)     // CMYKrgbW
                    CMYK(ColMem, ColVarMem, Seed) 
                     #switch(ColCount)
                        #case (0) 
                            #local Col=<0,1,0>; 
                            #local Thickness=MinThickness+(ColMem.y*(MaxThickness-MinThickness)); 
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(ColMem.y*(MaxThickness-MinThickness)); 
                                #local MaxLength=ColMem.y*LengthMem; 
                            #end
                            #local ColVar=0; 
                        #break 
                        #case (1) 
                            #local Col=<1,0,0>; 
                            #local Thickness=MinThickness+(ColMem.x*(MaxThickness-MinThickness)); 
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(ColMem.x*(MaxThickness-MinThickness)); 
                                #local MaxLength=ColMem.x*LengthMem; 
                            #end
                            #local ColVar=0; 
                        #break
                        #case (2) 
                            #local Col=<0,0,1>; 
                            #local Thickness=MinThickness+(ColMem.z*(MaxThickness-MinThickness)); 
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(ColMem.z*(MaxThickness-MinThickness)); 
                                #local MaxLength=ColMem.z*LengthMem; 
                            #end
                            #local ColVar=0; 
                        #break
                        #case (3) 
                            #local Col=BlackCol; 
                            #local Thickness=MaxThickness*BlackLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(BlackLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=BlackLength*LengthMem; 
                            #end
                            #local ColVar=0; 
                        #break
                        #case (4) 
                            #local Col=MagentaCol; 
                            #local Thickness=MaxThickness*MagentaLength ;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(BlackLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=MagentaLength*LengthMem; 
                            #end
                            #local ColVar=0; 
                        #break
                        #case (5) 
                            #local Col=YellowCol; 
                            #local Thickness=MaxThickness*YellowLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(YellowLength*(MaxThickness-MinThickness));  
                                #local MaxLength=YellowLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                        #case (6) 
                            #local Col=WhiteCol; 
                            #local Thickness=MaxThickness*WhiteLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(WhiteLength*(MaxThickness-MinThickness));  
                                #local MaxLength=WhiteLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                        #case (7) 
                            #local Col=CyanCol; 
                            #local Thickness=MaxThickness*CyanLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(CyanLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=CyanLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                        
                     #end
                 #elseif(ColSystem=4)
                    CMYw(ColMem, ColVarMem, Seed) 
                     #switch(ColCount)
                        #case (0) 
                            #local Col=MagentaCol; 
                            #local Thickness=MaxThickness*MagentaLength ;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(BlackLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=MagentaLength*LengthMem; 
                            #end
                            #local ColVar=0; 
                        #break
                        #case (1) 
                            #local Col=YellowCol; 
                            #local Thickness=MaxThickness*YellowLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(YellowLength*(MaxThickness-MinThickness));  
                                #local MaxLength=YellowLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                        #case (2) 
                            #local Col=WhiteCol; 
                            #local Thickness=MaxThickness*WhiteLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(WhiteLength*(MaxThickness-MinThickness));  
                                #local MaxLength=WhiteLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                        #case (3) 
                            #local Col=CyanCol; 
                            #local Thickness=MaxThickness*CyanLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(CyanLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=CyanLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                     
                     #end
                 #else  
                    CMYOrig(ColMem, ColVarMem, Seed) 
                     #switch(ColCount)
                        #case (0) 
                            #local Col=MagentaCol; 
                            #local Thickness=MaxThickness*MagentaLength ;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(BlackLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=MagentaLength*LengthMem; 
                            #end
                            #local ColVar=0; 
                        #break
                        #case (1) 
                            #local Col=YellowCol; 
                            #local Thickness=MaxThickness*YellowLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(YellowLength*(MaxThickness-MinThickness));  
                                #local MaxLength=YellowLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                        #case (2) 
                            #local Col=CyanCol; 
                            #local Thickness=MaxThickness*CyanLength;
                            #if(Thickness<.001) 
                                #local Thickness=MinThickness+(CyanLength*(MaxThickness-MinThickness)); 
                                #local MaxLength=CyanLength*LengthMem; 
                            #end 
                            #local ColVar=0; 
                        #break
                     
                     #end
                 #end 
                 
                 #declare ColSortCol=Col;
                 #declare ColSortThickness=Thickness;
                 #declare ColSortMaxLength=MaxLength;
                 #declare ColSortVar=ColVar;
 #end// #macro ColSort               

//-------------------Dripping Macro------------------------------------------------//

#macro Dripping (Object, DropPos, Col, ColMem, ColVar , Finnish, Brush, MaxLength, MinThickness, MaxThickness, Norm, Seed, Squiglyness, Threshold, Direct)

    #local TopStart=max_extent(Object) ;
    #local BottomEnd=min_extent(Object) ;  
     
     
    #local TopEnd=<BottomEnd.x,TopStart.y,BottomEnd.z>;
    #local BottomStart=<TopStart.x,BottomEnd.y,TopStart.z>;      
    #local FrontStart=<TopStart.x,TopStart.y,BottomEnd.z>;
    #local FrontEnd=BottomEnd;
    #local BackStart=TopStart;
    #local BackEnd=<BottomEnd.x,BottomEnd.y,TopStart.z>; 
    #local LeftStart=<BottomEnd.x,TopStart.y,TopStart.z>;
    #local LeftEnd=BottomEnd  ;
    #local RightStart=TopStart;
    #local RightEnd=<TopStart.x,BottomEnd.y,BottomEnd.z>;  
    #local ObjectMid=BottomEnd+(.5*(TopStart-BottomEnd)); 
    #local TopMid=<ObjectMid.x,TopStart.y,ObjectMid.z>;
    #local BottomMid=<ObjectMid.x,BottomEnd.y,ObjectMid.z>;  
    #local FrontMid=<ObjectMid.x,ObjectMid.y,BottomEnd.z>;  
    #local BackMid=<ObjectMid.x,ObjectMid.y,TopStart.z>;  
    #local LeftMid=<BottomEnd.x,ObjectMid.y,ObjectMid.z>;   
    #local RightMid=<TopStart.x,ObjectMid.y,ObjectMid.z>;    
    
    #local Count=0; 
    
    #local JumpX=MinThickness;
    #local JumpZ=MinThickness;
    #local JumpY=MinThickness; 
    #local Jump=MinThickness; 
    
    #local XCount=0;  
    #local YCount=0;
    #local ZCount=0; 
    
   
    #local Drip=0;  
    
    #local OrigDirection=Direction;
    
    #local Thickness=MaxThickness;
    
    #local Gravity=<0,-1,0>; 
   
    #local DropAngle=  (ObjectMid-DropPos);  
    
    #local RanDirect=(2*<.5-rand(Seed),.5-rand(Seed),.5-rand(Seed)>) ; //RandVect(Seed);     

    #if((Direct.x=0)*(Direct.y=0)*(Direct.z=0))
        #local Direction=(2*<.5-rand(Seed),.5-rand(Seed),.5-rand(Seed)>) ; //RandVect(Seed);
    #else
        #local Direction=Direct+Squiglyness*<sgn(Direct.x)*rand(Seed),sgn(Direct.y)*rand(Seed),sgn(Direct.z)*rand(Seed)>;
    #end
    
    #ifdef (Brushes)
         #undef Brushes
    #end 
    
    #local Splat=0;
    #if (Brush>0)
        #local Brushes= array[Brush]
        #local BrushCount=0;
        
        #while (BrushCount<Brush)
            #local Brushes[BrushCount]=(MaxThickness+(MinThickness*Brush))*RandVect(Seed);//<.5-rand(Seed),.5-rand(Seed),.5-rand(Seed)> ; //RandVect(Seed);
            
            #local BrushCount=BrushCount+1;
        #end
    #elseif(Brush<0)
        #local Splat=-Brush;
    #end
    
    
    #local BlobY=MinThickness + .5*(MaxThickness-MinThickness);

     //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
     
     
                 
        blob{threshold Threshold //2 //.1 
            #if((Brush<0)*(DropPos.y>MinThickness)) // * * * * * * * * * * * * * * * * *  **  \\
                        #local BrushCount=0;
                        
                        sphere {0,1,2 scale  MaxThickness Axial_Scale_Trans(Norm, MinThickness)  translate DropPos texture{pigment{color Col} finish{Finnish}} }
                        
                        #while (BrushCount>Brush)
                            #local RandVector= RandVect(Seed);
                            #local Norm1=<0,0,0>;
                            #local Scan= trace(Object, DropPos+(MaxThickness*<RandVector.x/abs(RandVector.x),RandVector.y/abs(RandVector.y),RandVector.z/abs(RandVector.z)>)+MinThickness*RandVector+Thickness*Direction,DropAngle,Norm1); 
                            #if (Scan.y>0)
                                sphere {0, 1,1 scale MinThickness*2 Axial_Scale_Trans(Norm, BlobY-(.5*(Norm.y-1)))   translate Scan  texture{pigment{color Col} finish{Finnish}} }
                            #end  
                            
                            #local BrushCount=BrushCount-1;
                        #end  
             #end   
             
             sphere {0,1,2 scale  Thickness  translate DropPos texture{pigment{color Col} finish{Finnish}} } 
              
             
             // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * 
             #if(Splat)
                 
                 #local SplatCount=0;
                 #local SplatPos=DropPos;
                 
                 #while(SplatCount<Splat)
                     
                     #local Direction=vnormalize(RandVect(Seed)-y*.7);
                     #local DropPos=SplatPos;
                     #local Count=0;
                     #local Thickness=MaxThickness;
                             
                     #while(Count<MaxLength)  
                     
                         #local Jump= Thickness*.3;//(MinThickness*1) + (Thickness/(Count+1)) ;
                         #local JumpX=Jump*.5*(Squiglyness+((1-Squiglyness)*(abs(Norm.y)>abs(Norm.x))*(abs(Norm.y)-abs(Norm.x))));
                         #local JumpZ=Jump*.5*(Squiglyness+((1-Squiglyness)*(abs(Norm.y)>abs(Norm.z))*(abs(Norm.y)-abs(Norm.z))));
                         #local JumpY=Jump*.5*(1-Squiglyness)*(1-abs(Norm.y));
                         #local DropMem=DropPos;
                          
                         #if ((Direction.x=0)*(Direction.y=-1)*(Direction.z=0)) 
                             #local DirectMem1=Direction;
                             #local Direction=vnormalize( Direction );
                             #if ((Direction.x=0)*(Direction.y=0)*(Direction.z=0)) 
                                 #warning concat("DirectMem is:",CRGBStr(DirectMem1, 5, 5) ,"\n")
                             #end
                         #end 
                                    
                         #local ScanPos=DropPos+Jump*vnormalize(Norm+( Direction ));                                
                         #local DropAngle=-Norm;
                         #local Norm=<0,0,0>;    
                         #local DropPos=  trace(Object, ScanPos,DropAngle,Norm);
                         
                         #if (DropPos.y<=0)
                             #local DropPos=  trace(Object, ScanPos,-DropAngle,Norm);   
                             #local DropAngle=-DropAngle;
                         #end  
                         
                         #if ((DropPos.y<=0)*(DropMem.y>MinThickness))
                             #local DropPos=DropMem;
                             #local Drip=1; 
                         #elseif(DropPos.y<=0)
                            #local Count=MaxLength+1;
                         #end  
                           
                         #if (DropPos.y>MinThickness)
                            sphere {0, 1,1 scale Thickness Axial_Scale_Trans(Norm, BlobY-(.5*(Norm.y-1)/2)) translate DropPos  texture{pigment{color Col} finish{Finnish}} }  
                            #if((Count>=MaxLength-2)*(DropPos.y>MinThickness))
                                sphere {0, 1,1 scale MaxThickness  translate DropPos  texture{pigment{color Col} finish{Finnish}} }
                            #end
                            
                            #if(Brush>0) // * * * * * * * * * * * * * * * * *  **  \\
                                #local BrushCount=0;
                                
                                #while (BrushCount<Brush)
                                
                                    #local Norm1=<0,0,0>;
                                    #local Scan= trace(Object, DropPos+Brushes[BrushCount]+Thickness*Direction,DropAngle,Norm1); 
                                    #if (Scan.y>0)
                                        sphere {0, 1,1 scale Jump  Axial_Scale_Trans(Norm, BlobY-(.5*(Norm1.y-1)/2)) translate Scan  texture{pigment{color Col} finish{Finnish}} }
                                    #end  
                                    
                                    #local BrushCount=BrushCount+1;
                                #end 
                            #end 
                            
                            //  * * * * * * * * * *  * * * * ** * * *  * * * * * \\
                            
                         #end
                       
                         #if ((Drip+(Norm.y<-.5))*(rand(Seed)<(.75+.25*Direction.y)))  // icicle
                              sphere {0, .5,1 scale Thickness Axial_Scale_Trans(Norm, BlobY-(.5*(Norm.y-1)/2)) translate DropPos  texture{pigment{color Col} finish{Finnish}} }
                                              
                              #if((Count<(MaxLength/2))*(rand(Seed)>.5))
                                  #local Count=Count+((MaxLength-Count)/2);
                              #end 
                              
                              #local Thickness=Thickness*.3;
                              #local MinThickness=Thickness*.3;
                              #local DropPos=DropPos-(y*MinThickness); 
                              
                              #while (Count<(MaxLength-1))
                                  #local Thickness=(MinThickness)+((Thickness-(MinThickness))*(1-((Count+1)/(MaxLength+1))));
                                  #local JumpY=Thickness/4;
                                  #local DropPos=DropPos-(y*JumpY); 
                                  #if (DropPos.y<0)
                                      sphere {0, 1,1 scale MaxThickness translate DropPos*<1,.5,1>  texture{pigment{color Col} finish{Finnish}} }
                                      sphere {0, 1,1 scale <MaxThickness,Thickness*2,MaxThickness> translate DropPos*<1,0,1>  texture{pigment{color Col} finish{Finnish}} }// pigment{rgb <1/Count,Count-1,Count*.1>}} 
                                      sphere {0, 1,1 scale <MaxThickness*10,BlobY,MaxThickness*10> translate DropPos*<1,0,1>  texture{pigment{color Col} finish{Finnish}} }
                                      #local Count=MaxLength+1;   
                                  #end
                                  sphere {0, 1,1 scale Thickness Axial_Scale_Trans(Norm, abs(Norm.y)) translate DropPos  texture{pigment{color Col} finish{Finnish}} }// pigment{rgb <1/Count,Count-1,Count*.1>}}
                                  #local Norm=(Norm-y)/2;
                                  #local Count=Count+1;  
                              #end
                         #end
                         
                         #local Drip=0; 
                         
                         #local Direction=vnormalize (Direction*((MaxLength+1)/(Count+1))); 
                         #local Col=((Col*((MaxLength*MaxLength)-(Count*Count)))+(ColMem*((Count*Count)+1)))/((MaxLength*MaxLength)+1); 
                         #local Thickness=MinThickness+(MaxThickness-MinThickness)* pow((1-((Count+1)/(MaxLength+1))),2) ;  
                        #local Count=Count+1; 
                         
                         
                     #end // #while(Count<MaxLength) 
                     
                 #local SplatCount=SplatCount+1;
                 
                 #end// #while(SplatCount<Splat)
             
             #end  // #if(Splat)
             
             /// // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * // = \\ * 
              
             #while(Count<MaxLength)  
             
                 #local Jump= Thickness*.4;//(MinThickness*1) + (Thickness/(Count+1)) ;
                 #local JumpX=Jump*.5*(Squiglyness+((1-Squiglyness)*(abs(Norm.y)>abs(Norm.x))*(abs(Norm.y)-abs(Norm.x))));
                 #local JumpZ=Jump*.5*(Squiglyness+((1-Squiglyness)*(abs(Norm.y)>abs(Norm.z))*(abs(Norm.y)-abs(Norm.z))));
                 #local JumpY=Jump*.5*(1-Squiglyness)*(1-abs(Norm.y));
                 #local DropMem=DropPos;
                 
                 #declare Squigly=<Squiglyness*Norm.y,Squiglyness*(1-Norm.y),Squiglyness*Norm.y>;   
                 
                 #if ((Direction.x=0)*(Direction.y=-1)*(Direction.z=0)) 
                     #local DirectMem1=Direction;
                     #local Direction=vnormalize( Direction+(Squigly*RandVect(Seed)) );  
                     
                     #if ((Direction.x=0)*(Direction.y=0)*(Direction.z=0)) 
                         #warning concat("DirectMem is:",CRGBStr(DirectMem1, 5, 5) ,"\n")
                     #end
                 #end 
                            
                 #local ScanPos=DropPos+Jump*vnormalize(Norm+( Direction+(Squigly*RandVect(Seed)) ));                                
                 #local DropAngle=-Norm;
                 #local Norm=<0,0,0>;    
                 #local DropPos=  trace(Object, ScanPos,DropAngle,Norm);
                 
                 #if (DropPos.y<=0)
                     #local DropPos=  trace(Object, ScanPos,-DropAngle,Norm);   
                     #local DropAngle=-DropAngle;
                 #end 
                 
                 #if ((DropPos.y<=0)*(DropMem.y>0))
                     #local DropPos=DropMem;
                     #local Drip=1; 
                 #elseif(DropPos.y<=0)
                    #local Count=MaxLength+1;
                 #end
                     
                 #if (DropPos.y>MinThickness)
                    sphere {0, 1,1 scale Thickness Axial_Scale_Trans(Norm, BlobY-(.5*(Norm.y-1)/2)) translate DropPos  texture{pigment{color Col} finish{Finnish}} }
                    
                    #if(Brush>0) // * * * * * * * * * * * * * * * * *  **  \\
                        #local BrushCount=0;
                        
                        #while (BrushCount<Brush)
                        
                            #local Norm1=<0,0,0>;
                            #local Scan= trace(Object, DropPos+Brushes[BrushCount]+Thickness*Direction,DropAngle,Norm1); 
                            #if (Scan.y>0)
                                sphere {0, 1,1 scale Jump  Axial_Scale_Trans(Norm, BlobY-(.5*(Norm1.y-1)/2)) translate Scan  texture{pigment{color Col} finish{Finnish}} }
                            #end  
                            
                            #local BrushCount=BrushCount+1;
                        #end  // #while (BrushCount<Brush)
                    #end  // #if(Brush>0) 
                    
                 #end // #if (DropPos.y>MinThickness)
                   
                 #if ((Drip+(Norm.y<-.5))*(rand(Seed)<(.75+.25*Direction.y)))  // icicle
                    sphere {0, .5,1 scale Thickness Axial_Scale_Trans(Norm, BlobY-(.5*(Norm.y-1)/2)) translate DropPos  texture{pigment{color Col} finish{Finnish}} }
                                      
                      #if((Count<(MaxLength/2))*(rand(Seed)>.5))
                          #local Count=Count+((MaxLength-Count)/2);
                      #end 
                      
                      #local Thickness=Thickness*.3;
                      #local MinThickness=Thickness*.3;
                      #local DropPos=DropPos-(y*MinThickness);  
                      
                      #while (Count<(MaxLength-1))
                          #local Thickness=(MinThickness)+((Thickness-(MinThickness))*(1-((Count+1)/(MaxLength+1))));
                          #local JumpY=Thickness/4;
                          #local DropPos=DropPos-(y*JumpY); 
                          #if (DropPos.y<Thickness)
                              sphere {0, 1,1 scale MaxThickness translate DropPos*<1,.5,1>  texture{pigment{color Col} finish{Finnish}} }
                              sphere {0, 1,1 scale <MaxThickness,Thickness*2,MaxThickness> translate DropPos*<1,0,1>  texture{pigment{color Col} finish{Finnish}} }// pigment{rgb <1/Count,Count-1,Count*.1>}} 
                              sphere {0, 1,1 scale <MaxThickness*10,BlobY,MaxThickness*10> translate DropPos*<1,0,1>  texture{pigment{color Col} finish{Finnish}} }
                              #local Count=MaxLength+1;   
                          #end
                          sphere {0, 1,1 scale Thickness Axial_Scale_Trans(Norm, abs(Norm.y)) translate DropPos  texture{pigment{color Col} finish{Finnish}} }// pigment{rgb <1/Count,Count-1,Count*.1>}}
                          #local Norm=(Norm-y)/2;
                          #local Count=Count+1;  
                      #end // #while (Count<(MaxLength-1))
                 #end  // #if ((Drip+(Norm.y<-.5))*(rand(Seed)<(.75+.25*Direction.y)))  // icicle
                 
                 #local Drip=0; 
                 #local Direction=vnormalize (Direction*((MaxLength+1)/(Count+1)) + Squiglyness*RanDirect *((Count+1)/(MaxLength+1))); 
                 #local Col=((Col*((MaxLength*MaxLength)-(Count*Count)))+(ColMem*((Count*Count)+1)))/((MaxLength*MaxLength)+1); 
                 #local Thickness=MinThickness+(MaxThickness-MinThickness)*(1-((Count+1)/(MaxLength+1))) ;  
                 #local Count=Count+1; 
                 
             #end  // #while(Count<MaxLength) 
             
            }// blob 
            
            #ifdef(Brushes)
                     #undef Brushes
            #end 
             

#end // macro Dripping    

///////////////////////////////////////
//---------------------------------------------------------------------------------

//******************************************************************************////

//-------------------Drip Macro------------------------------------------------//

#macro PaintNX (Object, ColMap, CamPos, CamLook, CamDirect, CamWidth, CamHeight, ColPig, ColVar , Finnish, Brush,Spacing, MaxDrops, MaxLength, MinThickness, MaxThickness, Merge, Seed, Squiglyness, ColSystem, Threshold, Direction, ContainerStart,ContainerEnd)

    #declare Pigment=pigment {
                          image_map { png ColMap }//once  }
                          translate -0.5*(x+y) // center on the origin   
                          scale <CamWidth/CamHeight,1,1>*2
                          translate CamDirect
                          Reorient_Trans(z, (CamLook-CamPos)) 
                          translate CamPos
                          } // end of plane ------------------------------------------
    
 //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////   
#declare ColMapPig=pigment {
                          image_map {png ColMap }//once   }
                          translate -0.5*(x+y) // center on the origin   
                          scale <CamWidth/CamHeight,1,1>*2
                          } // end of plane ------------------------------------------

#declare CamColours=box{<-CamWidth/CamHeight,-1,CamDirect.z>,<CamWidth/CamHeight,1,CamDirect.z+0.001>   
                        texture {
                                pigment {ColMapPig}
                                finish { ambient 1 diffuse 1}
                                }
                       translate CamDirect
                       Reorient_Trans(z, (CamLook-CamPos)) 
                       translate CamPos
                       } 
                              
//////////////////////////////////// *********************************************************** \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
  
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////   
 
    #if ((ContainerStart.x=0)*(ContainerStart.y=0)*(ContainerStart.z=0)*(ContainerEnd.x=0)*(ContainerEnd.y=0)*(ContainerEnd.z=0)) 
        #local TopStart= max_extent(CamColours); 
        #local BottomEnd=min_extent(CamColours) ;  
    #else  
        #local Container=box{ContainerStart,ContainerEnd}
        #local TopStart=max_extent(Container) ;
        #local BottomEnd=min_extent(Container) ; 
    #end      
    
    #local ObjectSize=(TopStart-BottomEnd);
    #local TopEnd=<BottomEnd.x,TopStart.y,BottomEnd.z>;
    #local BottomStart=<TopStart.x,BottomEnd.y,TopStart.z>;      
    #local FrontStart=<TopStart.x,TopStart.y,BottomEnd.z>;
    #local FrontEnd=BottomEnd;
    #local BackStart=TopStart;
    #local BackEnd=<BottomEnd.x,BottomEnd.y,TopStart.z>; 
    #local LeftStart=<BottomEnd.x,TopStart.y,TopStart.z>;
    #local LeftEnd=BottomEnd  ;
    #local RightStart=TopStart;
    #local RightEnd=<TopStart.x,BottomEnd.y,BottomEnd.z>;  
    #local ObjectMid=BottomEnd+(.5*(TopStart-BottomEnd)); 
    #local TopMid=<ObjectMid.x,TopStart.y,ObjectMid.z>;
    #local BottomMid=<ObjectMid.x,BottomEnd.y,ObjectMid.z>;  
    #local FrontMid=<ObjectMid.x,ObjectMid.y,BottomEnd.z>;  
    #local BackMid=<ObjectMid.x,ObjectMid.y,TopStart.z>;  
    #local LeftMid=<BottomEnd.x,ObjectMid.y,ObjectMid.z>;   
    #local RightMid=<TopStart.x,ObjectMid.y,ObjectMid.z>;    
    #local Count=0; 
    #local DropPos=<0,0,0>;  
    #local Jump=Spacing; 
    #local MaxX=sqrt(MaxDrops);
    #local MaxY=sqrt(MaxDrops);  
    #local MaxZ=abs(BottomEnd.z-TopStart.z)/Jump;  
    #local Max=MaxDrops/2;
    #local XCount=0;  
    #local YCount=0;
    #local ZCount=0; 
    #local Count=0;  
    #local CamCount=0;  
    #local ColCount=0;
    #local Hit=0;
    #local HitCount=0; 
    #local MissCount=0;
    #local Gravity=<0,-1,0>; 
 
    #if(Merge)
        merge{
    #else    
        union{
    #end 
    
    #local ColVarMem=ColVar;
    #local LengthMem=MaxLength;
    
    #switch(ColSystem)
        #case(0) #local ColCountMax=1; #break  // Colourize
        #case(1) #local ColCountMax=5; #break  // CMYKw
        #case(2) #local ColCountMax=4; #break  // CMYbw
        #case(3) #local ColCountMax=4; #break  // CMYw 
        #case(4) #local ColCountMax=4; #break  // Orig to CMY
    #end
    
    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
              /////////////////////////////////////////////////////////////////////////////////////////////////////////////
         
         #if ((CamPos.x!=0)+(CamPos.y!=0)+(CamPos.z!=0))// From CamPos///////////////////////////////////////////////////////
         
             #while ((XCount<=MaxX))// /////////////////////////////////////////////////////////////////////////
                
                 #while(YCount<=MaxY) // Scan Opposite directions  
                      #while (ColCount<ColCountMax)
                         
                         #local LookPos=BottomEnd-ObjectSize*.1+<(1.5*ObjectSize.x)*rand(Seed), (1.5*ObjectSize.y)*rand(Seed), (1.5*ObjectSize.z)*rand(Seed)>; 
                         
                         ///////////////// Camlook Direction  //////////////////////////////////////////////////////////////////
                         #local DropAngle= vnormalize(LookPos-CamPos);
                         #if (ColSystem!=1) #local Thickness=MinThickness+(rand(Seed)*(MaxThickness-MinThickness));#end  
                         #local Norm=<0,0,0>;
                         #local DripPos=  trace(Object, CamPos,DropAngle,Norm); 
                         #if (DripPos.y = 0)
                             #local DripPos=  trace(Object, DropPos,-DropAngle,Norm); 
                         #end
                         #if (DripPos.y > 0)
                            #local DropPos=DripPos; 
                            #local NormCol=<0,0,0>;
                            #local PigScan=trace(CamColours,CamPos,vnormalize(DropPos-CamPos),NormCol);   
                            // ************ =========== =*=*=*=*=*=*=*=*  * * * * * *!!!!!!* * * * * *\\\\\\\\\\\\\\\\        
                            #if ((ColPig.red<0)*(ColPig.green<0)*(ColPig.blue<0))
                                #local Col=eval_pigment(Pigment,PigScan);  
                            #else
                                #local Col=ColPig;
                            #end
                            
                            #local ColMem=Col;  
                            #local ThickMem=Thickness;
                            
                            #switch(ColSystem)
                                #case(0) #local Colours=(ColourizeCMY(Col, ColVar, Seed)); #break  // Colourize
                                #case(1) #local Colours=(CMYK(Col, ColVar, Seed, ColCount));  #break  // CMYKw
                                #case(2) #local Colours=(CMYbw(Col, ColVar, Seed, ColCount));  #break  // CMYbw
                                #case(3) #local Colours=(CMYw(Col, ColVar, Seed, ColCount));  #break  // CMYKrgbW  
                                #case(4) #local Colours=(CMYOrig(Col, ColVar, Seed, ColCount));  #break  // CMYw 
                                #case(5) #local Colours=Col;  #break  // Orig to CMY
                            #end
                            
                            #ifndef (ThicknessRem)
                                #local ThicknessRem=Thickness;
                            #end 
                            
                            #local Thickness=MinThickness+ColLength*(ThicknessRem-MinThickness);
                               
                            Dripping (Object, DripPos, Colours, ColMem, ColVar ,Finnish, Brush, MaxLength, MinThickness, Thickness, Norm, Seed, Squiglyness, Threshold, Direction)  
                            
                            #local Thickness=ThickMem;
                         #end // #if (DripPos.y > 0)
                         
                         #if ( vlength(DripPos-LookPos) <= MaxThickness) 
                             #local YCount=YCount+1;
                         #end
                         
                         ///////////////// Rand to Centre direction //////////////////////////////////////////////////////////////////
                         #local DropAngle= vnormalize(LookPos-ObjectMid);
                         #local Thickness=MinThickness+(rand(Seed)*(MaxThickness-MinThickness));  
                         #local Norm=<0,0,0>;
                         #local DripPos=  trace(Object, CamPos,DropAngle,Norm); 
                         
                         #if (DripPos.y > 0)
                            #local DropPos=DripPos; 
                            #local NormCol=<0,0,0>;
                            #local PigScan=trace(CamColours,CamPos,vnormalize(DropPos-CamPos),NormCol);   
                            
                            #if ((ColPig.red<0)*(ColPig.green<0)*(ColPig.blue<0))
                                #local Col=eval_pigment(Pigment,PigScan);  
                            #else
                                #local Col=ColPig;
                            #end
                            
                            #local ColMem=Col;  
                            #local ThickMem=Thickness;
                            
                            #switch(ColSystem)
                                #case(0) #local Colours=(ColourizeCMY(Col, ColVar, Seed)); #break  // Colourize
                                #case(1) #local Colours=(CMYK(Col, ColVar, Seed, ColCount));  #break  // CMYKw
                                #case(2) #local Colours=(CMYbw(Col, ColVar, Seed, ColCount));  #break  // CMYbw
                                #case(3) #local Colours=(CMYw(Col, ColVar, Seed, ColCount));  #break  // CMYKrgbW  
                                #case(4) #local Colours=(CMYOrig(Col, ColVar, Seed, ColCount));  #break  // CMYw 
                                #case(5) #local Colours=Col;  #break  // Orig to CMY
                            #end                    
                            
                            #ifndef (ThicknessRem)
                                #local ThicknessRem=Thickness;
                            #end 
                            
                            #local Thickness=MinThickness+ColLength*(ThicknessRem-MinThickness);
                            
                            Dripping (Object, DripPos, Colours, ColMem, ColVar ,Finnish, Brush, MaxLength, MinThickness, Thickness, Norm, Seed, Squiglyness, Threshold, Direction)  
                            
                            #local Thickness=ThickMem; 
                            
                         #end // #if (DripPos.y > 0)
                         
                         #if ( vlength(DripPos-LookPos) <= MaxThickness) 
                             #local YCount=YCount+1;
                         #end
                         
                         ///////////////// Rand to outside direction //////////////////////////////////////////////////////////////////
                         #local DropAngle= vnormalize(ObjectMid-LookPos);
                         #local Thickness=MinThickness+(rand(Seed)*(MaxThickness-MinThickness));  
                         #local Norm=<0,0,0>;
                         #local DripPos=  trace(Object, CamPos,DropAngle,Norm);  
                         
                         #if (DripPos.y > 0)
                            #local DropPos=DripPos;   
                            #local NormCol=<0,0,0>;
                            #local PigScan=trace(CamColours,CamPos,vnormalize(DropPos-CamPos),NormCol);   
                            
                            #if ((ColPig.red<0)*(ColPig.green<0)*(ColPig.blue<0))
                                #local Col=eval_pigment(Pigment,PigScan);  
                            #else
                                #local Col=ColPig;
                            #end
                            
                            #local ColMem=Col;  
                            #local ThickMem=Thickness;
                            
                            #switch(ColSystem)
                                #case(0) #local Colours=(ColourizeCMY(Col, ColVar, Seed)); #break  // Colourize
                                #case(1) #local Colours=(CMYK(Col, ColVar, Seed, ColCount));  #break  // CMYKw
                                #case(2) #local Colours=(CMYbw(Col, ColVar, Seed, ColCount));  #break  // CMYbw
                                #case(3) #local Colours=(CMYw(Col, ColVar, Seed, ColCount));  #break  // CMYKrgbW  
                                #case(4) #local Colours=(CMYOrig(Col, ColVar, Seed, ColCount));  #break  // CMYw 
                                #case(5) #local Colours=Col;  #break  // Orig to CMY
                            #end                  
                            
                            #ifndef (ThicknessRem)
                                #local ThicknessRem=Thickness;
                            #end 
                            
                            #local Thickness=MinThickness+ColLength*(ThicknessRem-MinThickness);
                            
                            Dripping (Object, DripPos, Colours, ColMem, ColVar ,Finnish, Brush, MaxLength, MinThickness, Thickness, Norm, Seed, Squiglyness, Threshold, Direction) 
                            
                            #local Thickness=ThickMem; 
                            
                         #end // #if (DripPos.y > 0)
                         
                         #if ( vlength(DripPos-LookPos) <= MaxThickness) 
                             #local YCount=YCount+1;
                         #end
                         
                         ///////////////// Rand to -y direction //////////////////////////////////////////////////////////////////
                         #local DropAngle= -y;
                         #local Thickness=MinThickness+(rand(Seed)*(MaxThickness-MinThickness));  
                         #local Norm=<0,0,0>;
                         #local DripPos=  trace(Object, CamPos,DropAngle,Norm); 
                         #if (DripPos.y > 0)
                            #local DropPos=DripPos;
                            #local NormCol=<0,0,0>;
                            #local PigScan=trace(CamColours,CamPos,vnormalize(DropPos-CamPos),NormCol);   
                            
                            #if ((ColPig.red<0)*(ColPig.green<0)*(ColPig.blue<0))
                                #local Col=eval_pigment(Pigment,PigScan);  
                            #else
                                #local Col=ColPig;
                            #end
                            
                            #local ColMem=Col; 
                            #local ThickMem=Thickness;
                              
                            #switch(ColSystem)
                                #case(0) #local Colours=(ColourizeCMY(Col, ColVar, Seed)); #break  // Colourize
                                #case(1) #local Colours=(CMYK(Col, ColVar, Seed, ColCount));  #break  // CMYKw
                                #case(2) #local Colours=(CMYbw(Col, ColVar, Seed, ColCount));  #break  // CMYbw
                                #case(3) #local Colours=(CMYw(Col, ColVar, Seed, ColCount));  #break  // CMYKrgbW  
                                #case(4) #local Colours=(CMYOrig(Col, ColVar, Seed, ColCount));  #break  // CMYw 
                                #case(5) #local Colours=Col;  #break  // Orig to CMY
                            #end                    
                            
                            #ifndef (ThicknessRem)
                                #local ThicknessRem=Thickness;
                            #end 
                            
                            #local Thickness=MinThickness+ColLength*(ThicknessRem-MinThickness);
                            
                            Dripping (Object, DripPos, Colours, ColMem, ColVar ,Finnish, Brush, MaxLength, MinThickness, Thickness, Norm, Seed, Squiglyness, Threshold, Direction) 
                            
                            #local Thickness=ThickMem;
                         #end // #if (DripPos.y > 0)
                         
                         #if ( vlength(DripPos-LookPos) <= MaxThickness) 
                             #local YCount=YCount+1;
                         #end
                         
                         ///////////////// Rand to z direction //////////////////////////////////////////////////////////////////
                         #local DropAngle= z;
                         #local Thickness=MinThickness+(rand(Seed)*(MaxThickness-MinThickness));  
                         #local Norm=<0,0,0>;
                         #local DripPos=  trace(Object, CamPos,DropAngle,Norm); 
                         #if (DripPos.y > 0)
                            #local DropPos=DripPos; 
                            #local NormCol=<0,0,0>;
                            #local PigScan=trace(CamColours,CamPos,vnormalize(DropPos-CamPos),NormCol);   
                            
                            #if ((ColPig.red<0)*(ColPig.green<0)*(ColPig.blue<0))
                                #local Col=eval_pigment(Pigment,PigScan);  
                            #else
                                #local Col=ColPig;
                            #end
                            
                            #local ColMem=Col; 
                            #local ThickMem=Thickness;
                      
                            #switch(ColSystem)
                                #case(0) #local Colours=(ColourizeCMY(Col, ColVar, Seed)); #break  // Colourize
                                #case(1) #local Colours=(CMYK(Col, ColVar, Seed, ColCount));  #break  // CMYKw
                                #case(2) #local Colours=(CMYbw(Col, ColVar, Seed, ColCount));  #break  // CMYbw
                                #case(3) #local Colours=(CMYw(Col, ColVar, Seed, ColCount));  #break  // CMYKrgbW  
                                #case(4) #local Colours=(CMYOrig(Col, ColVar, Seed, ColCount));  #break  // CMYw 
                                #case(5) #local Colours=Col;  #break  // Orig to CMY
                            #end                   
                            
                            #ifndef (ThicknessRem)
                                #local ThicknessRem=Thickness;
                            #end 
                            
                            #local Thickness=MinThickness+ColLength*(ThicknessRem-MinThickness);
                            
                            Dripping (Object, DripPos, Colours, ColMem, ColVar ,Finnish, Brush, MaxLength, MinThickness, Thickness, Norm, Seed, Squiglyness, Threshold, Direction) 
                            
                            #local Thickness=ThickMem; 
                            
                         #end // #if (DripPos.y > 0)
                         
                         #if ( vlength(DripPos-LookPos) <= MaxThickness) 
                             #local YCount=YCount+1;
                         #end
                         //-----------------------------------------
                         #local MaxLength=LengthMem; 
                         #local ColCount=ColCount+1;  
                         
                       #end // #while (ColCount<ColCountMax)   
                       
                       #local ColCount=0;  
                       
                       #local YCount=YCount+1; 
                       
                 #end // #while(YCount<=MaxY) 
                  
                 #local YCount=0; 
                 #local Hit=0;
                 
                 
                 #local XCount=XCount+1;    
                 
             #end // #while ((XCount<=MaxX))  
             
         #local XCount=0;  
         
         #end//  #if ((CamPos.x!=0)+(CamPos.y!=0)+(CamPos.z!=0)) 
        
        
    }
#end // #macro Drips    

