//wineglass with red wine   

#local I_Glass1 =interior{ior 1.45 caustics 2 fade_distance 40 fade_power 1}
#local I_Glass2 =interior{fade_distance 1.5 fade_power 1 ior 1.45 caustics 2}
#local I_Glass3 =interior{ior 1.51 caustics 2 fade_distance 0.025 fade_power 1}
#local I_Glass4 =interior{ior 1.51 caustics 2 fade_distance 1.5 fade_power 1}
#local I_Glass5 = interior{ior 1.51 caustics 2 fade_distance 3.25 fade_power 1}

#local T_Glass = texture {pigment { color red 1.0 green 1.0 blue 1.0 filter 0.95 }
   finish{ambient 0.0 diffuse 0.0 reflection 0.1 phong 0.3 phong_size 90}}

#local Wine = color red 1.0 filter 0.85;

#local Liquid = finish { reflection 0.05 }

#local Bead = object {   sphere { <0, 0, 0>, 1 scale <1.65, 0.65, 1.65> }  
          texture {T_Glass} interior {I_Glass2} }

#local Rim = torus {0.975, 0.025   clipped_by { plane { -y, 0.0 } }   scale <15.0, 10.0, 15.0> 
   translate 24.0*y   texture {T_Glass}   interior{I_Glass3}}

#local Top = intersection {
   plane { y, 1.0  }
   object { QCone_Y }
   object { QCone_Y scale <0.97, 1.0, 0.97> inverse }

   clipped_by { plane { y, 0.0  inverse } }
   scale <15.0, 10.0, 15.0>   translate 14.0*y
   texture { T_Glass}   interior {I_Glass4}}

#local Stem = cylinder { y*3.25, y*14, 1  texture { T_Glass}  interior {I_Glass4}}


#local Base = object {QCone_Y clipped_by { plane { y, 0.0  }  plane { y, -1.0 inverse }   }
   translate 1.0*y         /* This actually puts the base of the cone on y=0*/
   scale <12.0, 3.25, 12.0>   texture { T_Glass}   interior { I_Glass5}}

#local Wine2 =
union {   cone { 0, 0, y, 0.95 open
      texture { finish { Liquid }  pigment { Wine }}   }

   disc { y, y, 0.95 
       texture {finish {Liquid specular 1 roughness 0.01 } pigment{ Wine }
         normal { onion 0.75 frequency 3 sine_wave turbulence 0.15 }}
      interior { I_Glass1}}

   scale <14.9, 9.5, 14.9>  translate 14.0*y texture{finish{Liquid} pigment{Wine}}
   interior { I_Glass1}}


#declare WineGlass_Without_Wine = merge {
   object { Rim   }
   object { Top   }
   object { Bead  translate 14.5*y }
   object { Bead  translate 10.0*y }
   object { Bead  translate  7.0*y }
   object { Bead  translate  3.0*y }
   object { Stem  }
   object { Base  }
   scale <1.0, 1.50, 1.0>}

#declare WineGlass_With_Wine = union {   object { WineGlass_Without_Wine }
   object { Wine2  scale <1.0, 1.50, 1.0>   } }



