//include file for stonechurch.pov
//By Richard S Morehouse
#include "candle.inc" 
#include "bread.inc"
#include "wineglass.inc"
#include "churchwindow.inc"
#local Mywood1 = texture{T_Wood7 scale 2 rotate y*91 } 
#local Mywood2 = texture{T_Wood7 scale 2 rotate y*89 } 
#local Mywood3 = texture{T_Wood7 scale 2 rotate y*1  } 
#local Mywood4 = texture{T_Wood7 scale 2 rotate y*-1 } 
#local Mywood5 = texture{T_Wood7 scale 2 rotate <0,90,1> } 
#local Mywood6 = texture{T_Wood7 scale 2 rotate <0,90,-1>} 
 
//pews
//each piece is a wood texture rotated differently to simulate furniture being made out of pieces
#local Pew =union{ 
//seatback
union{ box {<-50,-4,-.5> ,<50,3,.5> translate <0,3,0> texture {Mywood1} finish {Shiny}}
       box {<-50,-3,-.5> ,<50,3,.5> translate <0,9,0> texture {Mywood2} finish {Shiny}}
       box {<-50,-3,-.5> ,<50,3,.5> translate <0,15,0> texture {Mywood1} finish {Shiny}}
       rotate <-15,0,0> translate <0,18,0>}              
//seat       
 box{<-50,-.5,-3>,<50,.5,3> translate <0,18.5,3> texture {Mywood5} finish {Shiny}}
 box{<-50,-.5,-3>,<50,.5,3> translate <0,18.5,9> texture {Mywood6} finish {Shiny}}
 box{<-50,-.5,-3>,<50,.5,3> translate <0,18.5,15> texture {Mywood5} finish {Shiny}}
//left leg
 box{<-.5,-3,-9>,<.5,3,9> translate <-40,3,9> texture {Mywood3} finish {Shiny}}
 box{<-.5,-3,-9>,<.5,3,9> translate <-40,9,9> texture {Mywood4} finish {Shiny}}
 box{<-.5,-3,-9>,<.5,3,9> translate <-40,15,9> texture {Mywood3} finish {Shiny}} 
//right leg 
 box{<-.5,-3,-9>,<.5,3,9> translate <40,3,9> texture {Mywood3} finish {Shiny}}
 box{<-.5,-3,-9>,<.5,3,9> translate <40,9,9> texture {Mywood4} finish {Shiny}}
 box{<-.5,-3,-9>,<.5,3,9> translate <40,15,9> texture {Mywood3} finish {Shiny}} 
//scoot it forward a bit  
  translate <0,0,6>}
//altar
#local Altar=union{   
 box{<-1,-15,-9>,<1,15,9> translate <-36,15,9> texture {Mywood3} finish {Shiny}}
 box{<-1,-15,-9>,<1,15,9> translate <36,15,9> texture {Mywood4} finish {Shiny}}
 union{
 box{<-48,-.5,-3>,<48,.5,3> translate <0,2.5,-12> texture {Mywood6} finish {Shiny}}
 box{<-48,-.5,-3>,<48,.5,3> translate <0,2.5,-6> texture {Mywood5} finish {Shiny}}
 box{<-48,-.5,-3>,<48,.5,3> translate <0,2.5,0> texture {Mywood6} finish {Shiny}}
 box{<-48,-.5,-3>,<48,.5,3> translate <0,2.5,6> texture {Mywood5} finish {Shiny}}  
 box{<-48,-.5,-3>,<48,.5,3> translate <0,2.5,12> texture {Mywood6} finish {Shiny}} 
 
 box {<-48,-3,-.5>,<48,3,.5> translate <0,0,14.5> texture {Mywood1} finish {Shiny}} 
 box {<-48,-3,-.5>,<48,3,.5> translate <0,0,-14.5> texture {Mywood2} finish {Shiny}} 
 
 box {<-.5,-3,-15>, <.5,3,15> translate <-47.5,0,0> texture {Mywood3} finish {Shiny}}   
 box {<-.5,-3,-15>, <.5,3,15> translate <47.5 ,0,0> texture {Mywood4} finish {Shiny}}   

 box{<-48,-.5,-3>,<48,.5,3> translate <0,-2.5,-12> texture {Mywood6} finish {Shiny}}
 box{<-48,-.5,-3>,<48,.5,3> translate <0,-2.5,-6> texture {Mywood5} finish {Shiny}}
 box{<-48,-.5,-3>,<48,.5,3> translate <0,-2.5,0> texture {Mywood6} finish {Shiny}}
 box{<-48,-.5,-3>,<48,.5,3> translate <0,-2.5,6> texture {Mywood5} finish {Shiny}}  
 box{<-48,-.5,-3>,<48,.5,3> translate <0,-2.5,12> texture {Mywood6} finish {Shiny}}
translate <0,33,0>}
} 
//candlesticks
#local CandleStick= union{object {candle translate <0,7,0>}
union{cone{<0,0,0>,3, <0,1,0>,.5}
cylinder {<0,0,0>,<0,5,0>,.5}   
difference{ cone{<0,5,0>,.5 ,<0,7,0>,2}
torus {1.2,.6 translate<0,7,0>}} 
sphere {<0,3,0>,1}
texture {Polished_Chrome}} }
//altar cross
#local AltarCross=  union{
cone {<0,0,0>,3,<0,1,0>,.25}
cone {<0,1,0>,.25,<0,17,0>,1}
cone {<0,17,0>,1,<0,25,0>,0}
cone {<-8,17,0>,0,<0,17,0>,1}
cone {<0,17,0>,1,<8,17,0>,0}
union{
cone {<0,0,0>,.5,<0,-4,0>,0} 
cone {<0,0,0>,.5,<0,4,0>,0}
cone {<0,0,0>,.5,<4,0,0>,0}
cone {<0,0,0>,.5,<-4,0,0>,0}  
rotate z*45 translate<0,17,0>}
texture {Polished_Chrome}} 

#local WallCross=  intersection{box{<-8,25,-1> <8,0,0>} 
union{
cone {<0,0,0>,0,<0,17,0>,1}
cone {<0,17,0>,1,<0,25,0>,0}
cone {<-8,17,0>,0,<0,17,0>,1}
cone {<0,17,0>,1,<8,17,0>,0}
 }
  scale 8 }

#local TWall=texture{T_Stone9 scale 4}
#local WallPanel=union{ 
difference{box{<-18,0,-3>,<18,192,3>} object{WindowShape}texture{TWall}}
object{WindowFrame pigment{Tan}}
object{WindowGlass  texture{T_Glass3} interior{I_Glass}}
 }
#local WallPanel2=union{
difference{box{<-18,96,-3>,<18,192,3>} object{WindowShape2}texture{TWall}}
object{WindowFrame2 pigment{Tan}}
object{WindowGlass2  texture{T_Glass3} interior{I_Glass}}
 }

#local WallCorner=box{<-3,0,-3>,<3,192,3> texture {TWall}}
#local RoofWall = prism{linear_sweep linear_spline -3,3,4 ,<-150,192>,<0,304.5>,<150,192>,<-150,192> rotate x*-90 }
#local  Sidewall = union{ 
#local z1=-342;
#while (z1 <=342) 
object{WallPanel rotate  y*90  translate <0,0,z1>} 
#local z1=z1+36;
#end
}     

#local BackWall= union{
object{RoofWall texture {TWall}}
box{<-108,0,-3>,<108,192,3> texture {TWall}}
object{WallPanel translate x*-126}
object{WallPanel translate x*126}
object{WallCorner translate x*147}
object{WallCorner translate x*-147}
}

#local FrontWall=union{
difference{object {RoofWall } object{RoundWindowHole} texture{TWall}  }
object{RoundWindowGlass translate y*244}
object{RoundWindowFrame translate y*244 pigment{Tan}}
object{WallPanel translate x*-126}
object{WallPanel translate x*126}
object{WallPanel translate x*-90}
object{WallPanel translate x*90}
object{WallPanel translate x*-54}
object{WallPanel translate x*54}
object{WallPanel2 translate x*-18}
object{WallPanel2 translate x*18}
object{WallCorner translate x*147}
object{WallCorner translate x*-147}
}
#local Roof =prism{linear_sweep linear_spline -366,366, 7 <-148,192>,<-150,192>,<0,304.5>,<150,192>,<148,192> <0,303>,<-148,192> rotate x*-90}
#local SideWallTop=prism{linear_sweep linear_spline -366,366,4 <-2,0><2,3> <2,0>,<-2,0> rotate x*-90 texture {TWall}}
//doors
#local DoorHandle=union {torus{4,1 translate<0,36,0> } torus{4,1 translate <0,72,0>} cylinder {<0,36,-4> <0,72,-4>,1 }cylinder {<0,36,4> <0,72,4>,1 }}
#local LeftDoor=union {box{<0,0,0><36,96,0>}object {DoorHandle translate <30,0,0>} texture{pigment{Tan}}}
#local RightDoor=union {box{<-36,0,0><0,96,0>}object {DoorHandle translate <-30,0,0>} texture{pigment{Tan}}}

#local Rafters = union {cylinder {<-148,192,0> <0,303,0>,2 } cylinder {<0,303,0> <148,192,0>,2}}
#local Beam= cylinder{<0,0,-360> <0,0,360>,2 }
#local Framework= union{
#local z1=-9;
#while (z1 <=9)
object{Rafters translate<0,0,z1*36>}
#local z1=z1+1;
#end
object {Beam translate<0,303,0>}
pigment{Tan}
}

#local Floor=box{<-144,0,-360>,<144,.1,360> texture{checker texture {T_Stone35},texture{T_Stone21} scale 36} }
#local Cross = union{
cylinder {<0,0,0> <0,100,0>,2}
cylinder {<-40,75,0> <40,75,0>,2}
sphere {<0,100,0>,2}
sphere {<-40,75,0>,2}
sphere {<40,75,0>,2}
pigment{Tan}}
      

#local chspokes= union{
object{candle translate<-36,2,0>}
object{candle translate<36,2,0>}
cone{<36,1,0>,.5,<36,2,0>,3 texture{Polished_Chrome}}   
cone{<-36,1,0>,.5,<-36,2,0>,3 texture{Polished_Chrome}}   
cylinder {<-36,0,0>,<36,0,0>,.5 texture {pigment{Tan}} }
}
#local Chandelier= union{
torus {36,1 texture {pigment{Tan}} }   
object{chspokes}
object{chspokes rotate y*45}
object{chspokes rotate y*90}
object{chspokes rotate y*135}
}
  
#local candleholder= union {
object{candle translate <9,1,0>}
cone{<9,0,0>,.5,<9,1,0>,3 texture{Polished_Chrome}} 
 difference {
    torus { 4, .5  rotate -90*x }
    box { <-5, 5, -1>, <5, 0, 1> }
 translate <5,0,0> texture{Polished_Chrome} } 
 }

#declare StoneChurch =union{
object {Floor} 
object{Framework}
object{Sidewall translate <-147,0,0>}
object{Sidewall translate <147,0,0>}
object {FrontWall translate<0,0,-363>}
object {BackWall translate<0,0,363>}
object {Roof texture{pigment{White}}}
object {SideWallTop translate <-146,192,0>}
object {SideWallTop rotate y*180 translate <146,192,0>}
#local z1=-9;
#while (z1 <=9)
object {candleholder rotate y*180 translate <145,96,z1*36> }  
object {candleholder translate <-145,96,z1*36>}  
#local z1=z1+1;
#end   

#local z1=-288;
#while (z1 <=288)
cylinder {<72,144,z1> ,<72,246,z1>,0.5 texture {pigment{Tan}}}
object {Chandelier translate <72,144,z1>}
cylinder {<-72,144,z1>, <-72,246,z1>,0.5 texture {pigment{Tan}} }
object {Chandelier translate <-72,144,z1>}
#local z1=z1+288;
#end

object{Cross translate <0,300,-360>}
object {LeftDoor rotate y*120 translate <-36,0,-360>}
object {RightDoor rotate y*240 translate <36,0,-360>}

#local Z1= 0;
#while (Z1 <= 14)
object {Pew translate <-90,0,-360+Z1*36>}
object {Pew translate <90,0,-360+Z1*36>}
#local Z1=Z1+1; 
#end

object {Altar translate <0,0,288>}
object{CandleStick translate <-36,36,288>}
object{CandleStick translate < 36,36,288>}
object {WineGlass_With_Wine  scale .25 translate <-10, 36, 288>}     
//object{AltarCross translate < 0,36,298>}
object{BreadOnPlate scale 12 translate <16,36,288>}
object{WallCross translate <0,75,360> texture{Polished_Chrome}}
}