//Candles using media and area lights
//By Richard Morehouse

#local CFbottom= intersection{sphere {<0,0,0>,1} box{<-1,-1,-1>,<1,0,1>}}
#local CFtop=intersection{ sphere {<0,0,0>,1}   box{<1,1,1>,<-1,0,-1>}}
#local CoreOuter = sphere{<0,0,0>,1 }    
#local CoreInner = object { CoreOuter scale .75 } 
#local BodyOuter = merge{object{CFbottom scale 1.1} object{CFtop scale <1.1,4,1.1>}}    
#local BodyInner = merge{object{CFbottom scale 1.05} object{CFtop scale <1.05,2,1.05>}}    

#local Body = difference{object{BodyOuter} object{BodyInner}
 texture{pigment{Clear}}
 interior{media{absorption rgb<0.1, 0.1, 0.4> emission rgb<.8,.8, .5>}}
 no_shadow hollow}

#local Core = difference {object{CoreOuter} object{CoreInner}
 texture {pigment{Clear}}
 interior {media{absorption rgb<0.9, 0.9, 0.0> emission rgb<0, 0, 0.9>}}
 no_shadow hollow}


#local CFLayer1 = difference {object{BodyInner} object{CoreOuter}
 texture {pigment{Clear}} 
 interior{media{absorption rgb<0.1, 0.1, 0.9> emission rgb<0.8, 0.8, 0.0>  }}
 no_shadow hollow}

#local Cf1 = union{object{Core} object{CFLayer1} object{Body}}

#local Candleflame1 = light_source {
  <0, .5, 0>
  color rgb <1, 1, 0.5>
 area_light x,y ,1 ,4
 adaptive 0
fade_power  2
  fade_distance 12
  looks_like {Cf1}
  
}

#local FCandle=finish{ambient 0.4 diffuse 0.4 phong 0.5}
#local NCandle=normal{bumps 0.03 scale 0.05}

 #local TCandle=texture{pigment{gradient y 
     colour_map {
      [0.00 colour rgb <1.0,1.0,0.8> ]
      [0.55 colour rgb <1.0,1.0,0.8> ]
      [1.00 colour rgb <2.5,2.5,2.0> ] }  }
  finish {FCandle} normal {NCandle}   }
    
  #local Wick= union{
  cylinder {<0,0,0>,<0,1,0>,.05
   texture {pigment{ gradient y
    colour_map {
     [0.00 Black] 
     [0.50 Black]
     [0.55 OrangeRed*2]
     [0.90 Orange*2]}}
  finish {FCandle} normal {NCandle}}}
  sphere{<0,1,0>,.05 texture {pigment {Orange*2} finish{FCandle} normal{NCandle}}}
  scale <1,.75,1>}
  
 #declare candle=union {
 
 object{ Candleflame1 scale .40  translate <0,7.6,0> } 
     cylinder {<0,0,0>,<0,7,0>, .5 texture {TCandle scale 7}} 
    object{Wick translate y*6.85}    }


