// Persistence of Vision Ray Tracer Include File
// File: sechull.inc
// Vers: 3.5 for Macintosh
// Desc: Tucson Class Starship secondary hull
// Date: 30 June 2002
// Last: 07 August 2003
// Auth: Dawn McKnight (d-mcknight@cox.net)

#ifndef (RoundLock)
	#include "lock.inc"
#end 

#local Sec_Hull_One = 
merge {
	difference {
		Round_Box_Merge(<-17.5, 0, -64>, <17.5, 12, 10>, 2)	
		plane {
			-z
			0.001
			}
			
		} // close difference 
		
	difference {
		object { Round_Cylinder_Merge (0, <0, 12, 0>, 17.5, 2) scale 1.35*z }		
		plane {
			z
			0
			translate -0.001*z
			}
		} // close difference 
	
	} // close merge Sec_Hull_One
	
#local VertGalleyWindow = 
	Round_Box_Merge (<-2.95, 9, -63.5>, <2.95, 13, -59.5>, 0.25);
	
#local VertGalley = difference {
	 union {
		object { VertGalleyWindow }
		object { VertGalleyWindow translate 6.2*x }
		object { VertGalleyWindow translate -6.2*x }
		object { VertGalleyWindow translate 12.4*x }
		object { VertGalleyWindow translate -12.4*x }
		} // close inner union
		
	object { Sec_Hull_One texture { Light_texture } }
	} // close difference VertGalley
	
#local HoriGalleyWindow = 
	Round_Box_Merge (<-2.95, 9.5, -70>, <2.95, 11, -60>, 0.25);
	
#local HoriGalley = difference {
	union {
		object { HoriGalleyWindow }
		object { HoriGalleyWindow translate 6.2*x }
		object { HoriGalleyWindow translate -6.2*x }
		object { HoriGalleyWindow translate 12.4*x }
		object { HoriGalleyWindow translate -12.4*x }
		} // close inner union
		
	object { Sec_Hull_One texture { Light_texture } }
	} // close difference HoriGalley

#local Sec_Hull_Two =	
	difference { 
		object { Sec_Hull_One texture { Hull_texture } }
		object { Sec_Hull_One scale 0.6 texture { Stripe_texture } translate 7.499*y }
		object { VertGalley translate -0.02*y }
		object { HoriGalley translate 0.02*z }
		}  // close difference Sec_Hull_Two
	
#local Bridge_One = 
	superellipsoid {
		<1, 0.5>
		rotate 90*x
		scale <11.5, 6, 11.5>
		scale <1, 1, 1.35>		
		translate 8*y
		} // close Bridge_One
	
#local Bridge_Cutter_One  =
	difference {		
		cylinder {
			<0, 7.5, 0>
			<0, 15, 0>
			6.825
			} // close cylinder
		
		difference {
			cylinder {
				<0, -0.1, 0>
				<0, 16, 0>
				3.6125
				}
			
			cylinder {
				<0, -0.11, 0>
				<0, 16, 0>
				2.6125
				}
				
			
			}
			
		#local BWC = 0;
		
		#while ( BWC < 6 )
			box {
				<-0.5, -0.1, 3.6>
				<0.5, 16, 7>
				rotate (BWC*60)*y
				}
			
			#local BWC = BWC + 1;
		#end
	
		texture { Hull_texture }
		
		} // close difference Bridge_Cutter_One 

#local Bridge_Window_Cutter =	
	difference {
		object { Bridge_Cutter_One }
		object { Bridge_One texture { Light_texture } }
		} // close difference Bridge_Window_Cutter 
		
#local Bridge_Two =
	difference { 
		object { Bridge_One texture { Hull_texture } }
		object { Bridge_Window_Cutter translate -0.05*y }
		} // close difference Bridge_Two 
		
#local Cyl_Trio =
	union {
		cylinder {
			<0, 0, 0>
			<0, 0, 30>
			0.525
			}
			
		cylinder {
			<1.575, 0, 0>
			<1.575, 0, 30>
			0.525
			}
			
		cylinder {
			<-1.575, 0, 0>
			<-1.575, 0, 30>
			0.525
			}
		
		texture { Stripe_texture }
		translate 9*y
		} // close union Cyl_Trio
		
		
#declare Array_Cylinders =
	union {
		
		difference {	
			object { Cyl_Trio }
			
			object { 
				Sec_Hull_One 
				scale 0.998
				texture { Window_texture }
				} // close Sec_Hull_One
				
			} //close difference 
		
		difference {	
			object { Cyl_Trio rotate 30*y }
			
			object { 
				Sec_Hull_One 
				scale 0.998
				texture { Light_texture }
				} // close Sec_Hull_One
				
			} //close difference 
	
		difference {
			object { Cyl_Trio rotate -30*y }
			object { 
				Sec_Hull_One 
				scale 0.998
				texture { Light_texture }
				} // close Sec_Hull_One
				
			} //close difference 
		
		difference {
			object { Cyl_Trio rotate 60*y }
			object { 
				Sec_Hull_One 
				scale 0.998
				texture { Window_texture }
				} // close Sec_Hull_One
				
			} //close difference 
		
		difference {	
			object { Cyl_Trio rotate -60*y }
			object { 
				Sec_Hull_One 
				scale 0.998
				texture { Light_texture }
				} // close Sec_Hull_One
				
			} //close difference 
	
		difference {
			object { Cyl_Trio rotate 90*y }
			object { 
				Sec_Hull_One 
				scale 0.998
				texture { Light_texture }
				} // close Sec_Hull_One
				
			} //close difference 
	
		difference {
			object { Cyl_Trio rotate -90*y }
			object { 
				Sec_Hull_One 
				scale 0.998
				texture { Window_texture }
				} // close Sec_Hull_One
				
			} //close difference 
	
		
		} // close union Array_Cylinders
		

#declare Sec_Hull = 
	union {
		object { Bridge_Two }
		difference {
			object { Sec_Hull_Two }
			object { Array_Cylinders }
			object {
				RoundLock
				rotate -90*y
				translate <17.5, 8.25, -28>
				}
			object {
				RoundLock
				rotate 90*y
				translate <-17.5, 8.25, -28>
				}
			} // close difference 
		} // close union Sec_Hull 