// Persistence of Vision Ray Tracer Scene Description File
// File: saucer.inc
// Vers: 3.1g for Macintosh
// Desc: Tucson Class Starship saucer section
// Date: 30 June 2002
// Last: 21 July 2002
// Auth: Dawn McKnight (d-mcknight@cox.net)

#ifndef(Cylinder_Y)
   #include "shapes.inc"
#end

#ifndef(Hull_texture)
   #include "bistex.inc"
#end

#ifndef (T_Yellow_Glass)
	#include "glass.inc"
#end 

#ifndef (NavLight)
	#include "navlight.inc"
#end 

#local CylPair = union {
	cylinder {
		<0, 0, 1>
		<0, 10, 1>
		0.5
		texture { Stripe_texture }
		}
		
	cylinder {
		<0, 0, -1>
		<0, 10, -1>
		0.5
		texture { Stripe_texture }
		}
	
	} // close union CylPair
	
#local CylTrio = union {
	cylinder {
		<0, 0, 0>
		<0, 10, 0>
		0.5
		}
		
	cylinder {
		<0, 0, 1.5>
		<0, 10, 1.5>
		0.5
		}
		
	cylinder {
		<0, 0, -1.5>
		<0, 10, -1.5>
		0.5
		}
		
	}	




#local Phaser_Strip_One = difference {
	torus {
		21
		.4
		scale 1.35*z
		translate 7.5*y
		texture { 
			radial 
			texture_map {
				[0.0 T_Yellow_Glass ]
				[0.2 T_Yellow_Glass]
				[0.2 T_Orange_Glass ]
				[1.0 T_Orange_Glass ]
				} //close texture_map
			}
		} // close torus
		
	plane {
		z
		0
		}
		
	} // close difference 

#local Cutting_Block = difference {

	box {
		<-40, -9.5, 0>
		<40, 9.5, 20>
		}
		
	cylinder {
		<-41, 0, 0>,
		<41, 0, 0>,
		9.2
		}
	
	} // close Cutting Block

#local Pri_Hull_Base = merge {

	intersection {
		sphere { <0, 0, 0>, 1
			scale <40, 9.2, 54>
			}
				
		plane { -z, -0.03 }
		}// close intersection for front saucer
	
	intersection {
		sphere { <0, 0, 0>, 1
			scale <40, 9.2, 40>
			}
		plane { z, 0.03 }
		} // close intersection for aft saucer
	
	}

#declare Second_Saucer = 
	difference {	
		//this difference takes the egg shaped hull, and cuts pieces off.
		intersection {
			object { Pri_Hull_Base }
	
			plane { -y, 2.5 }
			//Includes everything above 2.5 meters below the origin.
			plane { y, 7.5 }
			//Includes everything below 7.5 meters above the origin.
	
			} // close intersection 
		
		object { Cutting_Block translate 42*z }
		//This cuts off the front of the egg, flattening it... and providing a spot for the torp launchers

		object { 
			Cutting_Block 
			rotate 157.5*y 
			translate -20*z
			translate 10*x
			}
			//This cuts off the starboard aft corner
		
		object { 
			Cutting_Block 
			rotate -157.5*y 
			translate -20*z
			translate -10*x
			}	
			//This cuts off the port aft corner.
		
		object {
			Cutting_Block
			rotate -180*y
			translate -21*z
			}
			//Shortens the back of the saucer.

		difference {
			//This difference as a whole creates the cut-out in the foreward end of the 
			//saucer, where the deflector goes.
			box {
				<-10, 0, 33>
				<10, 10, 85>
				}
			
			cylinder { 
				<-11, 0, 0>,
				<11, 0, 0>,
				9
				scale <1, 1, 0.4>
				translate 33*z
				}

		
			cylinder {
				<0, 0, 0>
				<0, 0, 50>
				9
				scale <0.4, 1, 1>
				rotate 8*y
				translate 30*z
				translate 10*x
				} 
			
			cylinder {
				<0, 0, 0>
				<0, 0, 50>
				9
				scale <0.4, 1, 1>
				rotate -8*y
				translate 30*z
				translate -10*x
				} 

			translate -33*z
			rotate 8*x
			translate 33*z
			translate 4.8*y
			//This manipulates the block that cuts the place for the deflector.
		
			} // close difference 

			
		cone { //This cuts a hole for the deflector to actually fit into.
			<0, 0, -0.3>, 0 // center and radius of one end
			<0, 0, 0.3>, 2 // center and radius of the other end
			scale <3.68, 0.6, 1>
			texture { t_deflec_tex }
			translate <0, 5.4, 36.5>
			}
	
		} // close difference 2nd_saucer

#local Grid_Cyl_A =
	difference {
		cylinder {
			<0, -2, 0>
			<0, 1, 0>
			1
			scale <35, 15, 49>
			}
	
		cylinder {
			<0, -2.1, 0>
			<0, 1, 0>
			1
			scale <34.5, 16, 48.5>
			}
		
		} // close difference Grid_Cyl_A
	
#local Grid_Cyl_B =
	difference {
		cylinder {
			<0, -2, 0>
			<0, 1, 0>
			1
			scale <30.5, 15, 40.5>
			}
	
		cylinder {
			<0, -2.1, 0>
			<0, 1, 0>
			1
			scale <30, 16, 40>
			}
		
		} // close difference Grid_Cyl_B
	
#local Grid_Cyl_C =
	difference {
		cylinder {
			<0, -2, 0>
			<0, 1, 0>
			1
			scale <25.5, 15, 35.5>
			}
	
		cylinder {
			<0, -2.1, 0>
			<0, 1, 0>
			1
			scale <25, 16, 35>
			}
		} // close difference Grid_Cyl_C

#local Adj_Grid_Cyl =
	difference {
		union {
			object { Grid_Cyl_A }
			object { Grid_Cyl_B }
			object { Grid_Cyl_C }
			} // close union of grid cylinders
			
		box {
			<-11, -2, 20>
			<11, 16, 85>
			}
			
			
		box {
			<-60, -5.5, 0>
			<60, 16, 80>
			rotate -157.5*y 
			translate -18*z
			translate -10*x
			}
			
		box {
			<-60, -5.5, 0>
			<60, 16, 80>
			rotate 157.5*y 
			translate -18*z
			translate 10*x
			}
			
		} // close difference Adj_Grid_Cyl

#local GRP = 0;
#local GRN = 0;	
#local GridBoxPositive =
	box {
		<0, -3, -0.25>
		<60, 16, 0.25>
		}	
		
#local GridBoxNegative =
	box {
		<0, -3, -0.25>
		<-60, 16, 0.25>
		}	

		
#local Grid_Radi =
	union {
		#while (GRP < 6)
			object { GridBoxPositive rotate (-12*GRP)*y }
			#declare GRP=GRP+1;
		#end
		
		#while (GRN < 6)
			object { GridBoxNegative rotate (12*GRN)*y }
			#declare GRN=GRN+1;
		#end
		
		object { GridBoxNegative rotate 90*y translate 11*x }
		object { GridBoxNegative rotate 90*y translate -11*x }
		object { GridBoxPositive rotate -157.5*y translate -22*z}
		object { GridBoxNegative rotate 157.5*y translate -22*z }
		
		} // close union Grid_Radi
		
#local Grid_Lines =
	intersection {
		difference {		
			cylinder {
				<0, -2, 0>
				<0, 1, 0>
				1
				scale <35, 15, 49>
				}

			cylinder {
				<0, -2.1, 0>
				<0, 1, 0>
				1
				scale <25, 16, 35>
				}
			} // close difference
			
		object { Grid_Radi }
		} // close intersection Grid_Lines
		
#local Deflector_Grid =
	difference {
		union {
			object { Grid_Lines }
			object { Adj_Grid_Cyl }
			} // close union

		object { Second_Saucer }
		plane { y, -2 }
		
		texture { Stripe_texture }
		}// close difference Deflector_Grid
		
#local Grided_Saucer =
	difference {
		object { Second_Saucer texture { Hull_texture } }
		object { Deflector_Grid translate -0.01*y }
		} // close Gridded Saucer
					
#local Third_Saucer =
	union {
	
		object { 
			NavLight ( Green )
			scale 15
			rotate -90*z
			translate 39.85*x
			}
			
		object {
			NavLight ( Red )
			scale 15
			rotate 90*z
			translate -39.85*x
			}
			
		difference { 
			
			object { Grided_Saucer }
			
			cylinder {
				<39.84, 0, 0>
				<41, 0, 0>
				0.55
				texture { Hull_texture }
				}
											
			cylinder {
				<-39.84, 0, 0>
				<-41, 0, 0>
				0.55
				texture { Hull_texture }
				}
				
			} // close difference
			
		} // close union third_saucer 

#local Sensor_Dish = union {
	
	difference {

		cylinder {
			<0, 0, -0.005>, //base point
			<0, 0, 0.005>, // cap point
			0.5	// radius
			texture { t_sensor_dish }	
			}

		cylinder {
			<0, 0, 0>, // base point
			<0, 0, 0.006> // cap point
			0.4 // radius
			texture { t_sensor_bay }
			}
	
		scale < 10, 1.5, 1>
	
		} // close difference
	
	cylinder {
		<-0.2, 0, -0.004>
		<-0.2, 0, 0.005>
		0.2
		texture { t_sensor_antenna }
		}

	cylinder {
		<0.2, 0, -0.004>
		<0.2, 0, 0.005>
		0.2
		texture { t_sensor_antenna }
		}
			
	translate <0, 5.55, 36.9>

};// close union sensor_dish		
		
#local Phased_Saucer =
	union {
		object { Third_Saucer }
		object { Sensor_Dish }
		object { Phaser_Strip_One }
		}	

#local Window_Saucer = 
difference {

	object { Phased_Saucer }

//begin starboard side portholes, inboard row
	difference {
		object { CylPair rotate -4.44444*y translate <27.4146, 0, 2.9229> }
		object { Second_Saucer scale 0.998 texture { Light_texture }}
		}

	difference {
		object { CylPair rotate -13.3333*y translate <26.7409, 0, 8.6625> }
		object { Second_Saucer scale 0.998 texture {Light_texture}}
		}

	difference {
		object { CylPair rotate -22.2222*y translate <25.172, 0, 14.9463> }
		object { Second_Saucer scale 0.998 texture {Light_texture}}
		}

	difference {
		object { CylTrio rotate -31.1111*y translate <22.8102, 0, 20.7365> }
		object { Second_Saucer scale 0.998 texture {Window_texture}}
		}

	difference {
		object { CylTrio rotate -40*y translate <18.9577, 0, 26.8935> }
		object { Second_Saucer scale 0.998 texture {Window_texture}}
		}

//begin starboard side portholes, outboard row
	difference {
		object { CylPair rotate -4.44444*y translate <32.3935, 0, 3.5999> }
		object { Second_Saucer scale 0.998 texture { Light_texture }}
		}

	difference {
		object { CylPair rotate -13.3333*y translate <31.5777, 0, 10.5259> }
		object { Second_Saucer scale 0.998 texture {Window_texture}}
		}

	difference {
		object { CylTrio rotate -22.2222*y translate <29.9928, 0, 17.1387> }
		object { Second_Saucer scale 0.998 texture {Window_texture}}
		}

	difference {
		object { CylTrio rotate -31.1111*y translate <27.2595, 0, 24.2306> }
		object { Second_Saucer scale 0.998 texture {Light_texture}}
		}

	difference {
		object { CylTrio rotate -40*y translate <23.2841, 0, 31.0455> }
		object { Second_Saucer scale 0.998 texture {Window_texture}}
		}

//begin port side portholes, inboard row
	difference {
		object { CylPair rotate 4.44444*y translate <-27.4146, 0, 2.9229> }
		object { Second_Saucer scale 0.998 texture { Window_texture }}
		}

	difference {
		object { CylPair rotate 13.3333*y translate <-26.7409, 0, 8.6625> }
		object { Second_Saucer scale 0.998 texture {Light_texture}}
		}

	difference {
		object { CylPair rotate 22.2222*y translate <-25.172, 0, 14.9463> }
		object { Second_Saucer scale 0.998 texture {Light_texture}}
		}

	difference {
		object { CylTrio rotate 31.1111*y translate <-22.8102, 0, 20.7365> }
		object { Second_Saucer scale 0.998 texture {Window_texture}}
		}

	difference {
		object { CylTrio rotate 40*y translate <-18.9577, 0, 26.8935> }
		object { Second_Saucer scale 0.998 texture {Window_texture}}
		}

//begin port side portholes, outboard row
	difference {
		object { CylPair rotate 4.44444*y translate <-32.3935, 0, 3.5999> }
		object { Second_Saucer scale 0.998 texture { Light_texture }}
		}

	difference {
		object { CylPair rotate 13.3333*y translate <-31.5777, 0, 10.5259> }
		object { Second_Saucer scale 0.998 texture {Light_texture}}
		}

	difference {
		object { CylTrio rotate 22.2222*y translate <-29.9928, 0, 17.1387> }
		object { Second_Saucer scale 0.998 texture {Light_texture}}
		}

	difference {
		object { CylTrio rotate 31.1111*y translate <-27.2595, 0, 24.2306> }
		object { Second_Saucer scale 0.998 texture {Window_texture}}
		}

	difference {
		object { CylTrio rotate 40*y translate <-23.2841, 0, 31.0455> }
		object { Second_Saucer scale 0.998 texture {Light_texture}}
		}

	}
		
#declare Saucer = 
	object { Window_Saucer }
