// Persistence of Vision Ray Tracer Include File
// File: navlight.inc
// Vers: 3.5 for Macintosh
// Desc: Navigational running lights
// Date: 30 June 2002
// Last: 07 August 2003
// Auth: Dawn McKnight (d-mcknight@cox.net)


// Navigation and running light definition.  Originally written to scale 1 unit = 1 CM, rescaled to
// 1 unit = 1 meter in the last line.  Accepts an argument of light color.  ten centimeters across,
// centered at origin.  Faces positive Y.

#ifndef ( T_Glass3 )
	#include "glass.inc"
#end

// __________ This section defines the navigational running lights _____________

#macro NavLight ( LightColor ) // the navigation light.  Accepts a parameter that tells
								// it what color to be.
union {

	//light_source { <0, 2.5, 0>, LightColor } // what sheds light.  Well, duh.

	difference { // this difference gives us a fixture, instead of a sphere
		merge { // merges the sphere with the torus
			sphere { // the basic shape of the light fixture.  In RL, the glass is colored, but that
					 // didn't work well here, so the light is colored, instead.
				0,
				5
				hollow on
				} // close sphere
			
			torus { // puts a 'lip' on the fixture for aesthetic purposes.
				5,
				1
				hollow on
				} // close torus
			} // close merge
		
		box { // this is the box that cuts the ringed sphere in half.
			<-9, -9, -9>,
			<9, 0, 9>
			} // close box
		
		texture { T_Glass3 } // I tried various glass finishes.  I liked this one best.
		interior { 
			I_Glass 
			media { 
				intervals 2
        		samples 1,2
        		confidence 0.9
        		variance 1/1000
				emission color LightColor 
				absorption color ( <1,1,1>-LightColor )
					density {
                	radial 
                	turbulence 0.0009
                	color_map {
                        [0.0 color rgb <1, 1, 1>*75]
                        [0.2 color rgb <1, 1, 1>*75]
                        [0.4 color rgb <1, 1, 1>*75]
                        [1.0 color rgb <0, 1, 1>]
                		} 
                	}
				} }
		
		} // close difference 

	difference {	// creates the 'glow' by use of scattering media
		sphere { // to hold the media
			0,
			10
			} // close sphere 
		
		box { // cuts it in half, so we don't have any unpredictable results from scattering media
			<-11, -11, -11>,
			<11, 0, 11>
			} // close box
			
		pigment { Clear }
		hollow on
		interior {	
			media { 
				emission LightColor
				scattering { 1, rgbf 0.1 } // rgbf set low so as to get the 'glow' effect.
				//absorption ( <1, 1, 1>-LightColor )
					density {
						spherical 
						scale 9
						color_map {
							[0.0 color rgb <0, 0, 0>]
							[1.0 color rgb <1, 1, 1>]
							}
						}
				} // close media
			} // close interior
		
		} // close difference
	} // close union
	
	scale 0.01
	
#end // macro NavLight

// ______________________ End of Navigation definition _______________________

